/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.installer.midp2.install.steps;

import com.nokia.mj.impl.installer.exetable.ExeBall;
import com.nokia.mj.impl.installer.exetable.ExeStep;
import com.nokia.mj.impl.installer.midp2.install.steps.InstallBall;
import com.nokia.mj.impl.installer.utils.Log;
import com.nokia.mj.impl.rt.installer.ApplicationInfoImpl;
import com.nokia.mj.impl.rt.support.ApplicationInfo;
import com.nokia.mj.impl.security.midp.authentication.AuthenticationModule;
import com.nokia.mj.impl.security.packageprotection.PackageProtector;
import com.nokia.mj.impl.security.packageprotection.ScanCheck;

public class CheckJarPackages
extends ExeStep {
    public void execute(ExeBall aBall) {
        InstallBall ball = (InstallBall)aBall;
        AuthenticationModule.getInstance().setMediaId(ball.iSuite.getUid(), ball.iSuite.getMediaId());
        String domain = AuthenticationModule.getForcedDomainCategory();
        if (domain != null) {
            ApplicationInfoImpl appInfoImpl = (ApplicationInfoImpl)ApplicationInfo.getInstance();
            appInfoImpl.setProtectionDomain(domain);
        }
        boolean touchDetection = true;
        if (ball.getAttributeValue("Nokia-MIDlet-On-Screen-Keypad") != null && ball.iSuite.getOnScreenKeypad() != 0) {
            touchDetection = false;
        }
        if (!touchDetection && ball.iPreinstallation && domain != null && (domain.equals("MFD") || domain.equals("OPD"))) {
            Log.log((String)("Skipping application package check for " + domain + " domain application during preinstallation"));
            return;
        }
        ScanCheck scanChecks = null;
        if (touchDetection) {
            ScanCheck.BaseClassCheck[] baseClassChecks = new ScanCheck.BaseClassCheck[]{new ScanCheck.BaseClassCheck("javax/microedition/lcdui/Canvas"), new ScanCheck.BaseClassCheck("javax/microedition/lcdui/game/GameCanvas"), new ScanCheck.BaseClassCheck("com/nokia/mid/ui/FullCanvas")};
            ScanCheck.MethodCheck[] methodChecks = new ScanCheck.MethodCheck[]{new ScanCheck.MethodCheck("pointerDragged", "(II)V"), new ScanCheck.MethodCheck("pointerPressed", "(II)V"), new ScanCheck.MethodCheck("pointerReleased", "(II)V")};
            scanChecks = new ScanCheck(baseClassChecks, methodChecks);
        } else {
            Log.log((String)"Touch detection is disabled");
        }
        ball.log("Checking application packages for " + ball.iJarFilename);
        PackageProtector pp = PackageProtector.getInstance();
        pp.scanApplication(ball.iJarFilename, scanChecks);
        if (touchDetection && this.isTouchEnabled(scanChecks)) {
            Log.log((String)"Application is touch enabled, disabling on-screen-keypad");
            ball.iSuite.setOnScreenKeypad(0);
        }
    }

    public void cancel(ExeBall aBall) {
    }

    private boolean isTouchEnabled(ScanCheck aScanCheck) {
        Log.log((String)("isTouchEnabled:\n" + aScanCheck));
        int i = 0;
        while (i < aScanCheck.iMethodChecks.length) {
            ScanCheck.MethodCheckResult[] methodResults = aScanCheck.iMethodChecks[i].iResults;
            if (methodResults != null && methodResults.length > 0) {
                int j = 0;
                while (j < methodResults.length) {
                    ScanCheck.MethodCheckResult methodResult = methodResults[j];
                    if (methodResult.iCodeLength > 1 && this.isCanvasClass(methodResult.iClassName, aScanCheck)) {
                        Log.log((String)("Class " + methodResult.iClassName + " inherits from Canvas and implements " + aScanCheck.iMethodChecks[i].iMethodName + " of code length " + methodResult.iCodeLength));
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isCanvasClass(String aClassName, ScanCheck aScanCheck) {
        int i = 0;
        while (i < aScanCheck.iBaseClassChecks.length) {
            if (aScanCheck.iBaseClassChecks[i].iClassNames != null) {
                int j = 0;
                while (j < aScanCheck.iBaseClassChecks[i].iClassNames.length) {
                    if (aClassName.equals(aScanCheck.iBaseClassChecks[i].iClassNames[j])) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }
}

