/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.midp.authentication;

import com.nokia.mj.impl.comms.CommsEndpoint;
import com.nokia.mj.impl.comms.CommsMessage;
import com.nokia.mj.impl.comms.exception.CommsException;
import com.nokia.mj.impl.fileutils.DriveInfo;
import com.nokia.mj.impl.fileutils.DriveUtilities;
import com.nokia.mj.impl.installer.utils.Log;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.security.common.Certificate;
import com.nokia.mj.impl.security.common.InstallerSecurityException;
import com.nokia.mj.impl.security.common.RuntimeSecurityException;
import com.nokia.mj.impl.security.midp.authentication.Credentials;
import com.nokia.mj.impl.security.midp.authentication.OcspChecker;
import com.nokia.mj.impl.security.midp.authentication.OcspEventListener;
import com.nokia.mj.impl.security.midp.authentication.OcspSettings;
import com.nokia.mj.impl.security.midp.authentication.OcspUserPreferences;
import com.nokia.mj.impl.security.midp.common.AuthenticationCredentials;
import com.nokia.mj.impl.security.midp.common.AuthenticationInfo;
import com.nokia.mj.impl.security.midp.common.GeneralSecuritySettings;
import com.nokia.mj.impl.security.midp.common.ProtectionDomain;
import com.nokia.mj.impl.security.midp.common.SigningCertificate;
import com.nokia.mj.impl.security.midp.common.SigningInfo;
import com.nokia.mj.impl.security.midp.storage.AppAccessAuthorizationStorageData;
import com.nokia.mj.impl.security.midp.storage.AuthenticationStorageData;
import com.nokia.mj.impl.security.midp.storage.SecurityStorage;
import com.nokia.mj.impl.security.utils.Logger;
import com.nokia.mj.impl.security.utils.TelUtils;
import com.nokia.mj.impl.storage.StorageSession;
import com.nokia.mj.impl.utils.Tokenizer;
import com.nokia.mj.impl.utils.Uid;
import java.util.Hashtable;
import java.util.Vector;

public final class AuthenticationModule {
    private Hashtable iAuthCredentials = new Hashtable();
    private Hashtable iSelectedAuthCredentials = new Hashtable();
    private Hashtable iOcspCheckers = new Hashtable();
    private Hashtable iOcspEventListeners = new Hashtable();
    private static AuthenticationModule self;
    private static Hashtable iLegacySuiteFlags;
    private static OcspSettings iOcspSettings;
    private static OcspUserPreferences iOcspUserPreferences;
    private static int iSecurityWarningsMode;

    static {
        Log.logOut((String)"ForceDomain for JRT 2.1.18 (Symbian 9.4) by Shinovon");
        Log.logOut((String)("Forced protection domain: " + AuthenticationModule.getForcedDomainName()));
        Jvm.loadSystemLibrary((String)"javasecurity");
        iLegacySuiteFlags = new Hashtable();
        iSecurityWarningsMode = -1;
    }

    public static String getForcedDomainName() {
        String domain = AuthenticationModule.getForcedDomainCategory();
        domain = domain.equalsIgnoreCase("MFD") ? "Manufacturer" : (domain.equalsIgnoreCase("OPD") ? "Operator" : (domain.equalsIgnoreCase("ITPD") ? "IdentifiedThirdParty" : "UnidentifiedThirdParty"));
        return domain;
    }

    public static String getForcedDomainCategory() {
        String domain = System.getProperty("forcedomain");
        domain = domain == null ? "UTPD" : (domain.equalsIgnoreCase("MFD") ? "MFD" : (domain.equalsIgnoreCase("OPD") ? "OPD" : (domain.equalsIgnoreCase("ITPD") ? "ITPD" : "UTPD")));
        return domain;
    }

    public static AuthenticationModule getInstance() {
        if (self == null) {
            self = new AuthenticationModule();
        }
        return self;
    }

    public AuthenticationCredentials[] authenticateJad(Uid msUID, Uid oldMSUID, AuthenticationInfo[] authInfo) {
        Vector allAuthCredentials = null;
        allAuthCredentials = this.verifyUpdate(new Credentials[]{new Credentials(AuthenticationModule.getForcedDomainName(), AuthenticationModule.getForcedDomainCategory(), null, null, -1, null)}, oldMSUID);
        this.iAuthCredentials.put(msUID, allAuthCredentials);
        Object[] credentials = new Credentials[allAuthCredentials.size()];
        allAuthCredentials.copyInto(credentials);
        Logger.logAuthenticationCredentials((Vector)allAuthCredentials);
        return credentials;
    }

    public void authenticateJar(StorageSession storageSession, Uid msUID, Uid oldMSUID, String appJARPath, boolean drmContent) {
        AuthenticationStorageData data = null;
        try {
            String jarHash = this._computeHash(appJARPath);
            if (jarHash == null || jarHash.length() == 0) {
                Logger.logWarning((String)("Could not compute hash for " + appJARPath));
                throw new InstallerSecurityException(108, null, 12, new String[]{"Could not compute hash for " + appJARPath}, 902);
            }
            data = new AuthenticationStorageData(AuthenticationModule.getForcedDomainName(), AuthenticationModule.getForcedDomainCategory(), jarHash, null, null, null, iSecurityWarningsMode);
            this.verifyUpdate(new Credentials[]{new Credentials(data.getProtectionDomain(), data.getProtectionDomainCategory(), jarHash, null, -1, null)}, oldMSUID);
            this.writeAuthenticationStorageData(storageSession, msUID, data, oldMSUID != null && oldMSUID.equals((Object)msUID));
        }
        finally {
            if (data != null) {
                this.iSelectedAuthCredentials.put(msUID, data);
            }
        }
    }

    public void authenticateJar(StorageSession storageSession, Uid uid, Uid oldUid, ProtectionDomain protectionDomain, String appJARPath) {
        if (protectionDomain == null || !protectionDomain.equals((Object)ProtectionDomain.getManufacturerDomain()) && !protectionDomain.equals((Object)ProtectionDomain.getOperatorDomain()) && !protectionDomain.equals((Object)ProtectionDomain.getIdentifiedThirdPartyDomain()) && !protectionDomain.equals((Object)ProtectionDomain.getUnidentifiedThirdPartyDomain())) {
            Logger.logWarning((String)("Unknown protection domain " + protectionDomain));
            throw new InstallerSecurityException(108, null, 12, new String[]{"Unknown protection domain " + protectionDomain}, 902);
        }
        String jarHash = this._computeHash(appJARPath);
        if (jarHash == null || jarHash.length() == 0) {
            Logger.logWarning((String)("Could not compute hash for " + appJARPath));
            throw new InstallerSecurityException(108, null, 12, new String[]{"Could not compute hash for " + appJARPath}, 902);
        }
        AuthenticationStorageData data = new AuthenticationStorageData(protectionDomain.getName(), protectionDomain.getCategory(), jarHash, null, null, null, iSecurityWarningsMode);
        this.verifyUpdate(new Credentials[]{new Credentials(data.getProtectionDomain(), data.getProtectionDomainCategory(), jarHash, null, -1, null)}, oldUid);
        this.writeAuthenticationStorageData(storageSession, uid, data, oldUid != null && oldUid.equals((Object)uid));
    }

    public void registerOcspEventListener(Uid aMsUid, OcspEventListener aListener) {
        if (aMsUid != null && aListener != null) {
            Logger.log((String)("OcspEventListener registered on behalf of the suite " + aMsUid.toString()));
            this.iOcspEventListeners.put(aMsUid, aListener);
        }
    }

    public void unregisterOcspEventListener(Uid aMsUid) {
        if (aMsUid != null) {
            Logger.log((String)("OcspEventListener unregistered on behalf of the suite " + aMsUid.toString()));
            this.iOcspEventListeners.remove(aMsUid);
        }
    }

    public void cancelOcspCheck(Uid msUid) {
        OcspChecker ocspChecker = (OcspChecker)this.iOcspCheckers.get(msUid);
        if (ocspChecker != null) {
            ocspChecker.cancel();
        }
    }

    public SigningInfo getSigningInfo(String aAppSuiteName, String aAppSuiteVersion, String aAppSuiteVendor) {
        SecurityStorage storage = new SecurityStorage();
        try {
            AuthenticationStorageData authData = storage.readAuthenticationStorageData(aAppSuiteName, aAppSuiteVersion, aAppSuiteVendor, 7);
            if (authData != null) {
                Certificate signingCert = null;
                Certificate rootCert = null;
                AppAccessAuthorizationStorageData appAccesAuthData = storage.readAppAccessAuthorizationStorageData(aAppSuiteName, aAppSuiteVersion, aAppSuiteVendor, 4);
                if (appAccesAuthData != null && appAccesAuthData.getSignersList() != null && appAccesAuthData.getSignersList().length > 0) {
                    signingCert = this._parseCertificate(appAccesAuthData.getSignersList()[0]);
                    rootCert = this._getRootCertificate(authData.getRootHashValue());
                }
                SigningInfo signingInfo = new SigningInfo(signingCert, rootCert, new ProtectionDomain(authData.getProtectionDomain(), authData.getProtectionDomainCategory()));
                return signingInfo;
            }
            return null;
        }
        finally {
            storage.close();
        }
    }

    public void removeSecurityData(StorageSession storageSession, Uid msUID) {
        Logger.log((String)"Remove authentication data");
        SecurityStorage storage = new SecurityStorage(storageSession);
        storage.removeAuthenticationStorageData(msUID);
        this.iAuthCredentials.remove(msUID);
        this.iSelectedAuthCredentials.remove(msUID);
        iLegacySuiteFlags.remove(msUID);
        OcspChecker ocspChecker = (OcspChecker)this.iOcspCheckers.remove(msUID);
        if (ocspChecker != null) {
            ocspChecker.destroy();
        }
        this.iOcspEventListeners.remove(msUID);
    }

    public SigningCertificate[] getCertificatesDetails(StorageSession storageSession, Uid msUID) {
        Vector allAuthCredentials = (Vector)this.iAuthCredentials.get(msUID);
        Object[] certDetails = null;
        if (allAuthCredentials != null && allAuthCredentials.size() > 0) {
            Vector<SigningCertificate> vCertDetails = new Vector<SigningCertificate>();
            int i = 0;
            while (i < allAuthCredentials.size()) {
                Credentials credentials = (Credentials)allAuthCredentials.elementAt(i);
                Certificate cert = credentials.signingCert;
                if (cert != null) {
                    vCertDetails.addElement(new SigningCertificate(cert, credentials.rootHashValue, credentials.getProtectionDomainName(), credentials.getProtectionDomainCategory()));
                }
                ++i;
            }
            if (vCertDetails.size() > 0) {
                certDetails = new SigningCertificate[vCertDetails.size()];
                vCertDetails.copyInto(certDetails);
            }
        } else {
            SecurityStorage storage = new SecurityStorage(storageSession);
            SigningCertificate signingCertificate = this.retrieveSigningCertificate(storage, msUID);
            if (signingCertificate != null) {
                certDetails = new SigningCertificate[]{signingCertificate};
            }
        }
        return certDetails;
    }

    public String getProtectionDomainCategory(StorageSession storageSession, Uid msUID) {
        SecurityStorage storage = new SecurityStorage(storageSession);
        return storage.readProtectionDomainCategory(msUID);
    }

    public void setMediaId(StorageSession aStorageSession, Uid aMsUid, int aMediaId) {
        if (this.isDriveProtected(aMediaId)) {
            SecurityStorage storage = new SecurityStorage(aStorageSession);
            try {
                AuthenticationStorageData authStorageData = (AuthenticationStorageData)this.iSelectedAuthCredentials.get(aMsUid);
                if (authStorageData != null) {
                    Logger.log((String)"Suite installed on protected media -> the runtime tamper detection is disabled");
                    authStorageData.setJarHashValue(null);
                    storage.writeAuthenticationStorageData(aMsUid, authStorageData, true);
                }
            }
            finally {
                this.iSelectedAuthCredentials.remove(aMsUid);
            }
        }
    }

    public void setOCSPFlags(OcspSettings ocspSettings) {
        Logger.log((String)("Ocsp settings = " + ocspSettings.toString()));
        iOcspSettings = ocspSettings;
    }

    public void cleanup() {
        Logger.log((String)"Cleanup authentication module cache");
        this.iAuthCredentials.clear();
        this.iSelectedAuthCredentials.clear();
        iLegacySuiteFlags.clear();
        this.iOcspCheckers.clear();
        this.iOcspEventListeners.clear();
    }

    public void verifyMIDletSuiteAuthenticity(Uid msUid, AuthenticationStorageData authStorageData) {
        Logger.log((String)("Verifying the authenticity of the suite " + msUid.toString()));
        if ("OPD".equals(authStorageData.getProtectionDomainCategory())) {
            Logger.log((String)"  Checking network restrictions for operator signed suites");
            SecurityStorage storage = new SecurityStorage();
            String networkRestrictions = storage.readNetworkRestrictions(msUid);
            storage.close();
            if (networkRestrictions != null && networkRestrictions.length() > 0) {
                TelUtils.NetworkCodes networkCodes = TelUtils.getNetworkCodes();
                boolean found = false;
                if (networkCodes != null) {
                    Logger.log((String)("    Network restrictions: " + networkRestrictions));
                    Logger.log((String)("    Network codes: mcc(" + networkCodes.mcc + ") mnc(" + networkCodes.mnc + ")"));
                    String[] tuples = Tokenizer.split((String)networkRestrictions, (String)" ");
                    if (tuples != null) {
                        int i = 0;
                        while (i < tuples.length) {
                            int mccEndPos = tuples[i].indexOf(45);
                            String mcc = tuples[i].substring(0, mccEndPos);
                            String mnc = tuples[i].substring(mccEndPos + 1);
                            if (mcc.equals(networkCodes.mcc) && mnc.equals(networkCodes.mnc)) {
                                found = true;
                                break;
                            }
                            ++i;
                        }
                    }
                }
                if (!found) {
                    Logger.logWarning((String)"  -> the network restrictions are violated");
                    throw new RuntimeSecurityException(204, null, 6, null);
                }
                Logger.log((String)"  -> the network restrictions are obeyed");
            }
        }
        if (authStorageData.getRootHashValue() != null && authStorageData.getRootHashValue().length() > 0) {
            Logger.log((String)"  Checking validity of the root certificate used in authentication");
            switch (this.retrieveRootState(authStorageData.getRootHashValue())) {
                case 1: {
                    Logger.log((String)"    Root ok");
                    break;
                }
                case 2: {
                    Logger.logWarning((String)"    Root disabled");
                    throw new RuntimeSecurityException(202, null, 2, null);
                }
                case 4: {
                    Logger.logWarning((String)"    Root deleted");
                    throw new RuntimeSecurityException(202, null, 3, null);
                }
                case 16: {
                    Logger.logWarning((String)"    Root not available");
                    throw new RuntimeSecurityException(202, null, 4, null);
                }
                case 8: {
                    Logger.logWarning((String)"    Root unknown");
                    throw new RuntimeSecurityException(202, null, 5, null);
                }
            }
        }
        if (authStorageData.getJarPath() == null || authStorageData.getJarPath().length() == 0) {
            Logger.logWarning((String)"  JarPath not available");
            throw new RuntimeSecurityException(203, null, 5, null);
        }
        if (authStorageData.getJarHashValue() != null && authStorageData.getJarHashValue().length() > 0) {
            Logger.log((String)"  Doing tamper detection");
            String computedJarHash = this._computeHash(authStorageData.getJarPath());
            if (computedJarHash == null || !computedJarHash.equals(authStorageData.getJarHashValue())) {
                Logger.logWarning((String)"    Application has been tampered");
                throw new RuntimeSecurityException(201, null, 1, null);
            }
        }
    }

    private AuthenticationModule() {
        iOcspSettings = new OcspSettings(0, 0, false, "0", "0");
        iOcspUserPreferences = new OcspUserPreferences();
        iSecurityWarningsMode = GeneralSecuritySettings.getDefaultSecurityWarningsMode();
        Logger.log((String)("Ocsp user preferences = " + iOcspUserPreferences.toString()));
    }

    private SigningCertificate retrieveSigningCertificate(SecurityStorage storage, Uid msUID) {
        Certificate cert;
        SigningCertificate signingCertificate = null;
        AppAccessAuthorizationStorageData authData = storage.readAppAccessAuthorizationStorageData(msUID, 4);
        if (authData != null && authData.getSignersList() != null && authData.getSignersList().length > 0 && (cert = this._parseCertificate(authData.getSignersList()[0])) != null) {
            AuthenticationStorageData signingData = storage.readAuthenticationStorageData(msUID);
            signingCertificate = new SigningCertificate(cert, signingData.getRootHashValue(), signingData.getProtectionDomain(), signingData.getProtectionDomainCategory());
        }
        return signingCertificate;
    }

    private Vector verifyUpdate(Credentials[] credentials, Uid oldMSUID) {
        return this.verifyUpdate(this.isLegacySuite(oldMSUID), credentials, oldMSUID, false);
    }

    private Vector verifyUpdate(boolean legacyMIDletSuite, Credentials[] credentials, Uid oldMSUID, boolean orderResult) {
        int i;
        Vector<Object> allCredentials;
        block17: {
            allCredentials = new Vector<Object>(credentials.length);
            i = 0;
            while (i < credentials.length) {
                allCredentials.addElement(credentials[i]);
                ++i;
            }
            if (oldMSUID != null) {
                SecurityStorage storage = new SecurityStorage();
                Vector<Credentials> sameSignerCredentials = new Vector<Credentials>();
                Vector<Credentials> differentSignerCredentials = new Vector<Credentials>();
                try {
                    ProtectionDomain oldProtectionDomain = new ProtectionDomain(storage.readProtectionDomain(oldMSUID), storage.readProtectionDomainCategory(oldMSUID));
                    int i2 = 0;
                    while (i2 < credentials.length) {
                        if (oldProtectionDomain.equals((Object)credentials[i2].getProtectionDomain())) {
                            SigningCertificate oldSigningCertificate = this.retrieveSigningCertificate(storage, oldMSUID);
                            SigningCertificate newSigningCertificate = new SigningCertificate(credentials[i2].signingCert, credentials[i2].rootHashValue, credentials[i2].getProtectionDomainName(), credentials[i2].getProtectionDomainCategory());
                            if (newSigningCertificate.isSameSigner(oldSigningCertificate)) {
                                sameSignerCredentials.addElement(credentials[i2]);
                            } else if (legacyMIDletSuite) {
                                differentSignerCredentials.addElement(credentials[i2]);
                            }
                        } else if (legacyMIDletSuite && !"UTPD".equals(credentials[i2].getProtectionDomain().getCategory())) {
                            differentSignerCredentials.addElement(credentials[i2]);
                        }
                        ++i2;
                    }
                    if (sameSignerCredentials.size() != 0) {
                        allCredentials = sameSignerCredentials;
                        break block17;
                    }
                    if (differentSignerCredentials.size() != 0) {
                        allCredentials = differentSignerCredentials;
                        break block17;
                    }
                    throw new InstallerSecurityException(105, null, 10, null, 910);
                }
                finally {
                    storage.close();
                }
            }
        }
        if (orderResult) {
            i = 0;
            int size = allCredentials.size();
            while (i < size) {
                Credentials current = (Credentials)allCredentials.elementAt(i);
                if (current.getProtectionDomainName() == null || current.getProtectionDomainCategory() == null) {
                    Object last = allCredentials.lastElement();
                    allCredentials.setElementAt(last, i);
                    allCredentials.setElementAt(current, size - 1);
                    --size;
                    continue;
                }
                ++i;
            }
        }
        return allCredentials;
    }

    private boolean isLegacySuite(Uid msUID) {
        if (msUID == null) {
            return true;
        }
        Boolean tmp = (Boolean)iLegacySuiteFlags.remove(msUID);
        if (tmp != null) {
            return tmp;
        }
        SecurityStorage storage = new SecurityStorage();
        String suiteVersion = storage.readSuiteVersion(msUID);
        storage.close();
        if (suiteVersion != null) {
            boolean legacySuite = !suiteVersion.equalsIgnoreCase("MIDP-3.0");
            iLegacySuiteFlags.put(msUID, new Boolean(legacySuite));
            return legacySuite;
        }
        return true;
    }

    private String getRoot(String rootHash) {
        CommsEndpoint comms = null;
        try {
            comms = new CommsEndpoint();
            comms.connect(10000);
            CommsMessage sMessage = new CommsMessage();
            sMessage.setMessageId(101);
            sMessage.setModuleId(7);
            sMessage.write(1);
            sMessage.write(2);
            sMessage.write(1);
            sMessage.write(1);
            sMessage.write(rootHash);
            sMessage.write(7);
            CommsMessage rMessage = comms.sendReceive(sMessage, 10);
            String tmp = rMessage.readString();
            if (tmp != null && tmp.length() > 0) {
                String string = rMessage.readString();
                return string;
            }
        }
        catch (CommsException commsException) {
        }
        finally {
            if (comms != null) {
                comms.destroy();
            }
        }
        return null;
    }

    private int retrieveRootState(String rootHash) {
        CommsEndpoint comms = null;
        try {
            comms = new CommsEndpoint();
            comms.connect(10000);
            CommsMessage sMessage = new CommsMessage();
            sMessage.setMessageId(101);
            sMessage.setModuleId(7);
            sMessage.write(1);
            sMessage.write(1);
            sMessage.write(rootHash);
            sMessage.write(6);
            CommsMessage rMessage = comms.sendReceive(sMessage, 10);
            int n = rMessage.readInt();
            return n;
        }
        catch (CommsException commsException) {
        }
        finally {
            if (comms != null) {
                comms.destroy();
            }
        }
        return 8;
    }

    private boolean performOcsp() {
        if (AuthenticationModule.iOcspSettings.ocspMode != 0) {
            return AuthenticationModule.iOcspSettings.ocspMode == 1;
        }
        return iOcspUserPreferences.getOcspMode() == 1 || iOcspUserPreferences.getOcspMode() == 2;
    }

    private boolean isDriveProtected(int aMediaId) {
        DriveInfo[] allDrives = DriveUtilities.getAllDrives();
        if (allDrives != null) {
            int i = 0;
            while (i < allDrives.length) {
                if ((long)aMediaId == allDrives[i].iId) {
                    if (allDrives[i].iIsRemovable) {
                        return false;
                    }
                    return !allDrives[i].iIsExternallyMountable;
                }
                ++i;
            }
        }
        return false;
    }

    private Credentials selectCredentials(String selectedJarHash, Vector allAuthCredentials, Vector validatedChainIndexes) {
        Credentials selectedCredentials = null;
        if (selectedJarHash != null) {
            int i = 0;
            while (i < allAuthCredentials.size()) {
                Credentials authCredentials = (Credentials)allAuthCredentials.elementAt(i);
                if (selectedJarHash.equalsIgnoreCase(authCredentials.jarHashValue)) {
                    if (selectedCredentials == null) {
                        selectedCredentials = new Credentials(authCredentials.getProtectionDomainName(), authCredentials.getProtectionDomainCategory(), authCredentials.jarHashValue, authCredentials.rootHashValue, -1, null);
                    }
                    validatedChainIndexes.addElement(new Integer(authCredentials.validatedChainIndex));
                }
                ++i;
            }
        }
        return selectedCredentials;
    }

    private void writeAuthenticationStorageData(StorageSession storageSession, Uid uid, AuthenticationStorageData data, boolean isUpdate) {
        if (storageSession == null) {
            return;
        }
        SecurityStorage storage = new SecurityStorage(storageSession);
        storage.writeAuthenticationStorageData(uid, data, isUpdate);
        Logger.logAuthenticationData((AuthenticationStorageData)data);
    }

    private native Credentials[] _validateChainsAndSignatures(AuthenticationInfo[] var1);

    private native String _computeHash(String var1);

    private native String _drmDecryptAndComputeHash(String var1);

    private native Certificate _parseCertificate(String var1);

    private native Certificate _getRootCertificate(String var1);
}

