/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.Deflate;
import com.jcraft.jzlib.ZStream;
import java.io.IOException;

public final class Deflater
extends ZStream {
    private boolean finished = false;

    public Deflater() {
    }

    public Deflater(int level, int bits) throws IOException {
        this(level, bits, false);
    }

    public Deflater(int level, int bits, boolean nowrap) throws IOException {
        int ret = this.init(level, bits, nowrap);
        if (ret != 0) {
            throw new IOException(String.valueOf(ret) + ": " + this.msg);
        }
    }

    public int init(int level, int bits, boolean nowrap) {
        this.finished = false;
        this.dstate = new Deflate(this);
        return this.dstate.deflateInit(level, nowrap ? -bits : bits);
    }

    public int deflate(int flush) {
        if (this.dstate == null) {
            return -2;
        }
        int ret = this.dstate.deflate(flush);
        if (ret == 1) {
            this.finished = true;
        }
        return ret;
    }

    public int end() {
        this.finished = true;
        if (this.dstate == null) {
            return -2;
        }
        int ret = this.dstate.deflateEnd();
        this.dstate = null;
        this.free();
        return ret;
    }

    public boolean finished() {
        return this.finished;
    }
}

