/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.CRC32;
import com.jcraft.jzlib.Deflate;

public class ZStream {
    public byte[] next_in;
    public int next_in_index;
    public int avail_in;
    public long total_in;
    public byte[] next_out;
    public int next_out_index;
    public int avail_out;
    public long total_out;
    public String msg;
    Deflate dstate;
    int data_type;
    CRC32 adler;

    public ZStream() {
        this(new CRC32());
    }

    public ZStream(CRC32 adler) {
        this.adler = adler;
    }

    public int deflate(int flush) {
        if (this.dstate == null) {
            return -2;
        }
        return this.dstate.deflate(flush);
    }

    void flush_pending() {
        int len = this.dstate.pending;
        if (len > this.avail_out) {
            len = this.avail_out;
        }
        if (len == 0) {
            return;
        }
        if (this.dstate.pending_buf.length > this.dstate.pending_out && this.next_out.length > this.next_out_index && this.dstate.pending_buf.length >= this.dstate.pending_out + len) {
            this.next_out.getClass();
        }
        System.arraycopy(this.dstate.pending_buf, this.dstate.pending_out, this.next_out, this.next_out_index, len);
        this.next_out_index += len;
        this.dstate.pending_out += len;
        this.total_out += (long)len;
        this.avail_out -= len;
        this.dstate.pending -= len;
        if (this.dstate.pending == 0) {
            this.dstate.pending_out = 0;
        }
    }

    int read_buf(byte[] buf, int start, int size) {
        int len = this.avail_in;
        if (len > size) {
            len = size;
        }
        if (len == 0) {
            return 0;
        }
        this.avail_in -= len;
        if (this.dstate.wrap != 0) {
            this.adler.update(this.next_in, this.next_in_index, len);
        }
        System.arraycopy(this.next_in, this.next_in_index, buf, start, len);
        this.next_in_index += len;
        this.total_in += (long)len;
        return len;
    }

    public void free() {
        this.next_in = null;
        this.next_out = null;
        this.msg = null;
    }

    public void setOutput(byte[] buf, int off, int len) {
        this.next_out = buf;
        this.next_out_index = off;
        this.avail_out = len;
    }

    public void setInput(byte[] buf, int off, int len, boolean append) {
        if (len <= 0 && append && this.next_in != null) {
            return;
        }
        if (this.avail_in > 0 && append) {
            byte[] tmp = new byte[this.avail_in + len];
            System.arraycopy(this.next_in, this.next_in_index, tmp, 0, this.avail_in);
            System.arraycopy(buf, off, tmp, this.avail_in, len);
            this.next_in = tmp;
            this.next_in_index = 0;
            this.avail_in += len;
        } else {
            this.next_in = buf;
            this.next_in_index = off;
            this.avail_in = len;
        }
    }

    public int end() {
        return 0;
    }

    public boolean finished() {
        return false;
    }
}

