/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.StreamConnection;
import net.comcraft.src.NetHandler;
import net.comcraft.src.Packet;
import net.comcraft.src.PacketDisconnect;
import net.comcraft.src.PacketLogin;
import net.comcraft.src.Player;
import net.comcraft.src.Server;

public class PlayerThread
implements Runnable {
    private StreamConnection playerSock;
    private NetHandler handler;
    private boolean running = false;
    private DataInputStream dis;
    private DataOutputStream dos;
    private Vector sendQueue;
    private Player player;

    public PlayerThread(StreamConnection streamConnection, NetHandler handler) {
        this.playerSock = streamConnection;
        this.handler = handler;
        this.sendQueue = new Vector();
    }

    public void run() {
        try {
            this.dis = this.playerSock.openDataInputStream();
            this.dos = this.playerSock.openDataOutputStream();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        this.running = true;
        new Thread(new SendThread(this, null, null)).start();
        while (this.running) {
            try {
                if (this.readPackets()) continue;
            }
            catch (IOException var5) {
                var5.printStackTrace();
                this.disconnectPlayer("disconnect.socketIOError Server could not read packet");
            }
            break;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException var3) {
            var3.printStackTrace();
        }
        try {
            this.dis.close();
            this.playerSock.close();
        }
        catch (IOException var2) {
            var2.printStackTrace();
        }
        this.playerDisconnect();
        Server.log(String.valueOf(this.player.getName()) + " left the game.");
    }

    private boolean readPackets() throws IOException {
        int id = this.dis.read() & 0xFF;
        Packet p = Packet.getNewPacket(new Integer(id));
        p.readData(this.dis);
        p.process(this.player, this);
        return true;
    }

    public NetHandler getHandler() {
        return this.handler;
    }

    private void sendPackets() throws IOException {
        if (this.sendQueue.isEmpty()) {
            return;
        }
        this.dos.write(this.sendQueue.size());
        int i = 0;
        while (i < this.sendQueue.size()) {
            Packet p = (Packet)this.sendQueue.elementAt(i);
            try {
                this.dos.write(p.getPacketId());
                p.writeData(this.dos);
            }
            catch (IOException e) {
                e.printStackTrace();
                Server.log("Packet " + p + " did not successfully send");
            }
            ++i;
        }
        this.dos.flush();
        this.sendQueue.removeAllElements();
    }

    public void playerDisconnect() {
        this.running = false;
        try {
            this.playerSock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.handler.deletePlayer(this.player);
    }

    public void disconnectPlayer(String reason) {
        Server.log("Disconnect Player (" + this.player.getName() + ") REASON: " + reason);
        this.sendPacket(new PacketDisconnect(reason));
    }

    public void sendPacket(Packet packet) {
        this.sendQueue.addElement(packet);
    }

    public void handleLogin(PacketLogin packetLogin, Player player) {
        this.player = player;
        Server.log(String.valueOf(player.getName()) + " logged in at (" + player.xPos + ", " + player.yPos + ", " + player.zPos + ")");
        if (packetLogin.clientCompatVer != 2) {
            this.disconnectPlayer("disconnect.kick Server version not compatible");
            return;
        }
        this.handler.handleLogin(player);
    }

    public void handleDisconnect(float rotationPitch, float rotationYaw) {
        this.player.rotationPitch = rotationPitch;
        this.player.rotationYaw = rotationYaw;
        this.running = false;
    }

    protected Player getPlayer() {
        return this.player;
    }

    class SendThread
    implements Runnable {
        final PlayerThread this$01;

        private SendThread(PlayerThread var1) {
            this.this$01 = var1;
        }

        public void run() {
            while (this.this$01.running) {
                try {
                    PlayerThread.this.sendPackets();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException var3) {
                        var3.printStackTrace();
                    }
                    Thread.yield();
                }
                catch (IOException var4) {
                    var4.printStackTrace();
                    this.this$01.disconnectPlayer("disconnect.socketIOError Server could not send packet");
                }
            }
            try {
                PlayerThread.this.dos.close();
            }
            catch (IOException var2) {
                var2.printStackTrace();
            }
        }

        /* synthetic */ SendThread(PlayerThread playerThread2, SendThread sendThread, SendThread sendThread2) {
            this(playerThread2);
        }
    }
}

