/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.server;

import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import net.comcraft.server.ServerMIDlet;
import net.comcraft.server.SettingsForm;
import net.comcraft.src.Server;

public class ServerForm
extends Form
implements CommandListener {
    private static Command startCmd = new Command("Start", 7, 3);
    private static Command stopCmd = new Command("Stop", 7, 2);
    private static Command exitCmd = new Command("Exit", 8, 3);
    private static Command deleteCmd = new Command("Delete world", 8, 1);
    private static Command settingsCmd = new Command("Settings", 8, 2);
    private StringItem stateItem;
    private StringItem memUsageItem;
    private Server server;
    private TextField portField;
    private TextField playersField;
    private boolean dontLog;
    private SettingsForm settingsForm;

    public ServerForm(Server server) {
        super("Comcraft Server");
        server.setUI(this);
        this.server = server;
        this.setCommandListener(this);
        this.stateItem = new StringItem("Server State", "Stopped");
        this.append((Item)this.stateItem);
        this.memUsageItem = new StringItem("Memory usage", "");
        this.append((Item)this.memUsageItem);
        this.append("\nProperties:\n");
        this.portField = new TextField("Port", server.settings != null ? "" + server.settings.port : "9999", 6, 2);
        this.append((Item)this.portField);
        this.playersField = new TextField("Players", "", 1024, 131072);
        this.append((Item)this.playersField);
        this.addCommand(startCmd);
        this.addCommand(deleteCmd);
        this.addCommand(exitCmd);
        this.addCommand(settingsCmd);
        this.settingsForm = new SettingsForm(server, this);
        this.memUsage();
    }

    public void commandAction(Command c, Displayable d) {
        block20: {
            if (c == stopCmd) {
                this.removeCommand(c);
                this.addCommand(startCmd);
                if (this.server.isRunning()) {
                    this.server.stop();
                }
            } else if (c == deleteCmd) {
                if (!this.server.isRunning()) {
                    FileConnection fc;
                    String root = this.server.getRoot();
                    if (!root.startsWith("file://")) {
                        root = "file:///" + root;
                    }
                    if (!root.endsWith("/")) {
                        root = String.valueOf(root) + "/";
                    }
                    try {
                        fc = (FileConnection)Connector.open((String)(String.valueOf(root) + "world.data"));
                        fc.truncate(0L);
                        fc.delete();
                        fc.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        fc = (FileConnection)Connector.open((String)(String.valueOf(root) + "level.info"));
                        fc.truncate(0L);
                        fc.delete();
                        fc.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else if (c == startCmd) {
                this.removeCommand(c);
                this.addCommand(stopCmd);
                this.server.settings.port = Integer.parseInt(this.portField.getString());
                try {
                    if (this.server.start()) {
                        this.running();
                        break block20;
                    }
                    this.failed();
                }
                catch (Exception e) {
                    this.failed();
                    Server.log("Failed to start: " + e);
                }
            } else if (c == settingsCmd) {
                Display.getDisplay((MIDlet)ServerMIDlet.ins).setCurrent((Displayable)this.settingsForm);
            } else if (c == exitCmd) {
                ServerMIDlet.ins.destroyApp(false);
            }
        }
        this.memUsage();
    }

    public void memUsage() {
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long allocated = total - free;
        this.memUsage(allocated / 1024L + "/" + total / 1024L + "K (" + free / 1024L + "K free)");
    }

    public void memUsage(String s) {
        this.memUsageItem.setText(s);
    }

    public void failed() {
        this.removeCommand(startCmd);
        this.removeCommand(stopCmd);
        this.addCommand(startCmd);
        this.stateItem.setText("Failed");
        this.memUsage();
    }

    public void running() {
        this.removeCommand(startCmd);
        this.removeCommand(stopCmd);
        this.addCommand(stopCmd);
        this.stateItem.setText("Running");
        this.memUsage();
    }

    public void stopped() {
        this.removeCommand(startCmd);
        this.removeCommand(stopCmd);
        this.addCommand(startCmd);
        this.stateItem.setText("Stopped");
        this.memUsage();
    }

    public void log(String l) {
        if (this.dontLog) {
            return;
        }
        this.append(String.valueOf(l) + "\n");
    }

    public void nicks(String s) {
        if (s == null) {
            this.playersField.setString("");
        } else {
            this.playersField.setString(String.valueOf(this.playersField.getString()) + s);
        }
    }
}

