/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.server;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.ServerSocketConnection;
import net.comcraft.server.PlayerThread;
import net.comcraft.src.NetHandler;
import net.comcraft.src.Server;

public class ServerThread
implements Runnable {
    private ServerSocketConnection server;
    private int port;
    private boolean running;
    private NetHandler handler;
    private Vector players;

    public ServerThread(String ip, int port, NetHandler handler) {
        this.port = port;
        this.handler = handler;
        this.players = new Vector();
    }

    public void run() {
        block5: {
            try {
                this.server = (ServerSocketConnection)Connector.open((String)("socket://:" + this.port));
                this.running = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                Server.log("Unable to start server. Error: " + e);
                return;
            }
            Server.log("Server is running (" + (System.currentTimeMillis() - Server.startTime) + " ms)");
            try {
                do {
                    PlayerThread player = new PlayerThread(this.server.acceptAndOpen(), this.handler);
                    this.players.addElement(player);
                    new Thread(player).start();
                    Server.memUsage();
                } while (this.running);
            }
            catch (IOException e) {
                if (!this.running) break block5;
                Server.log("Force stop server");
                e.printStackTrace();
                this.stop();
            }
        }
    }

    public void stop() {
        this.running = false;
        int size = this.players.size();
        System.out.println("There are " + size + " players");
        int i = 0;
        while (i < size) {
            PlayerThread player = (PlayerThread)this.players.elementAt(0);
            player.disconnectPlayer("disconnect.kick Server stopping");
            player.getHandler().deletePlayer(player.getPlayer());
            ++i;
        }
        try {
            this.server.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Server.log("Server Stopped");
    }

    public void removePlayer(PlayerThread playerThread) {
        if (this.players.contains(playerThread)) {
            this.players.removeElement(playerThread);
        }
    }

    public boolean isRunning() {
        return this.running;
    }
}

