/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class Settings {
    private String file;
    private Hashtable properties = new Hashtable();
    public String ip = "127.0.0.1";
    public int port = 9999;
    public int worldSize = 16;
    public String worldType = "NORMAL";
    public int flatLevel = 12;
    public boolean generateTrees = false;
    public boolean allowcommands = false;

    public Settings(String root) throws IOException {
        if (!root.startsWith("file://")) {
            root = "file:///" + root;
        }
        if (!root.endsWith("/")) {
            root = String.valueOf(root) + "/";
        }
        this.file = String.valueOf(root) + "server.properties";
        this.defaults();
        try {
            FileConnection fc = (FileConnection)Connector.open((String)this.file);
            if (!fc.exists()) {
                fc.create();
            } else {
                try {
                    InputStream is = fc.openInputStream();
                    char[] chars = new char[8000];
                    InputStreamReader isr = new InputStreamReader(is, "UTF-8");
                    isr.read(chars);
                    isr.close();
                    is.close();
                    String x = "";
                    boolean cmt = false;
                    int i = 0;
                    while (i < chars.length) {
                        char c = chars[i];
                        if (c == '\u0000') break;
                        if (c == '#' && x.length() <= 1) {
                            cmt = true;
                        }
                        if (c == '\n') {
                            if (!cmt && x != null && x.length() > 2) {
                                int splitLoc = x.indexOf("=");
                                this.properties.put(x.substring(0, splitLoc), x.substring(splitLoc + 1, x.length()).replace('\r', '\u0000'));
                            }
                            cmt = false;
                            x = "";
                        } else {
                            x = String.valueOf(x) + String.valueOf(c);
                        }
                        ++i;
                    }
                    x = null;
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            fc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadSettings();
    }

    public void loadSettings() {
        this.ip = (String)this.properties.get("ip");
        this.port = Integer.parseInt((String)this.properties.get("port"));
        this.worldSize = Integer.parseInt((String)this.properties.get("worldSize"));
        this.worldType = (String)this.properties.get("worldType");
        this.flatLevel = Integer.parseInt((String)this.properties.get("flatLevel"));
        this.generateTrees = ((String)this.properties.get("generateTrees")).equalsIgnoreCase("true");
        this.allowcommands = ((String)this.properties.get("allowcommands")).equalsIgnoreCase("true");
    }

    private void defaults() throws IOException {
        boolean needSaveFlag = false;
        if (!this.properties.containsKey("ip")) {
            this.properties.put("ip", this.ip);
            needSaveFlag = true;
        }
        if (!this.properties.containsKey("port")) {
            this.properties.put("port", new Integer(this.port).toString());
            needSaveFlag = true;
        }
        if (!this.properties.containsKey("worldSize")) {
            this.properties.put("worldSize", new Integer(this.worldSize).toString());
            needSaveFlag = true;
        }
        if (!this.properties.containsKey("worldType")) {
            this.properties.put("worldType", this.worldType);
            needSaveFlag = true;
        }
        if (!this.properties.containsKey("flatLevel")) {
            this.properties.put("flatLevel", new Integer(this.flatLevel).toString());
            needSaveFlag = true;
        }
        if (!this.properties.containsKey("generateTrees")) {
            this.properties.put("generateTrees", new Boolean(this.generateTrees).toString());
            needSaveFlag = true;
        }
        if (!this.properties.containsKey("allowcommands")) {
            this.properties.put("allowcommands", new Boolean(this.allowcommands).toString());
            needSaveFlag = true;
        }
        try {
            Integer.parseInt((String)this.properties.get("port"));
        }
        catch (NumberFormatException e) {
            this.properties.put("port", new Integer(this.port).toString());
            needSaveFlag = true;
        }
        try {
            Integer.parseInt((String)this.properties.get("worldSize"));
        }
        catch (NumberFormatException e) {
            this.properties.put("worldSize", new Integer(this.worldSize).toString());
            needSaveFlag = true;
        }
        try {
            Integer.parseInt((String)this.properties.get("flatLevel"));
        }
        catch (NumberFormatException e) {
            this.properties.put("flatLevel", new Integer(this.flatLevel).toString());
            needSaveFlag = true;
        }
        if (needSaveFlag) {
            this.saveFile();
        }
    }

    public void save() {
        this.properties.put("ip", this.ip);
        this.properties.put("port", "" + this.port);
        this.properties.put("worldSize", "" + this.worldSize);
        this.properties.put("worldType", this.worldType);
        this.properties.put("flatLevel", "" + this.flatLevel);
        this.properties.put("generateTrees", "" + this.generateTrees);
        this.properties.put("allowcommands", "" + this.allowcommands);
        this.saveFile();
    }

    public void saveFile() {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)this.file);
            if (!fc.exists()) {
                fc.create();
            }
            try {
                OutputStream os = fc.openOutputStream();
                String s = "";
                Enumeration vals = this.properties.elements();
                Enumeration keys = this.properties.keys();
                while (keys.hasMoreElements()) {
                    s = String.valueOf(s) + keys.nextElement() + "=" + vals.nextElement() + "\n";
                }
                s = s.substring(0, s.length() - 1);
                os.write(s.getBytes("UTF-8"));
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            fc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

