/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.server;

import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import net.comcraft.server.ServerForm;
import net.comcraft.server.ServerMIDlet;
import net.comcraft.src.Server;

public class SettingsForm
extends Form
implements CommandListener {
    private static Command backCmd = new Command("Back", 8, 1);
    private Server server;
    private ServerForm serverForm;
    private Gauge flatLevel;
    private TextField worldSize;
    private ChoiceGroup worldType;
    private ChoiceGroup otherChecks;

    public SettingsForm(Server server, ServerForm serverForm) {
        super("Server settings");
        this.server = server;
        this.serverForm = serverForm;
        this.setCommandListener(this);
        this.flatLevel = new Gauge("Flat Level", true, 29, server.settings.flatLevel);
        this.flatLevel.setMaxValue(29);
        this.flatLevel.setValue(server.settings.flatLevel);
        this.worldSize = new TextField("World Size", "" + server.settings.worldSize, 3, 2);
        this.worldSize.setLabel("World Size");
        this.worldSize.setString("" + server.settings.worldSize);
        this.worldType = new ChoiceGroup("World Type", 1);
        this.worldType.append("NORMAL", null);
        this.worldType.append("FLAT", null);
        if (server.settings.worldType.equals("FLAT")) {
            this.worldType.setSelectedIndex(1, true);
        } else {
            this.worldType.setSelectedIndex(0, true);
        }
        this.otherChecks = new ChoiceGroup("", 2);
        this.otherChecks.append("Allow Commands", null);
        this.otherChecks.append("Generate Trees", null);
        if (server.settings.allowcommands) {
            this.otherChecks.setSelectedIndex(0, true);
        } else {
            this.otherChecks.setSelectedIndex(0, false);
        }
        if (server.settings.generateTrees) {
            this.otherChecks.setSelectedIndex(1, true);
        } else {
            this.otherChecks.setSelectedIndex(1, false);
        }
        this.append((Item)this.flatLevel);
        this.append((Item)this.worldSize);
        this.append((Item)this.worldType);
        this.append((Item)this.otherChecks);
        this.addCommand(backCmd);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == backCmd) {
            if (this.flatLevel.getValue() > 0) {
                this.server.settings.flatLevel = this.flatLevel.getValue();
            }
            this.server.settings.worldSize = Integer.parseInt(this.worldSize.getString());
            this.server.settings.worldType = this.worldType.getSelectedIndex() == 0 ? "NORMAL" : (this.worldType.getSelectedIndex() == 1 ? "FLAT" : "NORMAL");
            this.server.settings.allowcommands = this.otherChecks.isSelected(0);
            this.server.settings.generateTrees = this.otherChecks.isSelected(1);
            this.server.settings.save();
            Display.getDisplay((MIDlet)ServerMIDlet.ins).setCurrent((Displayable)this.serverForm);
        }
    }
}

