/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import net.comcraft.src.ChunkStorage;
import net.comcraft.src.World;

public class Chunk {
    public final int xPos;
    public final int zPos;
    private ChunkStorage[] blockStorageArray;
    private World world;
    private boolean isEdited;

    public Chunk(World world, int chunkX, int chunkZ) {
        this.world = world;
        this.xPos = chunkX;
        this.zPos = chunkZ;
        this.blockStorageArray = new ChunkStorage[8];
    }

    public ChunkStorage[] getBlockStorageArray() {
        return this.blockStorageArray;
    }

    public void setBlockStorageArray(ChunkStorage[] blockStorage) {
        this.blockStorageArray = blockStorage;
    }

    public boolean setBlockIDWithMetadata(int x, int y, int z, int id, int metadata) {
        this.isEdited = true;
        if (x == 0) {
            this.world.getChunkFromChunkCoords(this.xPos - 1, this.zPos);
        } else if (x == 3) {
            this.world.getChunkFromChunkCoords(this.xPos + 1, this.zPos);
        }
        if (z == 0) {
            this.world.getChunkFromChunkCoords(this.xPos, this.zPos - 1);
        } else if (z == 3) {
            this.world.getChunkFromChunkCoords(this.xPos, this.zPos + 1);
        }
        ChunkStorage blockStorage = this.blockStorageArray[y >> 2];
        if (blockStorage == null) {
            if (id == 0) {
                return false;
            }
            ChunkStorage chunkStorage = new ChunkStorage();
            this.blockStorageArray[y >> 2] = chunkStorage;
            blockStorage = chunkStorage;
        }
        blockStorage.setBlockID(x, y & 3, z, id);
        blockStorage.setBlockMetadata(x, y & 3, z, metadata);
        return true;
    }
}

