/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Random;
import net.comcraft.src.Block;
import net.comcraft.src.ChunkGenerator;
import net.comcraft.src.ChunkStorage;
import net.comcraft.src.SimplexNoise;

public class ChunkGeneratorNormal
extends ChunkGenerator {
    private SimplexNoise heightNoise;
    private SimplexNoise flowersNoise;
    private SimplexNoise treesNoise;
    private SimplexNoise biomNoise;
    private boolean generateTrees;

    public ChunkGeneratorNormal(long seed, boolean generateTrees) {
        super(seed);
        this.heightNoise = new SimplexNoise(new Random(seed));
        this.flowersNoise = new SimplexNoise(new Random(seed - 231L));
        this.treesNoise = new SimplexNoise(new Random(seed - 781L));
        this.biomNoise = new SimplexNoise(new Random(seed - 6281L));
        this.generateTrees = generateTrees;
    }

    public ChunkStorage[] generateChunk(int chunkX, int chunkZ) {
        ChunkStorage[] blockStorages = new ChunkStorage[8];
        int i = 0;
        while (i < 8) {
            blockStorages[i] = new ChunkStorage();
            ++i;
        }
        int[][] heightLevel = new int[4][4];
        int[][] biomTab = new int[4][4];
        int z = 0;
        while (z < 4) {
            int x = 0;
            while (x < 4) {
                int level;
                int biom;
                float m = (float)this.biomNoise.noise2D((float)(chunkX * 4 + x) / 85.0f, (float)(chunkZ * 4 + z) / 85.0f);
                biomTab[x][z] = biom = (double)m > 0.35 ? 1 : 0;
                float n = (float)this.heightNoise.noise2D((float)(chunkX * 4 + x) / 24.0f, (float)(chunkZ * 4 + z) / 24.0f);
                heightLevel[x][z] = level = 9 + (int)Math.floor(n * (float)(biom == 0 ? 5 : 2));
                ++x;
            }
            ++z;
        }
        int y = 0;
        while (y < 32) {
            ChunkStorage blockStorageTemp = blockStorages[y >> 2];
            int z2 = 0;
            while (z2 < 4) {
                int x = 0;
                while (x < 4) {
                    if (blockStorageTemp.getBlockID(x, y & 3, z2) == 0) {
                        int id = 0;
                        int metadata = 0;
                        int level = heightLevel[x][z2];
                        int biom = biomTab[x][z2];
                        if (y == 0) {
                            id = Block.getBlock((String)"bedrock").blockID;
                        } else if (y >= 1 && y <= 2) {
                            id = Block.getBlock((String)"stone").blockID;
                        } else if (y >= 3 && y <= 10) {
                            int i2 = this.random.nextInt(y);
                            if (i2 == 0) {
                                id = Block.getBlock((String)"stone").blockID;
                            } else {
                                int n = id = biom == 0 ? Block.getBlock((String)"dirt").blockID : Block.getBlock((String)"sandStone").blockID;
                            }
                        }
                        if (y < level - 1 && y >= 11) {
                            int n = id = biom == 0 ? Block.getBlock((String)"dirt").blockID : Block.getBlock((String)"sand").blockID;
                        }
                        if (y == level - 1) {
                            int n = id = biom == 0 ? Block.getBlock((String)"dirt").blockID : Block.getBlock((String)"sand").blockID;
                        }
                        if (y == level) {
                            int n = id = biom == 0 ? Block.getBlock((String)"grass").blockID : Block.getBlock((String)"sand").blockID;
                        }
                        if (y == level + 1) {
                            float n;
                            id = 0;
                            if (biom == 0 && (chunkX * 4 + x) % (this.random.nextInt(2) + 1) == 0 && (chunkZ * 4 + z2) % (this.random.nextInt(2) + 1) == 0) {
                                float n2 = (float)this.flowersNoise.noise2D((float)(chunkX * 4 + x) / 24.0f, (float)(chunkZ * 4 + z2) / 24.0f);
                                if (n2 > 0.6f && n2 < 0.69f) {
                                    id = Block.getBlock((String)"redFlower").blockID;
                                }
                                if (n2 < -0.6f && n2 > -0.69f) {
                                    id = Block.getBlock((String)"yellowFlower").blockID;
                                }
                            }
                            if (biom == 0 && this.generateTrees && (chunkX * 4 + x) % (this.random.nextInt(2) + 1) == 0 && (chunkZ * 4 + z2) % (this.random.nextInt(2) + 1) == 0 && (n = (float)this.treesNoise.noise2D((float)(chunkX * 4 + x) / 75.0f, (float)(chunkZ * 4 + z2) / 75.0f)) > 0.75f) {
                                id = Block.getBlock((String)"treePlant").blockID;
                            }
                        }
                        if (y > level + 1) {
                            id = 0;
                        }
                        blockStorageTemp.setBlockID(x, y & 3, z2, id);
                        blockStorageTemp.setBlockMetadata(x, y & 3, z2, metadata);
                    }
                    ++x;
                }
                ++z2;
            }
            ++y;
        }
        return blockStorages;
    }
}

