/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.comcraft.src.Chunk;
import net.comcraft.src.ChunkManager;
import net.comcraft.src.ChunkStorage;
import net.comcraft.src.World;

public class ChunkLoader {
    private World world;
    private FileConnection fc;
    private InputStream fis;
    private DataOutputStream dos;
    private String file;
    private int currenPosition;
    private boolean readWriteFlag;
    private boolean isAlive;

    public ChunkLoader(World world, String root) {
        this.world = world;
        this.isAlive = true;
        if (!root.startsWith("file://")) {
            root = "file:///" + root;
        }
        if (!root.endsWith("/")) {
            root = String.valueOf(root) + "/";
        }
        this.file = String.valueOf(root) + "world.data";
    }

    public void onChunkLoaderEnd() {
        this.isAlive = false;
        while (this.readWriteFlag) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        try {
            if (this.fis != null) {
                this.fis.close();
                this.fc.close();
            }
            if (this.dos != null) {
                this.dos.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public Chunk loadChunk(int x, int z) {
        return this.readChunkFromFile(x, z);
    }

    public void saveChunks(Hashtable chunksList) {
        this.writeChunksToFile(chunksList);
    }

    private Chunk readChunkFromFile(int x, int z) {
        if (!this.isAlive) {
            return null;
        }
        this.readWriteFlag = true;
        int bytesToSkip = (x + z * this.world.worldSize) * 1024;
        if (this.fis == null || this.currenPosition > bytesToSkip) {
            try {
                if (this.fis != null) {
                    this.fis.close();
                }
                this.fis = Connector.openInputStream((String)this.file);
                this.currenPosition = 0;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        try {
            this.fis.skip(bytesToSkip - this.currenPosition);
            this.currenPosition = bytesToSkip + 1024;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Chunk chunk = new Chunk(this.world, x, z);
        ChunkStorage[] blockStorage = new ChunkStorage[8];
        int i = 0;
        while (i < blockStorage.length) {
            blockStorage[i] = new ChunkStorage();
            byte[] id = new byte[64];
            byte[] metadata = new byte[64];
            try {
                this.fis.read(id);
                this.fis.read(metadata);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            blockStorage[i].setBlockIDArray(id);
            blockStorage[i].setBlockMetadataArray(metadata);
            blockStorage[i].initBlockStorage();
            ++i;
        }
        chunk.setBlockStorageArray(blockStorage);
        this.readWriteFlag = false;
        return chunk;
    }

    private void writeChunksToFile(Hashtable chunksList) {
        if (!this.isAlive) {
            return;
        }
        this.readWriteFlag = true;
        try {
            if (this.fis != null) {
                this.fis.close();
            }
            if (this.fc != null) {
                this.fc.close();
            }
            InputStream f = Connector.openInputStream((String)this.file);
            byte[] buff = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int i = 0;
            while ((i = f.read(buff)) > 0) {
                baos.write(buff, 0, i);
            }
            f.close();
            byte[] data = baos.toByteArray();
            baos.close();
            this.fis = new ByteArrayInputStream(data);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        this.startSavingBlockStorage();
        int z = 0;
        while (z < this.world.worldSize) {
            int x = 0;
            while (x < this.world.worldSize) {
                Chunk chunk = (Chunk)chunksList.get(ChunkManager.getChunkID(x, z, this.world.worldSize));
                if (chunk != null) {
                    try {
                        this.fis.skip(1024L);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    ChunkStorage[] blockStorage = chunk.getBlockStorageArray();
                    this.saveBlockStorage(blockStorage);
                } else {
                    byte[] data = new byte[1024];
                    try {
                        this.fis.read(data);
                        ((OutputStream)this.dos).write(data);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                ++x;
            }
            ++z;
        }
        this.endSavingBlockStorage();
        try {
            if (this.fis != null) {
                this.fis.close();
            }
            if (this.fc != null) {
                this.fc.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.fis = null;
        try {
            this.fc = (FileConnection)Connector.open((String)this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.readWriteFlag = false;
    }

    public void startSavingBlockStorage() {
        try {
            this.dos = Connector.openDataOutputStream((String)this.file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void saveBlockStorage(ChunkStorage[] blockStorage) {
        if (this.dos == null) {
            return;
        }
        int i = 0;
        while (i < 8) {
            try {
                ((OutputStream)this.dos).write(blockStorage[i].getBlockIDArray());
                ((OutputStream)this.dos).write(blockStorage[i].getBlockMetadataArray());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            ++i;
        }
    }

    public void endSavingBlockStorage() {
        try {
            this.dos.close();
            this.dos = null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

