/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Hashtable;
import net.comcraft.src.Chunk;
import net.comcraft.src.ChunkLoader;
import net.comcraft.src.World;

public class ChunkManager {
    private Hashtable chunksMap;
    private Chunk[][] chunksTable;
    private World world;
    private ChunkLoader chunkLoader;

    public ChunkManager(ChunkLoader chunkLoader, World world) {
        this.world = world;
        this.chunkLoader = chunkLoader;
        this.chunksMap = new Hashtable(1024);
        this.chunksTable = new Chunk[world.worldSize][world.worldSize];
    }

    public Chunk getChunk(int x, int z) {
        if (x < 0 || x >= this.world.worldSize || z < 0 || z >= this.world.worldSize) {
            return null;
        }
        Chunk chunk = this.chunksTable[x][z];
        if (chunk == null) {
            chunk = (Chunk)this.chunksMap.get(ChunkManager.getChunkID(x, z, this.world.worldSize));
            if (chunk == null) {
                chunk = this.loadChunk(x, z);
            }
            this.chunksTable[x][z] = chunk;
        }
        return chunk;
    }

    public Chunk loadChunk(int x, int z) {
        if (x < 0 || x >= this.world.worldSize || z < 0 || z >= this.world.worldSize) {
            return null;
        }
        Integer id = ChunkManager.getChunkID(x, z, this.world.worldSize);
        x = ChunkManager.getDecodedChunkX(id, this.world.worldSize);
        z = ChunkManager.getDecodedChunkZ(id, this.world.worldSize);
        Chunk chunk = this.chunkLoader.loadChunk(x, z);
        this.chunksMap.put(ChunkManager.getChunkID(x, z, this.world.worldSize), chunk);
        return chunk;
    }

    public static Integer getChunkID(int x, int z, int worldSize) {
        return new Integer(x + z * worldSize);
    }

    public static int getDecodedChunkX(Integer chunkId, int worldSize) {
        int id = chunkId;
        return id % worldSize;
    }

    public static int getDecodedChunkZ(Integer chunkId, int worldSize) {
        int id = chunkId;
        return (id - ChunkManager.getDecodedChunkX(chunkId, worldSize)) / worldSize;
    }

    public void saveAllChunks() {
        this.chunkLoader.saveChunks(this.chunksMap);
    }

    public void onChunkProviderEnd() {
        this.chunkLoader.onChunkLoaderEnd();
    }
}

