/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import net.comcraft.server.PlayerThread;
import net.comcraft.src.PacketBlockChange;
import net.comcraft.src.PacketChunkData;
import net.comcraft.src.PacketDisconnect;
import net.comcraft.src.PacketLogin;
import net.comcraft.src.PacketPlayerData;
import net.comcraft.src.PacketWorldInfo;
import net.comcraft.src.Player;

public abstract class Packet {
    private static final Hashtable IdToClass = new Hashtable();
    private static final Hashtable ClassToId = new Hashtable();

    static {
        Packet.registerPacket(new PacketLogin().getClass(), 1);
        Packet.registerPacket(new PacketWorldInfo().getClass(), 4);
        Packet.registerPacket(new PacketPlayerData().getClass(), 6);
        Packet.registerPacket(new PacketChunkData().getClass(), 7);
        Packet.registerPacket(new PacketBlockChange().getClass(), 10);
        Packet.registerPacket(new PacketDisconnect().getClass(), 255);
    }

    private static void registerPacket(Class p, int id) {
        IdToClass.put(new Integer(id), p);
        ClassToId.put(p, new Integer(id));
    }

    public static Packet getNewPacket(Integer id) throws IOException {
        try {
            if (!IdToClass.containsKey(id)) {
                throw new IOException("Unknown Packet ID " + id);
            }
            return (Packet)((Class)IdToClass.get(id)).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        Class<?> cls = this.getClass();
        return "[" + cls.getName() + "] ID: " + ClassToId.get(cls);
    }

    public final int getPacketId() {
        return (Integer)ClassToId.get(this.getClass());
    }

    public abstract void writeData(DataOutputStream var1) throws IOException;

    public abstract void readData(DataInputStream var1) throws IOException;

    public abstract void process(Player var1, PlayerThread var2);
}

