/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.comcraft.server.PlayerThread;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.Packet;
import net.comcraft.src.Player;
import net.comcraft.src.Vec3D;

public class PacketPlayerData
extends Packet {
    private DataInputStream dis;
    private int action;
    private int pId;
    private Object data;
    private int itmIndex;

    public PacketPlayerData() {
    }

    public PacketPlayerData(Player player, int action) {
        this.data = player.getPosition();
        this.pId = player.getId();
        this.action = action;
    }

    public void writeData(DataOutputStream dos) throws IOException {
        dos.write(this.action);
        dos.writeInt(this.pId);
        switch (this.action) {
            case 1: {
                dos.writeFloat(((Vec3D)this.data).x);
                dos.writeFloat(((Vec3D)this.data).y);
                dos.writeFloat(((Vec3D)this.data).z);
                break;
            }
            case 3: {
                dos.writeFloat(((Vec3D)this.data).x);
                dos.writeFloat(((Vec3D)this.data).y);
                dos.writeFloat(((Vec3D)this.data).z);
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                dos.write(this.itmIndex);
                dos.writeShort(((InvItemStack)this.data).itemID);
                dos.write(((InvItemStack)this.data).stackSize);
            }
        }
    }

    public void readData(DataInputStream dis) throws IOException {
        this.action = dis.read() & 0xFF;
        switch (this.action) {
            case 1: {
                this.dis = dis;
                break;
            }
            case 3: {
                this.pId = dis.readInt();
                this.data = new Vec3D(dis.readFloat(), dis.readFloat(), dis.readFloat());
                break;
            }
            case 4: {
                this.itmIndex = dis.read();
                this.data = new InvItemStack(dis.readShort(), dis.read());
            }
        }
    }

    public void process(Player player, PlayerThread playerThread) {
        switch (this.action) {
            case 1: {
                try {
                    player.loadFromDataInputStream(this.dis, playerThread.getHandler().getWorld().getWorldInfo().getVersion());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            case 3: {
                playerThread.getHandler().handlePlayerMove(player, (Vec3D)this.data);
                break;
            }
            case 4: {
                player.inventory.setItemStackAt(this.itmIndex, (InvItemStack)this.data);
            }
        }
    }
}

