/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.comcraft.server.PlayerThread;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.InventoryPlayer;
import net.comcraft.src.NetHandler;
import net.comcraft.src.Packet;
import net.comcraft.src.Vec3D;

public class Player {
    private static final Player spawnPlayer = new Player();
    public float xPos;
    public float yPos;
    public float zPos;
    public float rotationYaw = 225.0f;
    public float rotationPitch = 340.0f;
    public boolean commandsAllowed = false;
    public InventoryPlayer inventory;
    private PlayerThread playerThread;
    private int uniqueId;
    private String name;

    public Player(PlayerThread playerThread) {
        this.playerThread = playerThread;
        this.inventory = new InventoryPlayer();
    }

    private Player() {
        this.inventory = new InventoryPlayer();
        this.xPos = 32.0f;
        this.yPos = 15.0f;
        this.zPos = 32.0f;
    }

    public void setPlayerOnWorldCenter(int worldSize) {
        this.xPos = worldSize * 4 / 2;
        this.yPos = 15.0f;
        this.zPos = worldSize * 4 / 2;
    }

    public void sendPacket(Packet p) {
        this.playerThread.sendPacket(p);
    }

    protected PlayerThread getThread(NetHandler handler) {
        if (handler == this.playerThread.getHandler()) {
            return this.playerThread;
        }
        throw new RuntimeException("The method cannot be accessed at this time.");
    }

    protected void setId(int uniqueId, String username) {
        this.uniqueId = uniqueId;
        this.name = username;
    }

    protected int getId() {
        return this.uniqueId;
    }

    public String getName() {
        return this.name;
    }

    public void savePlayer(String root, float worldVersion) throws IOException {
        FileConnection file;
        if (!root.startsWith("file://")) {
            root = "file:///" + root;
        }
        if (!root.endsWith("/")) {
            root = String.valueOf(root) + "/";
        }
        if (!(file = (FileConnection)Connector.open((String)(String.valueOf(root) + "players/" + this.uniqueId + ".dat"))).exists()) {
            file.create();
        }
        DataOutputStream dos = file.openDataOutputStream();
        this.writeToDataOutputStream(dos, worldVersion);
        dos.close();
        file.close();
    }

    public void loadPlayer(String root, float worldVersion) {
        if (!root.startsWith("file://")) {
            root = "file:///" + root;
        }
        if (!root.endsWith("/")) {
            root = String.valueOf(root) + "/";
        }
        try {
            FileConnection file = (FileConnection)Connector.open((String)(String.valueOf(root) + "players/" + this.uniqueId + ".dat"));
            if (!file.exists()) {
                file.create();
            }
            DataInputStream dis = file.openDataInputStream();
            this.loadFromDataInputStream(dis, worldVersion);
            dis.close();
        }
        catch (IOException e) {
            this.mergePlayer(spawnPlayer);
        }
    }

    public void mergePlayer(Player source) {
        this.xPos = source.xPos;
        this.yPos = source.yPos;
        this.zPos = source.zPos;
        this.rotationYaw = source.rotationYaw;
        this.rotationPitch = source.rotationPitch;
        this.inventory = source.inventory;
        this.commandsAllowed = source.commandsAllowed;
    }

    public Vec3D getPosition() {
        return new Vec3D(this.xPos, this.yPos, this.zPos);
    }

    public void loadFromDataInputStream(DataInputStream dis, float worldVersion) throws IOException {
        this.xPos = dis.readFloat();
        this.yPos = dis.readFloat();
        this.zPos = dis.readFloat();
        this.rotationPitch = dis.readFloat();
        this.rotationYaw = dis.readFloat();
        int fastSlotSize = dis.readInt();
        int n = 0;
        while (n < fastSlotSize) {
            int id = dis.readInt();
            int stackSize = 1;
            if (worldVersion >= 5.0f) {
                stackSize = dis.read();
            }
            this.inventory.setItemStackAt(n, new InvItemStack(id, stackSize));
            ++n;
        }
        this.commandsAllowed = dis.readBoolean();
    }

    public void writeToDataOutputStream(DataOutputStream dos, float worldVersion) throws IOException {
        dos.writeFloat(this.xPos);
        dos.writeFloat(this.yPos);
        dos.writeFloat(this.zPos);
        dos.writeFloat(this.rotationPitch);
        dos.writeFloat(this.rotationYaw);
        dos.writeInt(this.inventory.getFastSlotSize());
        int n = 0;
        while (n < this.inventory.getFastSlotSize()) {
            InvItemStack stack = this.inventory.getItemStackAt(n);
            dos.writeInt(stack != null ? stack.itemID : 0);
            dos.write(stack != null ? stack.stackSize : 0);
            ++n;
        }
        dos.writeBoolean(this.commandsAllowed);
    }

    public static Player getSpawnPlayer() {
        return spawnPlayer;
    }

    public int getDataSize() {
        return 24 + this.inventory.getFastSlotSize() * 5 + 1;
    }
}

