/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.comcraft.server.ServerForm;
import net.comcraft.server.ServerThread;
import net.comcraft.server.Settings;
import net.comcraft.src.Chunk;
import net.comcraft.src.NetHandler;
import net.comcraft.src.PacketBlockChange;
import net.comcraft.src.PacketChunkData;
import net.comcraft.src.PacketPlayerData;
import net.comcraft.src.PacketWorldInfo;
import net.comcraft.src.Player;
import net.comcraft.src.Vec3D;
import net.comcraft.src.World;

public class Server
implements NetHandler {
    public static Server inst;
    public Settings settings;
    private ServerThread server = null;
    private World world;
    private Vector players;
    private String root;
    private Vector pListObserver = new Vector();
    public static long startTime;
    private static ServerForm ui;

    public Server(String root) {
        inst = this;
        this.root = root;
        try {
            this.settings = new Settings(this.root);
        }
        catch (IOException e) {
            e.printStackTrace();
            Server.log("Unable to load properties file. Error: " + e);
        }
        this.settings.loadSettings();
    }

    public boolean start() {
        FileConnection pDir;
        startTime = System.currentTimeMillis();
        if (ui != null) {
            ui.running();
        }
        this.players = new Vector();
        Server.log("Attempting to start MIDlet Comcraft Server (Version 0.2.2)");
        String root = this.root;
        if (!root.startsWith("file://")) {
            root = "file:///" + root;
        }
        if (!root.endsWith("/")) {
            root = String.valueOf(root) + "/";
        }
        try {
            pDir = (FileConnection)Connector.open((String)(String.valueOf(root) + "players"));
        }
        catch (IOException e1) {
            return false;
        }
        if (!pDir.exists()) {
            try {
                pDir.mkdir();
            }
            catch (IOException e) {
                Server.log("Could not create players directory");
                return false;
            }
        }
        Server.log("Loaded Settings");
        Server.log("Starting server on " + this.settings.ip + ":" + this.settings.port);
        this.server = new ServerThread(this.settings.ip, this.settings.port, this);
        try {
            this.world = new World(root, this.settings);
        }
        catch (IOException e) {
            e.printStackTrace();
            Server.log("Failed to load world. Error: " + e);
            return false;
        }
        new Thread(this.server).start();
        Server.gc();
        return true;
    }

    public static void log(String x) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        String h = "" + cal.get(11);
        String m = "" + cal.get(12);
        String s = "" + cal.get(13);
        if (h.length() < 2) {
            h = "0" + h;
        }
        if (m.length() < 2) {
            m = "0" + m;
        }
        if (s.length() < 2) {
            s = "0" + s;
        }
        String date = String.valueOf(h) + ":" + m + ":" + s;
        String l = "[" + date + "] " + x;
        System.out.println(l);
        if (ui != null) {
            ui.log(l);
        }
    }

    public void stop() {
        if (ui != null) {
            ui.stopped();
        }
        Server.log("Attempting to stop server");
        this.server.stop();
        this.world.saveWorld();
        Server.gc();
    }

    public boolean isRunning() {
        if (this.server == null) {
            return false;
        }
        return this.server.isRunning();
    }

    public void handleBlockChange(Player fromPlayer, PacketBlockChange packetBlockChange) {
        int i = 0;
        while (i < this.players.size()) {
            Player player = (Player)this.players.elementAt(i);
            if (!player.equals(fromPlayer)) {
                player.sendPacket(packetBlockChange);
            }
            ++i;
        }
        Chunk chunk = this.world.getChunkFromChunkCoords(packetBlockChange.chunkX, packetBlockChange.chunkZ);
        chunk.setBlockIDWithMetadata(packetBlockChange.x, packetBlockChange.y, packetBlockChange.z, packetBlockChange.id, packetBlockChange.metadata);
    }

    public void handleChunkData(PacketChunkData p) {
        p.setChunk(this.world.getChunkFromChunkCoords(p.x, p.z));
    }

    public void handleWorldInfo(PacketWorldInfo p) {
        p.setWorld(this.world);
        Object[] pp = new Player[this.players.size()];
        this.players.copyInto(pp);
        p.setPlayerList((Player[])pp);
    }

    public void addPlayer(Player player) {
        player.loadPlayer(this.root, this.world.getWorldInfo().getVersion());
        this.players.addElement(player);
        String[] s = new String[this.players.size()];
        if (ui != null) {
            ui.nicks(null);
        }
        int p = 0;
        while (p < this.players.size()) {
            String n;
            s[p] = n = ((Player)this.players.elementAt(p)).getName();
            if (ui != null) {
                ui.nicks(String.valueOf(n) + "\n");
            }
            ++p;
        }
        int i = 0;
        while (i < this.pListObserver.size()) {
            ++i;
        }
    }

    public void deletePlayer(Player player) {
        System.out.println("deletePlayer " + player.getName());
        try {
            player.savePlayer(this.root, this.world.getWorldInfo().getVersion());
        }
        catch (IOException e) {
            e.printStackTrace();
            Server.log("Unable to save player data");
        }
        this.players.removeElement(player);
        this.server.removePlayer(player.getThread(this));
        this.sendDataToAllOtherPlayers(player, 2);
        String[] s = new String[this.players.size()];
        if (ui != null) {
            ui.nicks(null);
        }
        int p = 0;
        while (p < this.players.size()) {
            String n;
            s[p] = n = ((Player)this.players.elementAt(p)).getName();
            if (ui != null) {
                ui.nicks(String.valueOf(n) + "\n");
            }
            ++p;
        }
        int i = 0;
        while (i < this.pListObserver.size()) {
            ++i;
        }
    }

    public void handleLogin(Player player) {
        this.sendDataToAllOtherPlayers(player, 1);
    }

    private void sendDataToAllOtherPlayers(Player causedBy, int action) {
        if (this.isRunning()) {
            int i = 0;
            while (i < this.players.size()) {
                if (this.players.elementAt(i) != causedBy) {
                    ((Player)this.players.elementAt(i)).sendPacket(new PacketPlayerData(causedBy, action));
                }
                ++i;
            }
        }
    }

    public void handlePlayerMove(Player player, Vec3D data) {
        player.xPos = data.x;
        player.yPos = data.y;
        player.zPos = data.z;
        this.sendDataToAllOtherPlayers(player, 3);
    }

    public World getWorld() {
        return this.world;
    }

    public void setUI(ServerForm serverForm) {
        ui = serverForm;
    }

    public String getRoot() {
        return this.root;
    }

    public static void memUsage() {
        if (ui != null) {
            ui.memUsage();
        }
    }

    public static void gc() {
        System.gc();
        Server.memUsage();
    }
}

