/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Random;

public class SimplexNoise {
    private static Grad[] grad3 = new Grad[]{new Grad(1.0, 1.0, 0.0), new Grad(-1.0, 1.0, 0.0), new Grad(1.0, -1.0, 0.0), new Grad(-1.0, -1.0, 0.0), new Grad(1.0, 0.0, 1.0), new Grad(-1.0, 0.0, 1.0), new Grad(1.0, 0.0, -1.0), new Grad(-1.0, 0.0, -1.0), new Grad(0.0, 1.0, 1.0), new Grad(0.0, -1.0, 1.0), new Grad(0.0, 1.0, -1.0), new Grad(0.0, -1.0, -1.0)};
    private static Grad[] grad4 = new Grad[]{new Grad(0.0, 1.0, 1.0, 1.0), new Grad(0.0, 1.0, 1.0, -1.0), new Grad(0.0, 1.0, -1.0, 1.0), new Grad(0.0, 1.0, -1.0, -1.0), new Grad(0.0, -1.0, 1.0, 1.0), new Grad(0.0, -1.0, 1.0, -1.0), new Grad(0.0, -1.0, -1.0, 1.0), new Grad(0.0, -1.0, -1.0, -1.0), new Grad(1.0, 0.0, 1.0, 1.0), new Grad(1.0, 0.0, 1.0, -1.0), new Grad(1.0, 0.0, -1.0, 1.0), new Grad(1.0, 0.0, -1.0, -1.0), new Grad(-1.0, 0.0, 1.0, 1.0), new Grad(-1.0, 0.0, 1.0, -1.0), new Grad(-1.0, 0.0, -1.0, 1.0), new Grad(-1.0, 0.0, -1.0, -1.0), new Grad(1.0, 1.0, 0.0, 1.0), new Grad(1.0, 1.0, 0.0, -1.0), new Grad(1.0, -1.0, 0.0, 1.0), new Grad(1.0, -1.0, 0.0, -1.0), new Grad(-1.0, 1.0, 0.0, 1.0), new Grad(-1.0, 1.0, 0.0, -1.0), new Grad(-1.0, -1.0, 0.0, 1.0), new Grad(-1.0, -1.0, 0.0, -1.0), new Grad(1.0, 1.0, 1.0, 0.0), new Grad(1.0, 1.0, -1.0, 0.0), new Grad(1.0, -1.0, 1.0, 0.0), new Grad(1.0, -1.0, -1.0, 0.0), new Grad(-1.0, 1.0, 1.0, 0.0), new Grad(-1.0, 1.0, -1.0, 0.0), new Grad(-1.0, -1.0, 1.0, 0.0), new Grad(-1.0, -1.0, -1.0, 0.0)};
    private short[] p = new short[256];
    private short[] perm = new short[512];
    private short[] permMod12 = new short[512];
    private static final double F2 = 0.5 * (Math.sqrt(3.0) - 1.0);
    private static final double G2 = (3.0 - Math.sqrt(3.0)) / 6.0;
    private static final double F4 = (Math.sqrt(5.0) - 1.0) / 4.0;
    private static final double G4 = (5.0 - Math.sqrt(5.0)) / 20.0;

    public SimplexNoise(Random random) {
        int i = 0;
        while (i < this.p.length) {
            this.p[i] = (short)random.nextInt(256);
            ++i;
        }
        i = 0;
        while (i < 512) {
            this.perm[i] = this.p[i & 0xFF];
            this.permMod12[i] = (short)(this.perm[i] % 12);
            ++i;
        }
    }

    private static int fastfloor(double x) {
        int xi = (int)x;
        return x < (double)xi ? xi - 1 : xi;
    }

    private static double dot(Grad g, double x, double y) {
        return g.x * x + g.y * y;
    }

    public double noise2D(double xin, double yin) {
        double n3;
        double n2;
        double n0;
        int j2;
        int i2;
        double Y0;
        double y0;
        int j;
        double t;
        double s = (xin + yin) * F2;
        int i = SimplexNoise.fastfloor(xin + s);
        double X0 = (double)i - (t = (double)(i + (j = SimplexNoise.fastfloor(yin + s))) * G2);
        double x0 = xin - X0;
        if (x0 > (y0 = yin - (Y0 = (double)j - t))) {
            i2 = 1;
            j2 = 0;
        } else {
            i2 = 0;
            j2 = 1;
        }
        double x2 = x0 - (double)i2 + G2;
        double y2 = y0 - (double)j2 + G2;
        double x3 = x0 - 1.0 + 2.0 * G2;
        double y3 = y0 - 1.0 + 2.0 * G2;
        int ii = i & 0xFF;
        int jj = j & 0xFF;
        short gi0 = this.permMod12[ii + this.perm[jj]];
        short gi2 = this.permMod12[ii + i2 + this.perm[jj + j2]];
        short gi3 = this.permMod12[ii + 1 + this.perm[jj + 1]];
        double t2 = 0.5 - x0 * x0 - y0 * y0;
        if (t2 < 0.0) {
            n0 = 0.0;
        } else {
            t2 *= t2;
            n0 = t2 * t2 * SimplexNoise.dot(grad3[gi0], x0, y0);
        }
        double t3 = 0.5 - x2 * x2 - y2 * y2;
        if (t3 < 0.0) {
            n2 = 0.0;
        } else {
            t3 *= t3;
            n2 = t3 * t3 * SimplexNoise.dot(grad3[gi2], x2, y2);
        }
        double t4 = 0.5 - x3 * x3 - y3 * y3;
        if (t4 < 0.0) {
            n3 = 0.0;
        } else {
            t4 *= t4;
            n3 = t4 * t4 * SimplexNoise.dot(grad3[gi3], x3, y3);
        }
        return 70.0 * (n0 + n2 + n3);
    }

    private static class Grad {
        double x;
        double y;
        double z;
        double w;

        Grad(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        Grad(double x, double y, double z, double w) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }
    }
}

