/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.comcraft.server.Settings;
import net.comcraft.src.Chunk;
import net.comcraft.src.ChunkLoader;
import net.comcraft.src.ChunkManager;
import net.comcraft.src.Player;
import net.comcraft.src.WorldGenerator;
import net.comcraft.src.WorldInfo;

public class World {
    private ChunkManager chunkManager;
    private ChunkLoader chunkLoader;
    private WorldInfo info;
    public final int worldSize;

    public World(String root, Settings settings) throws IOException {
        WorldGenerator gen = new WorldGenerator(root);
        if (gen.needsGenerating) {
            this.info = gen.generateAndSaveWorld(settings.worldSize, settings.worldType == "FLAT", settings.flatLevel, settings.generateTrees, settings.allowcommands);
        } else {
            this.info = new WorldInfo();
            String r = root;
            if (!r.startsWith("file://")) {
                r = "file:///" + root;
            }
            if (!r.endsWith("/")) {
                r = String.valueOf(r) + "/";
            }
            FileConnection f = (FileConnection)Connector.open((String)(String.valueOf(r) + "level.info"));
            DataInputStream dis = f.openDataInputStream();
            this.info.loadWorldInfo(dis, Player.getSpawnPlayer());
            dis.close();
            f.close();
        }
        this.worldSize = this.info.getWorldSize();
        this.chunkLoader = new ChunkLoader(this, root);
        this.chunkManager = new ChunkManager(this.chunkLoader, this);
    }

    public final WorldInfo getWorldInfo() {
        return this.info;
    }

    public void saveWorld() {
        this.chunkManager.saveAllChunks();
        this.onWorldEnd();
    }

    public void onWorldEnd() {
        this.chunkManager.onChunkProviderEnd();
    }

    public Chunk getChunkFromChunkCoords(int x, int z) {
        return this.chunkManager.getChunk(x, z);
    }
}

