/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.comcraft.src.ChunkGenerator;
import net.comcraft.src.ChunkGeneratorFlat;
import net.comcraft.src.ChunkGeneratorNormal;
import net.comcraft.src.ChunkLoader;
import net.comcraft.src.Player;
import net.comcraft.src.Server;
import net.comcraft.src.WorldInfo;

public class WorldGenerator {
    private long seed;
    private WorldInfo saveHandler;
    private ChunkLoader chunkLoader;
    private int worldSize;
    private ChunkGenerator chunkGenerator;
    private boolean allowcommands;
    private String file;
    public final boolean needsGenerating;
    private String root;

    public WorldGenerator(String root) throws IOException {
        if (!root.startsWith("file://")) {
            root = "file:///" + root;
        }
        if (!root.endsWith("/")) {
            root = String.valueOf(root) + "/";
        }
        this.root = root;
        this.file = String.valueOf(root) + "level.info";
        FileConnection file2 = (FileConnection)Connector.open((String)(String.valueOf(root) + "world.data"));
        if (file2.exists()) {
            this.needsGenerating = false;
            file2.close();
            return;
        }
        file2.create();
        file2.close();
        FileConnection file3 = (FileConnection)Connector.open((String)this.file);
        file3.create();
        file3.truncate(0L);
        file3.close();
        this.needsGenerating = true;
    }

    public WorldInfo generateAndSaveWorld(int worldSize, boolean isFlat, int flatLevel, boolean generateTrees, boolean allowcommands) {
        this.saveHandler = new WorldInfo();
        this.chunkLoader = new ChunkLoader(null, this.root);
        this.worldSize = worldSize;
        this.seed = System.currentTimeMillis();
        this.chunkGenerator = isFlat ? new ChunkGeneratorFlat(this.seed, flatLevel) : new ChunkGeneratorNormal(this.seed, generateTrees);
        this.allowcommands = allowcommands;
        this.writeWorldInfo();
        this.writeWorldData();
        return this.saveHandler;
    }

    private void writeWorldInfo() {
        Player player = Player.getSpawnPlayer();
        player.setPlayerOnWorldCenter(this.worldSize);
        player.commandsAllowed = this.allowcommands;
        this.saveHandler.setWorldInfo(player, this.worldSize);
        try {
            FileConnection fc = (FileConnection)Connector.open((String)this.file);
            DataOutputStream dos = fc.openDataOutputStream();
            this.saveHandler.writeWorldInfo(dos, player);
            dos.close();
            fc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeWorldData() {
        this.chunkLoader.startSavingBlockStorage();
        int z = 0;
        while (z < this.worldSize) {
            int x = 0;
            while (x < this.worldSize) {
                this.chunkLoader.saveBlockStorage(this.chunkGenerator.generateChunk(x, z));
                ++x;
            }
            float f = (float)z / ((float)this.worldSize - 1.0f);
            Server.log("Generating world " + (int)(f * 100.0f) + "%");
            ++z;
        }
        this.chunkLoader.endSavingBlockStorage();
        this.chunkLoader.onChunkLoaderEnd();
    }
}

