/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.comcraft.src.Player;

public class WorldInfo {
    private float worldVersion = 5.0f;
    private float spawnX;
    private float spawnY;
    private float spawnZ;
    private int worldSize;

    public int getWorldSize() {
        return this.worldSize;
    }

    public void setWorldInfo(Player player, int worldSize) {
        this.spawnX = player.xPos;
        this.spawnY = player.yPos;
        this.spawnZ = player.zPos;
        this.worldSize = worldSize;
    }

    public void writeWorldInfo(DataOutputStream dos, Player player) throws IOException {
        dos.writeFloat(this.worldVersion);
        dos.writeInt(this.worldSize);
        dos.writeFloat(this.spawnX);
        dos.writeFloat(this.spawnY);
        dos.writeFloat(this.spawnZ);
        dos.writeInt(0);
        player.writeToDataOutputStream(dos, this.worldVersion);
    }

    public void loadWorldInfo(DataInputStream dis, Player player) throws IOException {
        this.worldVersion = dis.readFloat();
        this.worldSize = dis.readInt();
        this.spawnX = dis.readFloat();
        this.spawnY = dis.readFloat();
        this.spawnZ = dis.readFloat();
        if (this.worldVersion >= 5.0f) {
            dis.readInt();
        }
        player.loadFromDataInputStream(dis, this.worldVersion);
        if (this.worldVersion < 5.0f) {
            this.worldVersion = 5.0f;
        }
    }

    public float getVersion() {
        return this.worldVersion;
    }
}

