/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.sun.jsr239.BufferManager;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBufferImpl;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public abstract class ByteBuffer
extends Buffer
implements Comparable {
    byte[] array;
    int arrayOffset;
    boolean isDirect;
    boolean disposed = false;

    ByteBuffer() {
    }

    public static ByteBuffer allocateDirect(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        int nativeAddress = ByteBufferImpl._allocNative((int)capacity);
        ByteBufferImpl buf = new ByteBufferImpl(capacity, null, nativeAddress);
        BufferManager.newBuffer((Buffer)buf, (int)nativeAddress);
        return buf;
    }

    public static ByteBuffer wrap(byte[] array, int offset, int length) {
        if (offset < 0 || offset > array.length || length < 0 || length > array.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        ByteBufferImpl bbi = new ByteBufferImpl(array.length, array, 0);
        bbi.position(offset);
        bbi.limit(offset + length);
        return bbi;
    }

    public static ByteBuffer wrap(byte[] array) {
        return ByteBuffer.wrap(array, 0, array.length);
    }

    public abstract ByteBuffer slice();

    public abstract byte get();

    public abstract ByteBuffer put(byte var1);

    public abstract byte get(int var1);

    public abstract ByteBuffer put(int var1, byte var2);

    public ByteBuffer get(byte[] dst, int offset, int length) {
        if (offset < 0 || offset > dst.length || length < 0 || length > dst.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (this.limit - this.position < length) {
            throw new BufferUnderflowException();
        }
        if (this.isDirect) {
            ByteBufferImpl._getBytes((int)(this.arrayOffset + this.position), (byte[])dst, (int)offset, (int)length);
        } else {
            System.arraycopy(this.array, this.arrayOffset + this.position, dst, offset, length);
        }
        this.position += length;
        return this;
    }

    public ByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public ByteBuffer put(ByteBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        ByteBufferImpl srci = (ByteBufferImpl)src;
        int length = srci.limit - srci.position;
        if (length > this.limit - this.position) {
            throw new BufferOverflowException();
        }
        if (this.isDirect && srci.isDirect) {
            ByteBufferImpl._copyBytes((int)(srci.arrayOffset + srci.position), (int)(this.arrayOffset + this.position), (int)length);
        } else if (this.isDirect && !srci.isDirect) {
            ByteBufferImpl._putBytes((int)(this.arrayOffset + this.position), (byte[])srci.array, (int)(srci.arrayOffset + srci.position), (int)length);
        } else if (!this.isDirect && srci.isDirect) {
            ByteBufferImpl._getBytes((int)(srci.arrayOffset + srci.position), (byte[])this.array, (int)(this.arrayOffset + this.position), (int)length);
        } else if (!this.isDirect && !srci.isDirect) {
            System.arraycopy(srci.array, srci.arrayOffset + srci.position, this.array, this.arrayOffset + this.position, length);
        }
        srci.position += length;
        this.position += length;
        return this;
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        if (offset < 0 || offset > src.length || length < 0 || length > src.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length > this.limit - this.position) {
            throw new BufferOverflowException();
        }
        if (this.isDirect) {
            ByteBufferImpl._putBytes((int)(this.arrayOffset + this.position), (byte[])src, (int)offset, (int)length);
        } else {
            System.arraycopy(src, offset, this.array, this.arrayOffset + this.position, length);
        }
        this.position += length;
        return this;
    }

    public final ByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return !this.isDirect;
    }

    public final byte[] array() {
        if (this.isDirect) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    public final int arrayOffset() {
        if (this.isDirect) {
            throw new UnsupportedOperationException();
        }
        return this.arrayOffset;
    }

    public abstract boolean isDirect();

    public String toString() {
        return "java.nio.ByteBuffer[pos=" + this.position() + "lim=" + this.limit() + "cap=" + this.capacity() + "]";
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer that = (ByteBuffer)ob;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int i = this.limit() - 1;
        int j = that.limit() - 1;
        while (i >= p) {
            byte v2;
            byte v1 = this.get(i);
            if (v1 != (v2 = that.get(j)) && (v1 == v1 || v2 == v2)) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    public int compareTo(Object ob) {
        ByteBuffer that = (ByteBuffer)ob;
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            byte v2;
            byte v1 = this.get(i);
            if (v1 != (v2 = that.get(j)) && (v1 == v1 || v2 == v2)) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    public abstract short getShort();

    public abstract ByteBuffer putShort(short var1);

    public abstract short getShort(int var1);

    public abstract ByteBuffer putShort(int var1, short var2);

    public abstract ShortBuffer asShortBuffer();

    public abstract int getInt();

    public abstract ByteBuffer putInt(int var1);

    public abstract int getInt(int var1);

    public abstract ByteBuffer putInt(int var1, int var2);

    public abstract IntBuffer asIntBuffer();

    public abstract float getFloat();

    public abstract ByteBuffer putFloat(float var1);

    public abstract float getFloat(int var1);

    public abstract ByteBuffer putFloat(int var1, float var2);

    public abstract FloatBuffer asFloatBuffer();
}

