/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.SecuritySupport;

class FactoryFinder {
    private static final String DEFAULT_PACKAGE = "com.sun.org.apache.xerces.internal";
    private static boolean debug = false;
    private static final Properties cacheProps = new Properties();
    private static volatile boolean firstTime = true;
    private static final SecuritySupport ss = new SecuritySupport();

    FactoryFinder() {
    }

    private static void dPrint(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    private static Class<?> getProviderClass(String string, ClassLoader classLoader, boolean bl, boolean bl2) throws ClassNotFoundException {
        try {
            if (classLoader == null) {
                if (bl2) {
                    return Class.forName(string, false, FactoryFinder.class.getClassLoader());
                }
                classLoader = ss.getContextClassLoader();
                if (classLoader == null) {
                    throw new ClassNotFoundException();
                }
                return Class.forName(string, false, classLoader);
            }
            return Class.forName(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                return Class.forName(string, false, FactoryFinder.class.getClassLoader());
            }
            throw classNotFoundException;
        }
    }

    static <T> T newInstance(Class<T> clazz, String string, ClassLoader classLoader, boolean bl) throws DatatypeConfigurationException {
        return FactoryFinder.newInstance(clazz, string, classLoader, bl, false);
    }

    static <T> T newInstance(Class<T> clazz, String string, ClassLoader classLoader, boolean bl, boolean bl2) throws DatatypeConfigurationException {
        assert (clazz != null);
        if (System.getSecurityManager() != null && string != null && string.startsWith(DEFAULT_PACKAGE)) {
            classLoader = null;
            bl2 = true;
        }
        try {
            Class<?> clazz2 = FactoryFinder.getProviderClass(string, classLoader, bl, bl2);
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new ClassCastException(string + " cannot be cast to " + clazz.getName());
            }
            Object obj = clazz2.newInstance();
            if (debug) {
                FactoryFinder.dPrint("created new instance of " + clazz2 + " using ClassLoader: " + classLoader);
            }
            return clazz.cast(obj);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DatatypeConfigurationException("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new DatatypeConfigurationException("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T find(Class<T> clazz, String string) throws DatatypeConfigurationException {
        Object object;
        String string2;
        block15: {
            block14: {
                string2 = clazz.getName();
                FactoryFinder.dPrint("find factoryId =" + string2);
                try {
                    object = ss.getSystemProperty(string2);
                    if (object != null) {
                        FactoryFinder.dPrint("found system property, value=" + (String)object);
                        return FactoryFinder.newInstance(clazz, (String)object, null, true);
                    }
                }
                catch (SecurityException securityException) {
                    if (!debug) break block14;
                    securityException.printStackTrace();
                }
            }
            try {
                if (firstTime) {
                    object = cacheProps;
                    synchronized (object) {
                        if (firstTime) {
                            String string3 = ss.getSystemProperty("java.home") + File.separator + "lib" + File.separator + "jaxp.properties";
                            File file = new File(string3);
                            firstTime = false;
                            if (ss.doesFileExist(file)) {
                                FactoryFinder.dPrint("Read properties file " + file);
                                cacheProps.load(ss.getFileInputStream(file));
                            }
                        }
                    }
                }
                if ((object = cacheProps.getProperty(string2)) != null) {
                    FactoryFinder.dPrint("found in $java.home/jaxp.properties, value=" + (String)object);
                    return FactoryFinder.newInstance(clazz, (String)object, null, true);
                }
            }
            catch (Exception exception) {
                if (!debug) break block15;
                exception.printStackTrace();
            }
        }
        if ((object = FactoryFinder.findServiceProvider(clazz)) != null) {
            return (T)object;
        }
        if (string == null) {
            throw new DatatypeConfigurationException("Provider for " + string2 + " cannot be found");
        }
        FactoryFinder.dPrint("loaded from fallback value: " + string);
        return FactoryFinder.newInstance(clazz, string, null, true);
    }

    private static <T> T findServiceProvider(final Class<T> clazz) throws DatatypeConfigurationException {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<T>(){

                @Override
                public T run() {
                    ServiceLoader serviceLoader = ServiceLoader.load(clazz);
                    Iterator iterator = serviceLoader.iterator();
                    if (iterator.hasNext()) {
                        return iterator.next();
                    }
                    return null;
                }
            });
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            DatatypeConfigurationException datatypeConfigurationException = new DatatypeConfigurationException("Provider for " + clazz + " cannot be found", serviceConfigurationError);
            throw datatypeConfigurationException;
        }
    }

    static {
        try {
            String string = ss.getSystemProperty("jaxp.debug");
            debug = string != null && !"false".equals(string);
        }
        catch (SecurityException securityException) {
            debug = false;
        }
    }
}

