/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDevice$FPSSource;
import com.github.sarxos.webcam.WebcamDiscoveryListener;
import com.github.sarxos.webcam.WebcamDiscoveryService;
import com.github.sarxos.webcam.WebcamDriver;
import com.github.sarxos.webcam.WebcamDriverUtils;
import com.github.sarxos.webcam.WebcamEvent;
import com.github.sarxos.webcam.WebcamEventType;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamImageTransformer;
import com.github.sarxos.webcam.WebcamListener;
import com.github.sarxos.webcam.WebcamLock;
import com.github.sarxos.webcam.WebcamShutdownHook;
import com.github.sarxos.webcam.WebcamUpdater;
import com.github.sarxos.webcam.WebcamUpdater$DefaultDelayCalculator;
import com.github.sarxos.webcam.WebcamUpdater$DelayCalculator;
import com.github.sarxos.webcam.b;
import com.github.sarxos.webcam.c;
import com.github.sarxos.webcam.ds.buildin.WebcamDefaultDriver;
import com.github.sarxos.webcam.ds.cgt.WebcamCloseTask;
import com.github.sarxos.webcam.ds.cgt.WebcamDisposeTask;
import com.github.sarxos.webcam.ds.cgt.WebcamGetImageTask;
import com.github.sarxos.webcam.ds.cgt.WebcamOpenTask;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Webcam {
    private static final Logger LOG = LoggerFactory.getLogger(Webcam.class);
    private static final List DRIVERS_LIST = new ArrayList();
    private static final List DRIVERS_CLASS_LIST = new ArrayList();
    private static final List DISCOVERY_LISTENERS = Collections.synchronizedList(new ArrayList());
    private static volatile WebcamDriver driver = null;
    private static volatile WebcamDiscoveryService discovery = null;
    private static boolean deallocOnTermSignal = false;
    private static boolean autoOpen = false;
    private List listeners = new CopyOnWriteArrayList();
    private List customSizes = new ArrayList();
    private WebcamShutdownHook hook = null;
    private WebcamDevice device = null;
    private AtomicBoolean open = new AtomicBoolean(false);
    private AtomicBoolean disposed = new AtomicBoolean(false);
    private volatile boolean asynchronous = false;
    private volatile double fps = 0.0;
    private volatile WebcamUpdater updater = null;
    private volatile WebcamImageTransformer transformer = null;
    private WebcamLock lock = null;
    private ExecutorService notificator = null;

    protected Webcam(WebcamDevice webcamDevice) {
        if (webcamDevice == null) {
            throw new IllegalArgumentException("Webcam device cannot be null");
        }
        this.device = webcamDevice;
        this.lock = new WebcamLock(this);
    }

    protected void notifyWebcamImageAcquired(BufferedImage bufferedImage) {
        if (this.getWebcamListenersCount() > 0) {
            this.notificator.execute(new b(this, bufferedImage));
        }
    }

    public boolean open() {
        return this.open(false);
    }

    public boolean open(boolean bl2) {
        return this.open(bl2, new WebcamUpdater$DefaultDelayCalculator());
    }

    public boolean open(boolean bl2, WebcamUpdater$DelayCalculator webcamUpdater$DelayCalculator) {
        if (this.open.compareAndSet(false, true)) {
            assert (this.lock != null);
            this.notificator = Executors.newSingleThreadExecutor(new c(this, null));
            this.lock.lock();
            WebcamOpenTask webcamOpenTask = new WebcamOpenTask(driver, this.device);
            try {
                webcamOpenTask.open();
            }
            catch (InterruptedException interruptedException) {
                this.lock.unlock();
                this.open.set(false);
                LOG.debug("Thread has been interrupted in the middle of webcam opening process!", interruptedException);
                return false;
            }
            catch (WebcamException webcamException) {
                this.lock.unlock();
                this.open.set(false);
                LOG.debug("Webcam exception when opening", webcamException);
                throw webcamException;
            }
            LOG.debug("Webcam is now open {}", this.getName());
            try {
                this.hook = new WebcamShutdownHook(this);
                Runtime.getRuntime().addShutdownHook(this.hook);
            }
            catch (IllegalStateException illegalStateException) {
                LOG.debug("Shutdown in progress, do not open device");
                LOG.trace(illegalStateException.getMessage(), illegalStateException);
                this.close();
                return false;
            }
            this.asynchronous = bl2;
            if (this.asynchronous) {
                if (this.updater == null) {
                    this.updater = new WebcamUpdater(this, webcamUpdater$DelayCalculator);
                }
                this.updater.start();
            }
            WebcamEvent webcamEvent = new WebcamEvent(WebcamEventType.OPEN, this);
            Iterator iterator = this.listeners.iterator();
            WebcamListener webcamListener = null;
            while (iterator.hasNext()) {
                webcamListener = (WebcamListener)iterator.next();
                try {
                    webcamListener.webcamOpen(webcamEvent);
                }
                catch (Exception exception) {
                    LOG.error(String.format("Notify webcam open, exception when calling listener %s", webcamListener.getClass()), exception);
                }
            }
        } else {
            LOG.debug("Webcam is already open {}", this.getName());
        }
        return true;
    }

    public boolean close() {
        if (this.open.compareAndSet(true, false)) {
            LOG.debug("Closing webcam {}", this.getName());
            assert (this.lock != null);
            WebcamCloseTask webcamCloseTask = new WebcamCloseTask(driver, this.device);
            try {
                webcamCloseTask.close();
            }
            catch (InterruptedException interruptedException) {
                this.open.set(true);
                LOG.debug("Thread has been interrupted before webcam was closed!", interruptedException);
                return false;
            }
            catch (WebcamException webcamException) {
                this.open.set(true);
                throw webcamException;
            }
            if (this.asynchronous) {
                this.updater.stop();
            }
            this.removeShutdownHook();
            this.lock.unlock();
            WebcamEvent webcamEvent = new WebcamEvent(WebcamEventType.CLOSED, this);
            Iterator iterator = this.listeners.iterator();
            WebcamListener webcamListener = null;
            while (iterator.hasNext()) {
                webcamListener = (WebcamListener)iterator.next();
                try {
                    webcamListener.webcamClosed(webcamEvent);
                }
                catch (Exception exception) {
                    LOG.error(String.format("Notify webcam closed, exception when calling %s listener", webcamListener.getClass()), exception);
                }
            }
            this.notificator.shutdown();
            while (!this.notificator.isTerminated()) {
                try {
                    this.notificator.awaitTermination(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            LOG.debug("Webcam {} has been closed", this.getName());
        } else {
            LOG.debug("Webcam {} is already closed", this.getName());
        }
        return true;
    }

    public WebcamDevice getDevice() {
        assert (this.device != null);
        return this.device;
    }

    protected void dispose() {
        assert (this.disposed != null);
        assert (this.open != null);
        assert (driver != null);
        assert (this.device != null);
        assert (this.listeners != null);
        if (!this.disposed.compareAndSet(false, true)) {
            return;
        }
        this.open.set(false);
        LOG.info("Disposing webcam {}", this.getName());
        WebcamDisposeTask webcamDisposeTask = new WebcamDisposeTask(driver, this.device);
        try {
            webcamDisposeTask.dispose();
        }
        catch (InterruptedException interruptedException) {
            LOG.error("Processor has been interrupted before webcam was disposed!", interruptedException);
            return;
        }
        WebcamEvent webcamEvent = new WebcamEvent(WebcamEventType.DISPOSED, this);
        Iterator iterator = this.listeners.iterator();
        WebcamListener webcamListener = null;
        while (iterator.hasNext()) {
            webcamListener = (WebcamListener)iterator.next();
            try {
                webcamListener.webcamClosed(webcamEvent);
                webcamListener.webcamDisposed(webcamEvent);
            }
            catch (Exception exception) {
                LOG.error(String.format("Notify webcam disposed, exception when calling %s listener", webcamListener.getClass()), exception);
            }
        }
        this.removeShutdownHook();
        LOG.debug("Webcam disposed {}", this.getName());
    }

    private void removeShutdownHook() {
        if (this.hook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.hook);
            }
            catch (IllegalStateException illegalStateException) {
                LOG.trace("Shutdown in progress, cannot remove hook");
            }
        }
    }

    protected BufferedImage transform(BufferedImage bufferedImage) {
        WebcamImageTransformer webcamImageTransformer;
        if (bufferedImage != null && (webcamImageTransformer = this.getImageTransformer()) != null) {
            return webcamImageTransformer.transform(bufferedImage);
        }
        return bufferedImage;
    }

    public boolean isOpen() {
        return this.open.get();
    }

    public Dimension getViewSize() {
        return this.device.getResolution();
    }

    public BufferedImage getImage() {
        if (!this.isReady()) {
            return null;
        }
        long l2 = 0L;
        long l3 = 0L;
        if (this.asynchronous) {
            return this.updater.getImage();
        }
        l2 = System.currentTimeMillis();
        BufferedImage bufferedImage = this.transform(new WebcamGetImageTask(driver, this.device).getImage());
        l3 = System.currentTimeMillis();
        if (bufferedImage == null) {
            return null;
        }
        this.fps = this.device instanceof WebcamDevice$FPSSource ? ((WebcamDevice$FPSSource)((Object)this.device)).getFPS() : (4.0 * this.fps + (double)(1000L / (l3 - l2 + 1L))) / 5.0;
        this.notifyWebcamImageAcquired(bufferedImage);
        return bufferedImage;
    }

    private boolean isReady() {
        assert (this.disposed != null);
        assert (this.open != null);
        if (this.disposed.get()) {
            LOG.warn("Cannot get image, webcam has been already disposed");
            return false;
        }
        if (!this.open.get()) {
            if (autoOpen) {
                this.open();
            } else {
                return false;
            }
        }
        return true;
    }

    public static synchronized List getWebcams(long l2, TimeUnit timeUnit) throws TimeoutException, WebcamException {
        if (l2 < 0L) {
            throw new IllegalArgumentException(String.format("Timeout cannot be negative (%d)", l2));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("Time unit cannot be null!");
        }
        WebcamDiscoveryService webcamDiscoveryService = Webcam.getDiscoveryService();
        assert (webcamDiscoveryService != null);
        List list2 = webcamDiscoveryService.getWebcams(l2, timeUnit);
        if (!webcamDiscoveryService.isRunning()) {
            webcamDiscoveryService.start();
        }
        return list2;
    }

    public static Webcam getDefault() throws WebcamException {
        try {
            return Webcam.getDefault(Long.MAX_VALUE);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
    }

    public static Webcam getDefault(long l2) throws TimeoutException, WebcamException {
        if (l2 < 0L) {
            throw new IllegalArgumentException(String.format("Timeout cannot be negative (%d)", l2));
        }
        return Webcam.getDefault(l2, TimeUnit.MILLISECONDS);
    }

    public static Webcam getDefault(long l2, TimeUnit timeUnit) throws TimeoutException, WebcamException {
        if (l2 < 0L) {
            throw new IllegalArgumentException(String.format("Timeout cannot be negative (%d)", l2));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("Time unit cannot be null!");
        }
        List list2 = Webcam.getWebcams(l2, timeUnit);
        assert (list2 != null);
        if (!list2.isEmpty()) {
            return (Webcam)list2.get(0);
        }
        LOG.warn("No webcam has been detected!");
        return null;
    }

    public String getName() {
        assert (this.device != null);
        return this.device.getName();
    }

    public String toString() {
        return String.format("Webcam %s", this.getName());
    }

    public WebcamListener[] getWebcamListeners() {
        assert (this.listeners != null);
        return this.listeners.toArray(new WebcamListener[this.listeners.size()]);
    }

    public int getWebcamListenersCount() {
        assert (this.listeners != null);
        return this.listeners.size();
    }

    public static synchronized WebcamDriver getDriver() {
        if (driver != null) {
            return driver;
        }
        if (driver == null) {
            driver = WebcamDriverUtils.findDriver(DRIVERS_LIST, DRIVERS_CLASS_LIST);
        }
        if (driver == null) {
            driver = new WebcamDefaultDriver();
        }
        LOG.info("{} capture driver will be used", driver.getClass().getSimpleName());
        return driver;
    }

    public static boolean isHandleTermSignal() {
        return deallocOnTermSignal;
    }

    public static WebcamDiscoveryListener[] getDiscoveryListeners() {
        return DISCOVERY_LISTENERS.toArray(new WebcamDiscoveryListener[DISCOVERY_LISTENERS.size()]);
    }

    public static synchronized WebcamDiscoveryService getDiscoveryService() {
        if (discovery == null) {
            discovery = new WebcamDiscoveryService(Webcam.getDriver());
        }
        return discovery;
    }

    public WebcamImageTransformer getImageTransformer() {
        return this.transformer;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

