/*
 * Decompiled with CFR 0.152.
 */
package com.motorola.iden.micro3d;

import com.motorola.iden.micro3d.Texture;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;

public class MultiTexture
extends Texture {
    public static final int MAX_TEXTURES = 16;
    private int currentIdx = 0;
    Texture[] textures;
    int size;
    private Texture currentTexture;

    public MultiTexture() {
        super(false);
        this.textures = new Texture[16];
    }

    public MultiTexture(int n2) {
        super(false);
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.textures = new Texture[Math.min(n2, 16)];
    }

    public boolean addTexture(Texture texture) {
        if (texture == null) {
            throw new NullPointerException();
        }
        if (texture.isSphereTexture() || texture instanceof MultiTexture) {
            throw new IllegalArgumentException();
        }
        if (this.size < 16) {
            Texture[] textureArray;
            if (this.size < this.textures.length) {
                textureArray = this.textures;
            } else {
                textureArray = new Texture[this.size + 1];
                System.arraycopy(this.textures, 0, textureArray, 0, this.size);
            }
            this.textures[this.size++] = texture;
            this.textures = textureArray;
            return true;
        }
        return false;
    }

    public int capacity() {
        return this.textures.length;
    }

    public boolean contains(Texture texture) {
        for (Texture texture2 : this.textures) {
            if (texture2 != texture) continue;
            return true;
        }
        return false;
    }

    public int getCurrentIndex() {
        return this.currentIdx;
    }

    public Texture getCurrentTexture() {
        return this.currentTexture;
    }

    public int indexOf(Texture texture) {
        return this.indexOf(texture, 0);
    }

    public int indexOf(Texture texture, int n2) {
        int n3 = this.textures.length;
        while (n2 < n3) {
            if (this.textures[n2] == texture) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean insertTextureAt(Texture texture, int n2) {
        if (texture == null) {
            throw new NullPointerException();
        }
        if (texture.isSphereTexture() || texture instanceof MultiTexture) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.size < 16) {
            Texture[] textureArray;
            if (this.size < this.textures.length) {
                textureArray = this.textures;
            } else {
                textureArray = new Texture[this.size + 1];
                System.arraycopy(this.textures, 0, textureArray, 0, n2);
            }
            System.arraycopy(this.textures, n2, textureArray, n2 + 1, this.size - n2);
            this.textures[n2] = texture;
            this.textures = textureArray;
            ++this.size;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(Texture texture) {
        return this.lastIndexOf(texture, this.textures.length);
    }

    public int lastIndexOf(Texture texture, int n2) {
        --n2;
        while (n2 >= 0) {
            if (this.textures[n2] == texture) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public void removeAllTextures() {
        while (this.size > 0) {
            --this.size;
            this.textures[this.size] = null;
        }
    }

    public boolean removeTexture(Texture texture) {
        int n2 = this.indexOf(texture);
        if (n2 == -1) {
            return false;
        }
        this.removeTextureAt(n2);
        return true;
    }

    public void removeTextureAt(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        --this.size;
        System.arraycopy(this.textures, n2 + 1, this.textures, n2, this.size - n2);
    }

    public void setCurrentIndex(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.currentIdx = n2;
        this.currentTexture = this.textures[n2];
    }

    public void setTextureAt(Texture texture, int n2) {
        if (texture == null) {
            throw new NullPointerException();
        }
        if (texture.isSphereTexture() || texture instanceof MultiTexture) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.textures[n2] = texture;
    }

    public int size() {
        return this.size;
    }

    public Texture textureAt(int n2) {
        if (n2 < 0 || n2 > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.textures[n2];
    }

    public Enumeration textures() {
        return Collections.enumeration(Arrays.asList(this.textures).subList(0, this.size));
    }
}

