/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.ui.maker;

import com.nttdocomo.io.ConnectionException;
import com.nttdocomo.io.maker.ScratchPadConnection;
import emulator.custom.ResourceManager;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class MediaImpl {
    protected String location;
    protected InputStream in;
    protected byte[] data;
    protected Object resource;

    MediaImpl(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.location = string;
    }

    MediaImpl(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.in = inputStream;
    }

    MediaImpl(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.data = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.data, 0, byArray.length);
    }

    protected abstract Object loadResource(InputStream var1) throws IOException;

    protected abstract Object loadResource(byte[] var1) throws IOException;

    protected void useResource() throws ConnectionException {
        if (this.resource == null) {
            try {
                if (this.location != null) {
                    if (this.location.startsWith("scratchpad:")) {
                        ScratchPadConnection scratchPadConnection = ScratchPadConnection.open(this.location);
                        DataInputStream dataInputStream = scratchPadConnection.openDataInputStream();
                        if (scratchPadConnection.getAccessLength() > 0) {
                            byte[] byArray = new byte[scratchPadConnection.getAccessLength()];
                            dataInputStream.readFully(byArray);
                            this.resource = this.loadResource(byArray);
                        } else {
                            this.resource = this.loadResource(dataInputStream);
                        }
                        dataInputStream.close();
                        scratchPadConnection.close();
                    } else if (this.location.startsWith("resource:")) {
                        InputStream inputStream = ResourceManager.getResourceAsStream(this.location.substring(11));
                        this.resource = this.loadResource(inputStream);
                        inputStream.close();
                    }
                } else {
                    this.resource = this.in != null ? this.loadResource(this.in) : this.loadResource(this.data);
                }
            }
            catch (IOException iOException) {
                throw new ConnectionException(2);
            }
        }
    }
}

