/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.game;

import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.GraphicObject;
import java.awt.Rectangle;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite
extends GraphicObject {
    private Image sprite;
    private int frameHeight;
    private Rectangle dstBounds;
    private Rectangle frameBounds;
    private Rectangle collisionBounds;
    private int frame;
    private int posX;
    private int posY;

    public Sprite(byte[] byArray, int n2, int n3, int n4, byte[] byArray2, int n5, int n6) {
        if (byArray == null || n2 != 0 || n5 != 0 || n3 * n4 * n6 / 8 != byArray.length || byArray2 != null && byArray.length != byArray2.length || n3 % 8 != 0) {
            throw new IllegalArgumentException();
        }
        this.init(com.siemens.mp.ui.Image.createImageFromBitmap(byArray, n3, n4 * n6), byArray2 == null ? null : com.siemens.mp.ui.Image.createImageFromBitmap(byArray2, n3, n4 * n6), n6);
    }

    public Sprite(ExtendedImage extendedImage, ExtendedImage extendedImage2, int n2) {
        if (extendedImage == null) {
            throw new NullPointerException();
        }
        this.init(extendedImage.getImage(), extendedImage2 == null ? null : extendedImage2.getImage(), n2);
    }

    public Sprite(Image image, Image image2, int n2) {
        this.init(image, image2, n2);
    }

    private void init(Image image, Image image2, int n2) {
        if (image == null) {
            throw new NullPointerException();
        }
        int n3 = image.getWidth();
        int n4 = image.getHeight();
        if (image2 != null) {
            image = com.siemens.mp.lcdui.Image.createTransparentImageFromMask(image, image2);
        }
        this.sprite = image;
        this.frameHeight = n4 / n2;
        this.frameBounds = new Rectangle(0, 0, n3, this.frameHeight);
        this.dstBounds = new Rectangle(this.frameBounds);
        this.collisionBounds = new Rectangle(this.dstBounds);
    }

    public int getFrame() {
        return this.frame;
    }

    public int getXPosition() {
        return this.posX;
    }

    public int getYPosition() {
        return this.posY;
    }

    public boolean isCollidingWith(Sprite sprite) {
        return this.collisionBounds.intersects(sprite.collisionBounds);
    }

    public boolean isCollidingWithPos(int n2, int n3) {
        return this.collisionBounds.contains(n2, n3);
    }

    public void setCollisionRectangle(int n2, int n3, int n4, int n5) {
        int n6 = this.posX;
        int n7 = this.posY;
        this.collisionBounds.setBounds(n6 + n2, n7 + n3, n4, n5);
    }

    public void setFrame(int n2) {
        this.frame = n2;
        this.frameBounds.x = 0;
        this.frameBounds.y = this.frameHeight * n2;
    }

    public void setPosition(int n2, int n3) {
        this.collisionBounds.x += n2 - this.posX;
        this.collisionBounds.y += n3 - this.posY;
        this.posX = n2;
        this.posY = n3;
    }

    @Override
    protected void paint(Graphics graphics, int n2, int n3) {
        this.dstBounds.x = n2 + this.posX;
        this.dstBounds.y = n3 + this.posY;
        graphics.drawRegion(this.sprite, this.frameBounds.x, this.frameBounds.y, this.frameBounds.width, this.frameBounds.height, 0, this.dstBounds.x, this.dstBounds.y, 0);
    }
}

