/*
 * Decompiled with CFR 0.152.
 */
package emulator;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.MessageDigest;

public class Utils {
    public static final String os = String.valueOf(System.getProperty("os.name")).toLowerCase();
    public static final boolean win = os.startsWith("win");
    public static final boolean linux = os.contains("linux") || os.contains("nix");
    public static final boolean macos = os.contains("mac");
    public static final boolean termux = String.valueOf(System.getProperty("java.vm.vendor")).toLowerCase().contains("termux") || String.valueOf(System.getProperty("user.dir")).toLowerCase().startsWith("/data/data/com.termux/");

    public static String translateEscapes(String string) {
        if (string.isEmpty()) {
            return "";
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        int n4 = 0;
        block13: while (n3 < n2) {
            int n5;
            if ((n5 = cArray[n3++]) == 92) {
                n5 = n3 < n2 ? cArray[n3++] : 0;
                switch (n5) {
                    case 10: {
                        continue block13;
                    }
                    case 13: {
                        if (n3 >= n2 || cArray[n3] != '\n') continue block13;
                        ++n3;
                        continue block13;
                    }
                    case 34: 
                    case 39: 
                    case 92: {
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        int n6 = Integer.min(n3 + (n5 <= 51 ? 2 : 1), n2);
                        int n7 = n5 - 48;
                        while (n3 < n6 && (n5 = cArray[n3]) >= 48 && 55 >= n5) {
                            ++n3;
                            n7 = n7 << 3 | n5 - 48;
                        }
                        n5 = (char)n7;
                        break;
                    }
                    case 98: {
                        n5 = 8;
                        break;
                    }
                    case 102: {
                        n5 = 12;
                        break;
                    }
                    case 110: {
                        n5 = 10;
                        break;
                    }
                    case 114: {
                        n5 = 13;
                        break;
                    }
                    case 115: {
                        n5 = 32;
                        break;
                    }
                    case 116: {
                        n5 = 9;
                        break;
                    }
                    case 58: {
                        n5 = 58;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(string);
                    }
                }
            }
            cArray[n4++] = n5;
        }
        return new String(cArray, 0, n4);
    }

    public static boolean isPathAbsolute(String string) {
        if (string.isEmpty()) {
            return false;
        }
        if (string.charAt(0) == '/') {
            return true;
        }
        if (string.length() <= 2) {
            return false;
        }
        if (string.charAt(0) == '\\' && string.charAt(1) == '\\') {
            return true;
        }
        if (string.length() <= 3) {
            return false;
        }
        if (string.charAt(1) == ':' && (string.charAt(2) == '/' || string.charAt(2) == '\\')) {
            char c2 = Character.toUpperCase(string.charAt(0));
            return c2 >= 'A' && c2 <= 'Z';
        }
        return false;
    }

    public static int getJavaVersionMajor() {
        try {
            return Integer.parseInt(System.getProperty("java.version").split("\\.")[0]);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public static boolean isJava9() {
        try {
            return Utils.getJavaVersionMajor() >= 9;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isJava17() {
        try {
            return Utils.getJavaVersionMajor() >= 17;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String getJdkHome() {
        String string = System.getProperty("java.home");
        String[] stringArray = new String[2];
        stringArray[0] = "bin";
        String string2 = stringArray[1] = win ? "javac.exe" : "javac";
        if (Files.exists(Paths.get(string, stringArray), new LinkOption[0])) {
            return string;
        }
        String string3 = Paths.get(string, new String[0]).getParent().toString();
        String[] stringArray2 = new String[2];
        stringArray2[0] = "bin";
        String string4 = stringArray2[1] = win ? "javac.exe" : "javac";
        if (Files.exists(Paths.get(string3, stringArray2), new LinkOption[0])) {
            return string3;
        }
        return null;
    }

    public static String getProcessOutput(String[] stringArray, boolean bl2) throws IOException {
        Process process = Runtime.getRuntime().exec(stringArray);
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStream inputStream = bl2 ? process.getErrorStream() : process.getInputStream();){
            int n2;
            while ((n2 = inputStream.read()) != -1) {
                stringBuilder.append((char)n2);
            }
        }
        return stringBuilder.toString();
    }

    static String a() {
        try {
            String string = System.getenv("COMPUTERNAME") + System.getProperty("user.name") + System.getenv("PROCESSOR_IDENTIFIER") + System.getenv("PROCESSOR_LEVEL");
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes());
            return Utils.a(messageDigest);
        }
        catch (Exception exception) {
            return "null";
        }
    }

    static String a(MessageDigest messageDigest) {
        byte[] byArray;
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by2 : byArray = messageDigest.digest()) {
            String string = Integer.toHexString(0xFF & by2);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

