/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D.lwjgl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class LWJGLUtil {
    private ByteBuffer a;
    private ShortBuffer a;
    private ByteBuffer b;
    private ShortBuffer b;
    private ShortBuffer[] a;
    private IntBuffer a;
    private ByteBuffer c;
    private FloatBuffer a = new ShortBuffer[10];

    public LWJGLUtil() {
        int n2;
        int n3 = 4096;
        this.a = BufferUtils.createByteBuffer(12288);
        this.a = BufferUtils.createShortBuffer(12288);
        this.b = BufferUtils.createByteBuffer(16384);
        this.b = BufferUtils.createShortBuffer(12288);
        for (n2 = 0; n2 < 10; ++n2) {
            this.a[n2] = BufferUtils.createShortBuffer(8192);
        }
        n2 = 1024;
        this.a = BufferUtils.createIntBuffer(3072);
        int n4 = 512;
        this.c = BufferUtils.createByteBuffer(0x100000);
        this.a = BufferUtils.createFloatBuffer(16);
    }

    public ByteBuffer getNormalBuffer(byte[] byArray) {
        if (this.a == null || this.a.capacity() < byArray.length) {
            this.a = BufferUtils.createByteBuffer(byArray.length * 4 / 3);
        }
        this.a.position(this.a.capacity() - byArray.length);
        this.a.put(byArray);
        this.a.position(this.a.capacity() - byArray.length);
        return this.a;
    }

    public ShortBuffer getNormalBuffer(short[] sArray) {
        if (this.a == null || this.a.capacity() < sArray.length) {
            this.a = BufferUtils.createShortBuffer(sArray.length * 4 / 3);
        }
        this.a.position(this.a.capacity() - sArray.length);
        for (short s2 : sArray) {
            this.a.put(s2);
        }
        this.a.position(this.a.capacity() - sArray.length);
        return this.a;
    }

    public ByteBuffer getImageBuffer(byte[] byArray) {
        if (this.c == null || this.c.capacity() < byArray.length) {
            this.c = BufferUtils.createByteBuffer(byArray.length * 4 / 3);
        }
        this.c.position(this.c.capacity() - byArray.length);
        this.c.put(byArray);
        this.c.position(this.c.capacity() - byArray.length);
        return this.c;
    }

    public ShortBuffer getVertexBuffer(byte[] byArray) {
        if (this.b == null || this.b.capacity() < byArray.length) {
            this.b = BufferUtils.createShortBuffer(byArray.length * 4 / 3);
        }
        this.b.position(this.b.capacity() - byArray.length);
        int n2 = 0;
        int n3 = byArray.length;
        while (n2 < n3) {
            this.b.put(byArray[n2++]);
        }
        this.b.position(this.b.capacity() - byArray.length);
        return this.b;
    }

    public ShortBuffer getVertexBuffer(short[] sArray) {
        if (this.b == null || this.b.capacity() < sArray.length) {
            this.b = BufferUtils.createShortBuffer(sArray.length * 4 / 3);
        }
        this.b.position(this.b.capacity() - sArray.length);
        this.b.put(sArray);
        this.b.position(this.b.capacity() - sArray.length);
        return this.b;
    }

    public ByteBuffer getColorBuffer(byte[] byArray, float f2, int n2) {
        int n3;
        int n4 = n3 = f2 == 1.0f ? byArray.length : 4 * n2;
        if (this.b == null || this.b.capacity() < n3) {
            this.b = BufferUtils.createByteBuffer(n3 * 4 / 3);
        }
        this.b.position(this.b.capacity() - n3);
        if (f2 == 1.0f) {
            this.b.put(byArray);
        } else if (byArray.length == n3) {
            int n5 = 0;
            while (n5 < n3) {
                this.b.put(byArray[n5++]);
                this.b.put(byArray[n5++]);
                this.b.put(byArray[n5++]);
                this.b.put((byte)((float)(byArray[n5++] & 0xFF) * f2 + 0.5f));
            }
        } else {
            int n6 = 0;
            while (n6 < byArray.length) {
                this.b.put(byArray[n6++]);
                this.b.put(byArray[n6++]);
                this.b.put(byArray[n6++]);
                this.b.put((byte)(255.0f * f2 + 0.5f));
            }
        }
        this.b.position(this.b.capacity() - n3);
        return this.b;
    }

    public IntBuffer getElementsBuffer(int[] nArray) {
        if (this.a == null || this.a.capacity() < nArray.length) {
            this.a = BufferUtils.createIntBuffer(nArray.length * 4 / 3);
        }
        this.a.position(this.a.capacity() - nArray.length);
        this.a.put(nArray);
        this.a.position(this.a.capacity() - nArray.length);
        return this.a;
    }

    public ShortBuffer getTexCoordBuffer(short[] sArray, int n2) {
        if (this.a[n2] == null || this.a[n2].capacity() < sArray.length) {
            this.a[n2] = BufferUtils.createShortBuffer(sArray.length * 4 / 3);
        }
        ShortBuffer shortBuffer = this.a[n2];
        shortBuffer.position(shortBuffer.capacity() - sArray.length);
        int n3 = 0;
        int n4 = sArray.length;
        while (n3 < n4) {
            shortBuffer.put(sArray[n3++]);
        }
        shortBuffer.position(shortBuffer.capacity() - sArray.length);
        return shortBuffer;
    }

    public ShortBuffer getTexCoordBuffer(byte[] byArray, int n2) {
        if (this.a[n2] == null || this.a[n2].capacity() < byArray.length) {
            this.a[n2] = BufferUtils.createShortBuffer(byArray.length * 4 / 3);
        }
        ShortBuffer shortBuffer = this.a[n2];
        shortBuffer.position(shortBuffer.capacity() - byArray.length);
        int n3 = 0;
        int n4 = byArray.length;
        while (n3 < n4) {
            shortBuffer.put(byArray[n3++]);
        }
        shortBuffer.position(shortBuffer.capacity() - byArray.length);
        return shortBuffer;
    }

    public FloatBuffer getFloatBuffer(float[] fArray) {
        if (this.a == null || this.a.capacity() < fArray.length) {
            this.a = BufferUtils.createFloatBuffer(fArray.length * 4 / 3);
        }
        this.a.position(this.a.capacity() - fArray.length);
        this.a.put(fArray);
        this.a.position(this.a.capacity() - fArray.length);
        return this.a;
    }
}

