/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import net.java.games.input.Event;
import net.java.games.input.LinuxAbsInfo;
import net.java.games.input.LinuxAxisDescriptor;
import net.java.games.input.LinuxComponent;
import net.java.games.input.LinuxEvent;
import net.java.games.input.LinuxEventComponent;
import net.java.games.input.LinuxEventDevice;

final class LinuxControllers {
    private static final LinuxEvent linux_event = new LinuxEvent();
    private static final LinuxAbsInfo abs_info = new LinuxAbsInfo();

    LinuxControllers() {
    }

    public static final synchronized boolean getNextDeviceEvent(Event event, LinuxEventDevice linuxEventDevice) throws IOException {
        while (linuxEventDevice.getNextEvent(linux_event)) {
            LinuxAxisDescriptor linuxAxisDescriptor = linux_event.getDescriptor();
            LinuxComponent linuxComponent = linuxEventDevice.mapDescriptor(linuxAxisDescriptor);
            if (linuxComponent == null) continue;
            float f2 = linuxComponent.convertValue(linux_event.getValue(), linuxAxisDescriptor);
            event.set(linuxComponent, f2, linux_event.getNanos());
            return true;
        }
        return false;
    }

    public static final synchronized float poll(LinuxEventComponent linuxEventComponent) throws IOException {
        int n2 = linuxEventComponent.getDescriptor().getType();
        switch (n2) {
            case 1: {
                int n3 = linuxEventComponent.getDescriptor().getCode();
                float f2 = linuxEventComponent.getDevice().isKeySet(n3) ? 1.0f : 0.0f;
                return f2;
            }
            case 3: {
                linuxEventComponent.getAbsInfo(abs_info);
                return abs_info.getValue();
            }
        }
        throw new RuntimeException(new StringBuffer().append("Unkown native_type: ").append(n2).toString());
    }
}

