/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.AbstractController;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Controller$Type;
import net.java.games.input.Event;
import net.java.games.input.Rumbler;
import net.java.games.input.WinTabComponent;
import net.java.games.input.WinTabContext;
import net.java.games.input.WinTabEnvironmentPlugin;
import net.java.games.input.WinTabPacket;

public class WinTabDevice
extends AbstractController {
    private WinTabContext context;
    private List eventList = new ArrayList();

    private WinTabDevice(WinTabContext winTabContext, int n2, String string, Component[] componentArray) {
        super(string, componentArray, new Controller[0], new Rumbler[0]);
        this.context = winTabContext;
    }

    @Override
    protected boolean getNextDeviceEvent(Event event) throws IOException {
        if (this.eventList.size() > 0) {
            Event event2 = (Event)this.eventList.remove(0);
            event.set(event2);
            return true;
        }
        return false;
    }

    @Override
    protected void pollDevice() throws IOException {
        this.context.processEvents();
        super.pollDevice();
    }

    @Override
    public Controller$Type getType() {
        return Controller$Type.TRACKPAD;
    }

    public void processPacket(WinTabPacket winTabPacket) {
        Component[] componentArray = this.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            Event event = ((WinTabComponent)componentArray[i2]).processPacket(winTabPacket);
            if (event == null) continue;
            this.eventList.add(event);
        }
    }

    public static WinTabDevice createDevice(WinTabContext winTabContext, int n2) {
        int n3;
        String string = WinTabDevice.nGetName(n2);
        WinTabEnvironmentPlugin.logln(new StringBuffer().append("Device ").append(n2).append(", name: ").append(string).toString());
        ArrayList arrayList = new ArrayList();
        int[] nArray = WinTabDevice.nGetAxisDetails(n2, 1);
        if (nArray.length == 0) {
            WinTabEnvironmentPlugin.logln("ZAxis not supported");
        } else {
            WinTabEnvironmentPlugin.logln(new StringBuffer().append("Xmin: ").append(nArray[0]).append(", Xmax: ").append(nArray[1]).toString());
            arrayList.addAll(WinTabComponent.createComponents(winTabContext, n2, 1, nArray));
        }
        nArray = WinTabDevice.nGetAxisDetails(n2, 2);
        if (nArray.length == 0) {
            WinTabEnvironmentPlugin.logln("YAxis not supported");
        } else {
            WinTabEnvironmentPlugin.logln(new StringBuffer().append("Ymin: ").append(nArray[0]).append(", Ymax: ").append(nArray[1]).toString());
            arrayList.addAll(WinTabComponent.createComponents(winTabContext, n2, 2, nArray));
        }
        nArray = WinTabDevice.nGetAxisDetails(n2, 3);
        if (nArray.length == 0) {
            WinTabEnvironmentPlugin.logln("ZAxis not supported");
        } else {
            WinTabEnvironmentPlugin.logln(new StringBuffer().append("Zmin: ").append(nArray[0]).append(", Zmax: ").append(nArray[1]).toString());
            arrayList.addAll(WinTabComponent.createComponents(winTabContext, n2, 3, nArray));
        }
        nArray = WinTabDevice.nGetAxisDetails(n2, 4);
        if (nArray.length == 0) {
            WinTabEnvironmentPlugin.logln("NPressureAxis not supported");
        } else {
            WinTabEnvironmentPlugin.logln(new StringBuffer().append("NPressMin: ").append(nArray[0]).append(", NPressMax: ").append(nArray[1]).toString());
            arrayList.addAll(WinTabComponent.createComponents(winTabContext, n2, 4, nArray));
        }
        nArray = WinTabDevice.nGetAxisDetails(n2, 5);
        if (nArray.length == 0) {
            WinTabEnvironmentPlugin.logln("TPressureAxis not supported");
        } else {
            WinTabEnvironmentPlugin.logln(new StringBuffer().append("TPressureAxismin: ").append(nArray[0]).append(", TPressureAxismax: ").append(nArray[1]).toString());
            arrayList.addAll(WinTabComponent.createComponents(winTabContext, n2, 5, nArray));
        }
        nArray = WinTabDevice.nGetAxisDetails(n2, 6);
        if (nArray.length == 0) {
            WinTabEnvironmentPlugin.logln("OrientationAxis not supported");
        } else {
            WinTabEnvironmentPlugin.logln(new StringBuffer().append("OrientationAxis mins/maxs: ").append(nArray[0]).append(",").append(nArray[1]).append(", ").append(nArray[2]).append(",").append(nArray[3]).append(", ").append(nArray[4]).append(",").append(nArray[5]).toString());
            arrayList.addAll(WinTabComponent.createComponents(winTabContext, n2, 6, nArray));
        }
        nArray = WinTabDevice.nGetAxisDetails(n2, 7);
        if (nArray.length == 0) {
            WinTabEnvironmentPlugin.logln("RotationAxis not supported");
        } else {
            WinTabEnvironmentPlugin.logln("RotationAxis is supported (by the device, not by this plugin)");
            arrayList.addAll(WinTabComponent.createComponents(winTabContext, n2, 7, nArray));
        }
        String[] stringArray = WinTabDevice.nGetCursorNames(n2);
        arrayList.addAll(WinTabComponent.createCursors(winTabContext, n2, stringArray));
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            WinTabEnvironmentPlugin.logln(new StringBuffer().append("Cursor ").append(n3).append("'s name: ").append(stringArray[n3]).toString());
        }
        n3 = WinTabDevice.nGetMaxButtonCount(n2);
        WinTabEnvironmentPlugin.logln(new StringBuffer().append("Device has ").append(n3).append(" buttons").toString());
        arrayList.addAll(WinTabComponent.createButtons(winTabContext, n2, n3));
        Component[] componentArray = arrayList.toArray(new Component[0]);
        return new WinTabDevice(winTabContext, n2, string, componentArray);
    }

    private static final native String nGetName(int var0);

    private static final native int[] nGetAxisDetails(int var0, int var1);

    private static final native String[] nGetCursorNames(int var0);

    private static final native int nGetMaxButtonCount(int var0);
}

