/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.objc;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.bridj.BridJ;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.PointerIO;
import org.bridj.objc.NSInvocation;
import org.bridj.objc.NSMethodSignature;
import org.bridj.objc.ObjCJNI;
import org.bridj.objc.ObjCObject;
import org.bridj.objc.ObjectiveCRuntime;
import org.bridj.objc.SEL;
import org.bridj.util.Pair;
import org.bridj.util.Utils;

public class ObjCProxy
extends ObjCObject {
    final Map signatures = new HashMap();
    final Object invocationTarget;
    static final String PROXY_OBJC_CLASS_NAME = "ObjCProxy";

    protected ObjCProxy() {
        super(null);
        this.peer = ObjCJNI.createObjCProxyPeer(this);
        assert (this.getClass() != ObjCProxy.class);
        this.invocationTarget = this;
    }

    public ObjCProxy(Object object) {
        super(null);
        this.peer = ObjCJNI.createObjCProxyPeer(this);
        assert (object != null);
        this.invocationTarget = object;
    }

    public void addProtocol(String string) throws ClassNotFoundException {
        Pointer pointer = ObjectiveCRuntime.objc_getProtocol(Pointer.pointerToCString(string));
        if (pointer == null) {
            throw new ClassNotFoundException("Protocol " + string + " not found !");
        }
        Pointer pointer2 = ObjectiveCRuntime.getObjCClass(PROXY_OBJC_CLASS_NAME);
        if (!ObjectiveCRuntime.class_addProtocol(pointer2, pointer)) {
            throw new RuntimeException("Failed to add protocol " + string + " to class " + PROXY_OBJC_CLASS_NAME);
        }
    }

    public Object getInvocationTarget() {
        return this.invocationTarget;
    }

    public Pointer methodSignatureForSelector(SEL sEL) {
        Pair pair = this.getMethodAndSignature(sEL);
        return pair == null ? null : Pointer.getPointer((NativeObject)pair.getFirst());
    }

    public synchronized Pair getMethodAndSignature(SEL sEL) {
        Pair pair = (Pair)this.signatures.get(sEL);
        if (pair == null) {
            try {
                pair = this.computeMethodAndSignature(sEL);
                if (pair != null) {
                    this.signatures.put(sEL, pair);
                }
            }
            catch (Throwable throwable) {
                BridJ.error("Failed to compute Objective-C signature for selector " + sEL + ": " + throwable, throwable);
            }
        }
        return pair;
    }

    Pair computeMethodAndSignature(SEL sEL) {
        String string = sEL.getName();
        ObjectiveCRuntime objectiveCRuntime = ObjectiveCRuntime.getInstance();
        for (Method method : this.invocationTarget.getClass().getMethods()) {
            NSMethodSignature nSMethodSignature;
            long l2;
            String string2 = objectiveCRuntime.getSelector(method);
            if (!string2.equals(string)) continue;
            String string3 = objectiveCRuntime.getMethodSignature(method);
            if (BridJ.debug) {
                BridJ.info("Objective-C signature for method " + method + " = '" + string3 + "'");
            }
            if ((l2 = (nSMethodSignature = (NSMethodSignature)NSMethodSignature.signatureWithObjCTypes(Pointer.pointerToCString(string3)).get()).numberOfArguments() - 2L) != (long)method.getParameterTypes().length) {
                throw new RuntimeException("Bad method signature (mismatching arg types) : '" + string3 + "' for " + method);
            }
            return new Pair(nSMethodSignature, method);
        }
        BridJ.error("Missing method for " + sEL + " in class " + ObjCProxy.classHierarchyToString(this.getInvocationTarget().getClass()));
        return null;
    }

    static String classHierarchyToString(Class clazz) {
        String string = Utils.toString(clazz);
        Type type = clazz.getGenericSuperclass();
        while (type != null && type != Object.class && type != ObjCProxy.class) {
            string = string + " extends " + Utils.toString(type);
            type = Utils.getClass(type).getGenericSuperclass();
        }
        return string;
    }

    public synchronized void forwardInvocation(Pointer pointer) {
        Pointer pointer2;
        PointerIO pointerIO;
        Type type;
        NSInvocation nSInvocation = (NSInvocation)pointer.get();
        SEL sEL = nSInvocation.selector();
        Pair pair = this.getMethodAndSignature(sEL);
        NSMethodSignature nSMethodSignature = (NSMethodSignature)pair.getFirst();
        Method method = (Method)pair.getSecond();
        Type[] typeArray = method.getGenericParameterTypes();
        int n2 = typeArray.length;
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            type = typeArray[i2];
            pointerIO = PointerIO.getInstance(type);
            pointer2 = Pointer.allocate(pointerIO);
            nSInvocation.getArgument_atIndex(pointer2, i2 + 2);
            objectArray[i2] = object = pointer2.get();
        }
        try {
            method.setAccessible(true);
            Object object = method.invoke(this.getInvocationTarget(), objectArray);
            type = method.getGenericReturnType();
            if (type == Void.TYPE) {
                assert (object == null);
            } else {
                pointerIO = PointerIO.getInstance(type);
                pointer2 = Pointer.allocate(pointerIO);
                pointer2.set(object);
                nSInvocation.setReturnValue(pointer2);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed to forward invocation from Objective-C to Java invocation target " + this.getInvocationTarget() + " for method " + method + " : " + throwable, throwable);
        }
    }
}

