/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.FilePicker;
import org.eclipse.swt.browser.FilePickerFactory$1;
import org.eclipse.swt.browser.FilePickerFactory$2;
import org.eclipse.swt.browser.FilePicker_10;
import org.eclipse.swt.browser.FilePicker_1_8;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.MozillaVersion;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsID;

class FilePickerFactory {
    XPCOMObject supports;
    XPCOMObject factory;
    int refCount = 0;

    FilePickerFactory() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.supports = new FilePickerFactory$1(this, new int[]{2, 0, 0});
        this.factory = new FilePickerFactory$2(this, new int[]{2, 0, 0, 3, 1});
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.factory != null) {
            this.factory.dispose();
            this.factory = null;
        }
    }

    int getAddress() {
        return this.factory.getAddress();
    }

    int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, n2, 16);
        if (nsID2.Equals(XPCOM.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(n3, new int[]{this.supports.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(XPCOM.NS_IFACTORY_IID)) {
            XPCOM.memmove(n3, new int[]{this.factory.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(n3, new int[]{0}, C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int CreateInstance(int n2, int n3, int n4) {
        if (MozillaVersion.CheckVersion(5)) {
            FilePicker_10 filePicker_10 = new FilePicker_10();
            filePicker_10.AddRef();
            XPCOM.memmove(n4, new int[]{filePicker_10.getAddress()}, C.PTR_SIZEOF);
        } else if (Mozilla.IsXULRunner) {
            FilePicker_1_8 filePicker_1_8 = new FilePicker_1_8();
            filePicker_1_8.AddRef();
            XPCOM.memmove(n4, new int[]{filePicker_1_8.getAddress()}, C.PTR_SIZEOF);
        } else {
            FilePicker filePicker = new FilePicker();
            filePicker.AddRef();
            XPCOM.memmove(n4, new int[]{filePicker.getAddress()}, C.PTR_SIZEOF);
        }
        return 0;
    }

    int LockFactory(int n2) {
        return 0;
    }
}

