/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.browser.MozillaDelegate$1;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.mozilla.IIDStore;
import org.eclipse.swt.internal.mozilla.MozillaVersion;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.internal.mozilla.nsIFocusManager;
import org.eclipse.swt.internal.mozilla.nsIServiceManager;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

class MozillaDelegate {
    Browser browser;
    List childWindows = new ArrayList(9);
    static int MozillaProc;
    static Callback SubclassProc;
    static Boolean IsXULRunner24;
    static final String LIB_XPCOM = "xpcom.dll";
    static final String LIB_XUL = "xul.dll";

    MozillaDelegate(Browser browser) {
        this.browser = browser;
    }

    static Browser findBrowser(int n2) {
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(n2);
    }

    static String getCacheParentPath() {
        TCHAR tCHAR = new TCHAR(0, 260);
        if (OS.SHGetFolderPath(0, 28, 0, 0, tCHAR) == 0) {
            return tCHAR.toString(0, tCHAR.strlen()) + Mozilla.SEPARATOR_OS + "eclipse";
        }
        return MozillaDelegate.getProfilePath();
    }

    static String[] getJSLibraryNames() {
        return new String[]{"mozjs.dll", LIB_XUL};
    }

    static String getJSLibraryName_Pre10() {
        return "js3250.dll";
    }

    static String getLibraryName(String string) {
        if (IsXULRunner24 == null) {
            IsXULRunner24 = new File(string, LIB_XPCOM).exists() ? Boolean.FALSE : Boolean.TRUE;
        }
        return IsXULRunner24 != false ? LIB_XUL : LIB_XPCOM;
    }

    static String getProfilePath() {
        TCHAR tCHAR = new TCHAR(0, 260);
        String string = OS.SHGetFolderPath(0, 26, 0, 0, tCHAR) == 0 ? tCHAR.toString(0, tCHAR.strlen()) : System.getProperty("user.home");
        return string + Mozilla.SEPARATOR_OS + "Mozilla" + Mozilla.SEPARATOR_OS + "eclipse";
    }

    static String getSWTInitLibraryName() {
        return "swt-xulrunner";
    }

    static void loadAdditionalLibraries(String string, boolean bl2) {
    }

    static char[] mbcsToWcs(String string, byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n2 = OS.MultiByteToWideChar(0, 1, byArray, byArray.length, cArray, cArray.length);
        if (n2 == cArray.length) {
            return cArray;
        }
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        return cArray2;
    }

    static boolean needsSpinup() {
        return false;
    }

    static byte[] wcsToMbcs(String string, String string2, boolean bl2) {
        char[] cArray = new char[string2.length()];
        string2.getChars(0, cArray.length, cArray, 0);
        int n2 = cArray.length * 2 + (bl2 ? 1 : 0);
        byte[] byArray = new byte[n2];
        n2 = OS.WideCharToMultiByte(0, 0, cArray, cArray.length, byArray, n2, null, null);
        if (bl2) {
            ++n2;
        } else if (byArray.length != n2) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        return byArray;
    }

    static int windowProc(int n2, int n3, int n4, int n5) {
        switch (n3) {
            case 296: {
                return 0;
            }
            case 20: {
                RECT rECT = new RECT();
                OS.GetClientRect(n2, rECT);
                OS.FillRect(n4, rECT, OS.GetSysColorBrush(OS.COLOR_WINDOW));
            }
        }
        return OS.CallWindowProc(MozillaProc, n2, n3, n4, n5);
    }

    void addWindowSubclass() {
        int n2 = OS.GetWindow(this.browser.handle, 5);
        if (SubclassProc == null) {
            SubclassProc = new Callback(MozillaDelegate.class, "windowProc", 4);
            MozillaProc = OS.GetWindowLongPtr(n2, -4);
        }
        OS.SetWindowLongPtr(n2, -4, SubclassProc.getAddress());
    }

    int createBaseWindow(nsIBaseWindow nsIBaseWindow2) {
        return nsIBaseWindow2.Create();
    }

    int getHandle() {
        return this.browser.handle;
    }

    Point getNativeSize(int n2, int n3) {
        return new Point(n2, n3);
    }

    int getSiteWindow() {
        if (!MozillaVersion.CheckVersion(5) || Mozilla.IsGettingSiteWindow) {
            return this.getHandle();
        }
        Composite composite = new Composite(this.browser, 0);
        this.childWindows.add(composite);
        return composite.handle;
    }

    void handleFocus() {
    }

    void handleMouseDown() {
    }

    boolean hookEnterExit() {
        return true;
    }

    void init() {
        if (MozillaVersion.CheckVersion(5)) {
            this.browser.addListener(31, event -> {
                switch (event.detail) {
                    case 4: {
                        event.doit = false;
                        break;
                    }
                    case 8: 
                    case 16: {
                        int[] nArray = new int[1];
                        int n2 = XPCOM.NS_GetServiceManager(nArray);
                        if (n2 != 0) {
                            Mozilla.error(n2);
                        }
                        if (nArray[0] == 0) {
                            Mozilla.error(-2147467262);
                        }
                        nsIServiceManager nsIServiceManager2 = new nsIServiceManager(nArray[0]);
                        nArray[0] = 0;
                        byte[] byArray = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/focus-manager;1", true);
                        n2 = nsIServiceManager2.GetServiceByContractID(byArray, IIDStore.GetIID(nsIFocusManager.class, 5), nArray);
                        nsIServiceManager2.Release();
                        if (n2 != 0 || nArray[0] == 0) break;
                        nsIFocusManager nsIFocusManager2 = new nsIFocusManager(nArray[0]);
                        nArray[0] = 0;
                        n2 = nsIFocusManager2.GetFocusedElement(nArray);
                        nsIFocusManager2.Release();
                        boolean bl2 = event.doit = nArray[0] == 0;
                        if (n2 != 0 || nArray[0] == 0) break;
                        new nsISupports(nArray[0]).Release();
                        break;
                    }
                }
            });
            this.browser.addLocationListener(new MozillaDelegate$1(this));
        }
    }

    void onDispose(int n2) {
        if (SubclassProc == null) {
            return;
        }
        int n3 = OS.GetWindow(this.browser.handle, 5);
        OS.SetWindowLongPtr(n3, -4, MozillaProc);
        this.childWindows = null;
        this.browser = null;
    }

    void removeWindowSubclass() {
        int n2 = OS.GetWindow(this.browser.handle, 5);
        if (SubclassProc != null) {
            OS.SetWindowLongPtr(n2, -4, MozillaProc);
        }
    }

    boolean sendTraverse() {
        return false;
    }

    void setSize(int n2, int n3, int n4) {
    }
}

