/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.WebDownloadDelegate$1;
import org.eclipse.swt.browser.WebDownloadDelegate$2;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.webkit.IWebDownload;
import org.eclipse.swt.internal.webkit.IWebMutableURLRequest;
import org.eclipse.swt.internal.webkit.IWebURLResponse;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

class WebDownloadDelegate {
    COMObject iWebDownloadDelegate;
    Browser browser;
    int refCount = 0;
    int status = -1;
    long size;
    long totalSize;
    String url;
    static final int DOWNLOAD_FINISHED = 0;
    static final int DOWNLOAD_CANCELLED = 1;
    static final int DOWNLOAD_ERROR = 3;

    WebDownloadDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.iWebDownloadDelegate = new WebDownloadDelegate$1(this, new int[]{2, 0, 0, 2, 2, 2, 2, 2, 2, 2, 3, 3, 4, 1, 1});
    }

    int decideDestinationWithSuggestedFilename(int n2, int n3) {
        String string = WebKit.extractBSTR(n3);
        FileDialog fileDialog = new FileDialog(this.browser.getShell(), 8192);
        fileDialog.setText(SWT.getMessage("SWT_FileDownload"));
        fileDialog.setFileName(string);
        fileDialog.setOverwrite(true);
        String string2 = fileDialog.open();
        IWebDownload iWebDownload = new IWebDownload(n2);
        iWebDownload.setDeletesFileUponFailure(0);
        if (string2 == null) {
            iWebDownload.setDestination(WebKit.createBSTR(""), 1);
            iWebDownload.cancel();
            iWebDownload.Release();
        } else {
            File file = new File(string2);
            if (file.exists()) {
                file.delete();
            }
            iWebDownload.setDestination(WebKit.createBSTR(string2), 1);
            this.openDownloadWindow(iWebDownload, string2);
        }
        return 0;
    }

    int didBegin(int n2) {
        new IWebDownload(n2).AddRef();
        this.status = -1;
        this.size = 0L;
        this.totalSize = 0L;
        this.url = null;
        return 0;
    }

    int didFailWithError(int n2, int n3) {
        new IWebDownload(n2).Release();
        this.status = 3;
        return 0;
    }

    int didFinish(int n2) {
        new IWebDownload(n2).Release();
        this.status = 0;
        return 0;
    }

    int didReceiveDataOfLength(int n2, int n3) {
        this.size += (long)n3;
        return 0;
    }

    int didReceiveResponse(int n2, int n3) {
        if (n3 != 0) {
            int[] nArray;
            IWebURLResponse iWebURLResponse = new IWebURLResponse(n3);
            long[] lArray = new long[1];
            int n4 = iWebURLResponse.expectedContentLength(lArray);
            if (n4 == 0) {
                this.totalSize = lArray[0];
            }
            if ((n4 = iWebURLResponse.URL(nArray = new int[1])) == 0 && nArray[0] != 0) {
                this.url = WebKit.extractBSTR(nArray[0]);
                COM.SysFreeString(nArray[0]);
            }
        }
        return 0;
    }

    void disposeCOMInterfaces() {
        if (this.iWebDownloadDelegate != null) {
            this.iWebDownloadDelegate.dispose();
            this.iWebDownloadDelegate = null;
        }
    }

    int getAddress() {
        return this.iWebDownloadDelegate.getAddress();
    }

    void openDownloadWindow(IWebDownload iWebDownload, String string) {
        Shell shell = new Shell();
        shell.setText(Compatibility.getMessage("SWT_FileDownload"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        gridLayout.verticalSpacing = 20;
        shell.setLayout(gridLayout);
        Label label = new Label(shell, 64);
        label.setText(Compatibility.getMessage("SWT_Download_Location", new Object[]{string, this.url}));
        GridData gridData = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int n2 = monitor.getBounds().width / 2;
        int n3 = label.computeSize((int)-1, (int)-1).x;
        gridData.widthHint = Math.min(n3, n2);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        Label label2 = new Label(shell, 0);
        label2.setText(Compatibility.getMessage("SWT_Download_Started"));
        gridData = new GridData(1808);
        label2.setLayoutData(gridData);
        Button button = new Button(shell, 8);
        button.setText(Compatibility.getMessage("SWT_Cancel"));
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        button.setLayoutData(gridData);
        Listener listener = event -> {
            iWebDownload.cancel();
            this.status = 1;
            iWebDownload.Release();
        };
        button.addListener(13, listener);
        Display display = this.browser.getDisplay();
        display.timerExec(500, new WebDownloadDelegate$2(this, shell, label2, button, listener, display));
        shell.pack();
        shell.open();
    }

    int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n2, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(n3, new int[]{this.iWebDownloadDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebDownloadDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, WebKit_win32.IID_IWebDownloadDelegate)) {
            COM.MoveMemory(n3, new int[]{this.iWebDownloadDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebDownloadDelegate.getAddress()).AddRef();
            return 0;
        }
        COM.MoveMemory(n3, new int[]{0}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int willSendRequest(int n2, int n3, int n4, int n5) {
        IWebMutableURLRequest iWebMutableURLRequest = new IWebMutableURLRequest(n3);
        iWebMutableURLRequest.AddRef();
        OS.MoveMemory(n5, new int[]{n3}, C.PTR_SIZEOF);
        return 0;
    }
}

