/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.io.Serializable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.custom.CTabFolder$1;
import org.eclipse.swt.custom.CTabFolder$2;
import org.eclipse.swt.custom.CTabFolder$3;
import org.eclipse.swt.custom.CTabFolder$4;
import org.eclipse.swt.custom.CTabFolder$5;
import org.eclipse.swt.custom.CTabFolder$6;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderLayout;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.DPIUtil$AutoScaleImageDataProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class CTabFolder
extends Composite {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int MIN_TAB_WIDTH = 4;
    public static RGB borderInsideRGB = new RGB(132, 130, 132);
    public static RGB borderMiddleRGB = new RGB(143, 141, 138);
    public static RGB borderOutsideRGB = new RGB(171, 168, 165);
    boolean onBottom = false;
    boolean single = false;
    boolean simple = true;
    int fixedTabHeight = -1;
    int tabHeight;
    int minChars = 20;
    boolean borderVisible = false;
    CTabFolderRenderer renderer;
    CTabItem[] items = new CTabItem[0];
    int firstIndex = -1;
    int selectedIndex = -1;
    int[] priority = new int[0];
    boolean mru = false;
    Listener listener;
    boolean ignoreTraverse;
    boolean useDefaultRenderer;
    CTabFolder2Listener[] folderListeners = new CTabFolder2Listener[0];
    CTabFolderListener[] tabListeners = new CTabFolderListener[0];
    Image selectionBgImage;
    Color[] selectionGradientColors;
    int[] selectionGradientPercents;
    boolean selectionGradientVertical;
    Color selectionForeground;
    Color selectionBackground;
    Color[] gradientColors;
    int[] gradientPercents;
    boolean gradientVertical;
    boolean showUnselectedImage = true;
    boolean showClose = false;
    boolean showUnselectedClose = true;
    boolean showMin = false;
    boolean minimized = false;
    boolean showMax = false;
    boolean maximized = false;
    ToolBar minMaxTb;
    ToolItem maxItem;
    ToolItem minItem;
    Image maxImage;
    Image minImage;
    boolean hoverTb;
    Rectangle hoverRect = new Rectangle(0, 0, 0, 0);
    boolean hovering;
    boolean hoverTimerRunning;
    boolean highlight;
    boolean highlightEnabled = true;
    boolean showChevron = false;
    Menu showMenu;
    ToolBar chevronTb;
    ToolItem chevronItem;
    int chevronCount;
    boolean chevronVisible = true;
    Image chevronImage;
    Control topRight;
    int topRightAlignment = 131072;
    boolean ignoreResize;
    Control[] controls;
    int[] controlAlignments;
    Rectangle[] controlRects;
    Image[] controlBkImages;
    int updateFlags;
    static final int REDRAW = 2;
    static final int REDRAW_TABS = 4;
    static final int UPDATE_TAB_HEIGHT = 8;
    Runnable updateRun;
    boolean inDispose = false;
    Point oldSize;
    Font oldFont;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int SELECTION_FOREGROUND = 24;
    static final int SELECTION_BACKGROUND = 25;
    static final int FOREGROUND = 21;
    static final int BACKGROUND = 22;
    static final int SPACING = 3;

    public CTabFolder(Composite composite, int n2) {
        super(composite, CTabFolder.checkStyle(composite, n2));
        this.init(n2);
    }

    void init(int n2) {
        super.setLayout(new CTabFolderLayout());
        int n3 = super.getStyle();
        this.oldFont = this.getFont();
        this.onBottom = (n3 & 0x400) != 0;
        this.showClose = (n3 & 0x40) != 0;
        this.single = (n3 & 4) != 0;
        this.borderVisible = (n2 & 0x800) != 0;
        Display display = this.getDisplay();
        this.selectionForeground = display.getSystemColor(24);
        this.selectionBackground = display.getSystemColor(25);
        this.renderer = new CTabFolderRenderer(this);
        this.useDefaultRenderer = true;
        this.controls = new Control[0];
        this.controlAlignments = new int[0];
        this.controlRects = new Rectangle[0];
        this.controlBkImages = new Image[0];
        this.updateTabHeight(false);
        this.listener = event -> {
            switch (event.type) {
                case 12: {
                    this.onDispose(event);
                    break;
                }
                case 29: {
                    this.onDragDetect(event);
                    break;
                }
                case 15: {
                    this.onFocus(event);
                    break;
                }
                case 16: {
                    this.onFocus(event);
                    break;
                }
                case 1: {
                    this.onKeyDown(event);
                    break;
                }
                case 35: {
                    this.onMenuDetect(event);
                    break;
                }
                case 8: {
                    this.onMouseDoubleClick(event);
                    break;
                }
                case 3: {
                    this.onMouse(event);
                    break;
                }
                case 6: {
                    this.onMouse(event);
                    break;
                }
                case 7: {
                    this.onMouse(event);
                    break;
                }
                case 32: {
                    this.onMouse(event);
                    break;
                }
                case 5: {
                    this.onMouse(event);
                    break;
                }
                case 4: {
                    this.onMouse(event);
                    break;
                }
                case 9: {
                    this.onPaint(event);
                    break;
                }
                case 11: {
                    this.onResize(event);
                    break;
                }
                case 31: {
                    this.onTraverse(event);
                    break;
                }
                case 13: {
                    this.onSelection(event);
                    break;
                }
                case 26: {
                    this.onActivate(event);
                    break;
                }
                case 27: {
                    this.onDeactivate(event);
                }
            }
        };
        int[] nArray = new int[]{12, 29, 15, 16, 1, 35, 8, 3, 6, 7, 32, 5, 4, 9, 11, 31, 26, 27};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.addListener(nArray[i2], this.listener);
        }
        this.initAccessible();
    }

    void onDeactivate(Event event) {
        if (!this.highlightEnabled) {
            return;
        }
        for (Composite composite = this; composite != null; composite = composite.getParent()) {
            if (!(composite instanceof CTabFolder)) continue;
            composite.highlight = false;
        }
        this.redraw();
    }

    void onActivate(Event event) {
        if (!this.highlightEnabled) {
            return;
        }
        for (Composite composite = this; composite != null; composite = composite.getParent()) {
            if (!(composite instanceof CTabFolder)) continue;
            composite.highlight = true;
        }
        this.redraw();
    }

    static int checkStyle(Composite composite, int n2) {
        int n3 = 109053126;
        if (((n2 &= n3) & 0x80) != 0) {
            n2 &= 0xFFFFFBFF;
        }
        if ((n2 & 2) != 0) {
            n2 &= 0xFFFFFFFB;
        }
        if (((n2 |= 0x100000) & 0x4000000) != 0) {
            return n2;
        }
        if ((composite.getStyle() & 0x8000000) != 0 && (n2 & 0x2000000) == 0) {
            return n2;
        }
        return n2 | 0x20000000;
    }

    public void addCTabFolder2Listener(CTabFolder2Listener cTabFolder2Listener) {
        this.checkWidget();
        if (cTabFolder2Listener == null) {
            SWT.error(4);
        }
        CTabFolder2Listener[] cTabFolder2ListenerArray = new CTabFolder2Listener[this.folderListeners.length + 1];
        System.arraycopy(this.folderListeners, 0, cTabFolder2ListenerArray, 0, this.folderListeners.length);
        this.folderListeners = cTabFolder2ListenerArray;
        this.folderListeners[this.folderListeners.length - 1] = cTabFolder2Listener;
    }

    public void addCTabFolderListener(CTabFolderListener cTabFolderListener) {
        this.checkWidget();
        if (cTabFolderListener == null) {
            SWT.error(4);
        }
        CTabFolderListener[] cTabFolderListenerArray = new CTabFolderListener[this.tabListeners.length + 1];
        System.arraycopy(this.tabListeners, 0, cTabFolderListenerArray, 0, this.tabListeners.length);
        this.tabListeners = cTabFolderListenerArray;
        this.tabListeners[this.tabListeners.length - 1] = cTabFolderListener;
        if (!this.showClose) {
            this.showClose = true;
            this.updateFolder(2);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    Rectangle[] computeControlBounds(Point point, boolean[][] blArray) {
        int n2;
        int n3;
        int n4;
        Point point2;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (this.controls == null || this.controls.length == 0) {
            return new Rectangle[0];
        }
        Rectangle[] rectangleArray = new Rectangle[this.controls.length];
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            rectangleArray[i2] = new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        int n10 = rectangle.width + rectangle.x;
        int n11 = -rectangle.x;
        int n12 = rectangle.height + rectangle.y;
        int n13 = -rectangle.y;
        Point[] pointArray = new Point[this.controls.length];
        boolean[] blArray2 = new boolean[this.controls.length];
        int n14 = 0;
        int n15 = n11 + 3;
        int n16 = 0;
        int n17 = 0;
        for (n9 = 0; n9 < this.controls.length; ++n9) {
            pointArray[n9] = !this.controls[n9].isDisposed() && this.controls[n9].getVisible() ? this.controls[n9].computeSize(-1, -1) : new Point(0, 0);
            Point point3 = pointArray[n9];
            n8 = this.controlAlignments[n9];
            if ((n8 & 0x4000) != 0) {
                rectangleArray[n9].width = point3.x;
                rectangleArray[n9].height = this.getControlHeight(point3);
                rectangleArray[n9].x = n15;
                rectangleArray[n9].y = this.getControlY(point, rectangleArray, n12, n13, n9);
                n15 += point3.x;
                n14 += point3.x;
                continue;
            }
            if ((n8 & 0x44) == 0) {
                n16 += point3.x;
            }
            n17 += point3.x;
        }
        if (n14 > 0) {
            n14 += 6;
        }
        n9 = 0;
        for (n7 = 0; n7 < this.items.length; ++n7) {
            if (!this.items[n7].showing) continue;
            n9 += this.items[n7].width;
        }
        n7 = point.x - n11 - n14 - n10;
        n8 = Math.max(0, n7 - n9 - n16);
        if (n16 > 0) {
            n8 -= 6;
        }
        n15 = point.x - n10 - 3;
        if (n9 + n17 <= n7) {
            for (n6 = 0; n6 < this.controls.length; ++n6) {
                n5 = this.controlAlignments[n6];
                if ((n5 & 0x20000) != 0) {
                    point2 = pointArray[n6];
                    rectangleArray[n6].width = point2.x;
                    rectangleArray[n6].height = this.getControlHeight(point2);
                    rectangleArray[n6].x = n15 -= point2.x;
                    rectangleArray[n6].y = this.getControlY(point, rectangleArray, n12, n13, n6);
                    if ((n5 & 0x44) != 0) {
                        n8 -= point2.x;
                    }
                }
                if (pointArray[n6].y < this.tabHeight || this.fixedTabHeight != -1) continue;
                blArray2[n6] = true;
            }
        } else {
            for (n6 = 0; n6 < this.controls.length; ++n6) {
                n5 = this.controlAlignments[n6];
                point2 = pointArray[n6];
                if ((n5 & 0x20000) == 0) continue;
                if ((n5 & 0x44) == 0) {
                    rectangleArray[n6].width = point2.x;
                    rectangleArray[n6].height = this.getControlHeight(point2);
                    rectangleArray[n6].x = n15 -= point2.x;
                    rectangleArray[n6].y = this.getControlY(point, rectangleArray, n12, n13, n6);
                    continue;
                }
                if ((n5 & 0x40) != 0 && point2.x < n8) {
                    rectangleArray[n6].width = point2.x;
                    rectangleArray[n6].height = this.getControlHeight(point2);
                    rectangleArray[n6].x = n15 -= point2.x;
                    rectangleArray[n6].y = this.getControlY(point, rectangleArray, n12, n13, n6);
                    n8 -= point2.x;
                    continue;
                }
                if ((n5 & 4) != 0 && (n5 & 0x40) == 0) {
                    rectangleArray[n6].width = 0;
                    rectangleArray[n6].height = this.getControlHeight(point2);
                    rectangleArray[n6].x = n15;
                    rectangleArray[n6].y = this.getControlY(point, rectangleArray, n12, n13, n6);
                    continue;
                }
                if ((n5 & 0x40) == 0) continue;
                blArray2[n6] = true;
            }
        }
        if (n8 > 0) {
            n6 = 0;
            for (n5 = 0; n5 < this.controls.length; ++n5) {
                int n18 = this.controlAlignments[n5];
                if ((n18 & 0x20000) == 0 || (n18 & 4) == 0 || blArray2[n5]) continue;
                ++n6;
            }
            if (n6 != 0) {
                n5 = n8 / n6;
                int n19 = 0;
                for (n4 = 0; n4 < this.controls.length; ++n4) {
                    n3 = this.controlAlignments[n4];
                    if ((n3 & 0x20000) == 0) continue;
                    if ((n3 & 4) != 0 && !blArray2[n4]) {
                        rectangleArray[n4].width += n5;
                        n19 += n5;
                    }
                    if (blArray2[n4]) continue;
                    rectangleArray[n4].x -= n19;
                }
            }
        }
        Rectangle rectangle2 = this.renderer.computeTrim(-1, 0, 0, 0, 0, 0);
        n5 = rectangle2.width + rectangle2.x;
        int n20 = -rectangle2.x;
        n4 = point.x - n20 - n5;
        n15 = point.x - n5;
        n3 = this.onBottom ? this.getSize().y - this.getTabHeight() + 2 * rectangle2.y : -rectangle2.y;
        n8 = n4;
        int n21 = 0;
        for (n2 = 0; n2 < this.controls.length; ++n2) {
            Point point4 = pointArray[n2];
            if (!blArray2[n2]) continue;
            if (n8 > point4.x) {
                rectangleArray[n2].width = point4.x;
                rectangleArray[n2].y = this.onBottom ? n3 - point4.y : n3;
                rectangleArray[n2].height = point4.y;
                rectangleArray[n2].x = n15 -= point4.x;
                n8 -= point4.x;
                n21 = Math.max(n21, point4.y);
                continue;
            }
            n15 = point.x - n5;
            n3 += n21;
            n21 = 0;
            n8 = n4;
            if (n8 > point4.x) {
                --n2;
                continue;
            }
            point4 = this.controls[n2].isDisposed() ? new Point(0, 0) : this.controls[n2].computeSize(n4, -1);
            rectangleArray[n2].width = n4;
            rectangleArray[n2].y = this.onBottom ? n3 - point4.y : n3;
            rectangleArray[n2].height = point4.y;
            rectangleArray[n2].x = point.x - point4.x - n5;
            n3 += point4.y;
        }
        if (this.showChevron) {
            n2 = 0;
            int n22 = -1;
            while (n2 < this.priority.length && this.items[this.priority[n2]].showing) {
                n22 = Math.max(n22, this.priority[n2++]);
            }
            if (n22 == -1) {
                n22 = this.selectedIndex;
            }
            if (n22 != -1) {
                CTabItem cTabItem = this.items[n22];
                int n23 = cTabItem.x + cTabItem.width + 3;
                if (!this.simple && n22 == this.selectedIndex) {
                    n23 -= this.renderer.curveIndent - 7;
                }
                rectangleArray[this.controls.length - 1].x = n23;
            }
        }
        if (blArray != null) {
            blArray[0] = blArray2;
        }
        return rectangleArray;
    }

    int getControlHeight(Point point) {
        return this.fixedTabHeight == -1 ? Math.max(this.tabHeight - 1, point.y) : point.y;
    }

    @Override
    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        Rectangle rectangle = this.renderer.computeTrim(-1, 0, n2, n3, n4, n5);
        Point point = new Point(n4, n5);
        int n6 = this.getWrappedHeight(point);
        if (this.onBottom) {
            rectangle.height += n6;
        } else {
            rectangle.y -= n6;
            rectangle.height += n6;
        }
        return rectangle;
    }

    Image createButtonImage(Display display, int n2) {
        GC gC = new GC(this);
        Point point = this.renderer.computeSize(n2, 0, gC, -1, -1);
        gC.dispose();
        Rectangle rectangle = this.renderer.computeTrim(n2, 0, 0, 0, 0, 0);
        Image image = new Image((Device)display, point.x - rectangle.width, point.y - rectangle.height);
        GC gC2 = new GC(image);
        RGB rGB = n2 == -7 ? new RGB(255, 255, 255) : new RGB(247, 0, 0);
        Color color = new Color((Device)display, rGB);
        gC2.setBackground(color);
        gC2.fillRectangle(image.getBounds());
        this.renderer.draw(n2, 0, new Rectangle(rectangle.x, rectangle.y, point.x, point.y), gC2);
        gC2.dispose();
        color.dispose();
        ImageData imageData = image.getImageData(DPIUtil.getDeviceZoom());
        imageData.transparentPixel = imageData.palette.getPixel(rGB);
        image.dispose();
        image = new Image((Device)display, new DPIUtil$AutoScaleImageDataProvider(display, imageData, DPIUtil.getDeviceZoom()));
        return image;
    }

    void createItem(CTabItem cTabItem, int n2) {
        if (0 > n2 || n2 > this.getItemCount()) {
            SWT.error(6);
        }
        cTabItem.parent = this;
        CTabItem[] cTabItemArray = new CTabItem[this.items.length + 1];
        System.arraycopy(this.items, 0, cTabItemArray, 0, n2);
        cTabItemArray[n2] = cTabItem;
        System.arraycopy(this.items, n2, cTabItemArray, n2 + 1, this.items.length - n2);
        this.items = cTabItemArray;
        if (this.selectedIndex >= n2) {
            ++this.selectedIndex;
        }
        int[] nArray = new int[this.priority.length + 1];
        int n3 = 0;
        int n4 = this.priority.length;
        for (int i2 = 0; i2 < this.priority.length; ++i2) {
            if (!this.mru && this.priority[i2] == n2) {
                n4 = n3++;
            }
            nArray[n3++] = this.priority[i2] >= n2 ? this.priority[i2] + 1 : this.priority[i2];
        }
        nArray[n4] = n2;
        this.priority = nArray;
        if (this.items.length == 1) {
            this.updateFolder(10);
        } else {
            this.updateFolder(4);
        }
    }

    void destroyItem(CTabItem cTabItem) {
        if (this.inDispose) {
            return;
        }
        int n2 = this.indexOf(cTabItem);
        if (n2 == -1) {
            return;
        }
        if (this.items.length == 1) {
            this.items = new CTabItem[0];
            this.priority = new int[0];
            this.firstIndex = -1;
            this.selectedIndex = -1;
            Control control = cTabItem.control;
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            this.setToolTipText(null);
            GC gC = new GC(this);
            this.setButtonBounds(gC);
            gC.dispose();
            this.redraw();
            return;
        }
        CTabItem[] cTabItemArray = new CTabItem[this.items.length - 1];
        System.arraycopy(this.items, 0, cTabItemArray, 0, n2);
        System.arraycopy(this.items, n2 + 1, cTabItemArray, n2, this.items.length - n2 - 1);
        this.items = cTabItemArray;
        int[] nArray = new int[this.priority.length - 1];
        int n3 = 0;
        for (int i2 = 0; i2 < this.priority.length; ++i2) {
            if (this.priority[i2] == n2) continue;
            nArray[n3++] = this.priority[i2] > n2 ? this.priority[i2] - 1 : this.priority[i2];
        }
        this.priority = nArray;
        if (this.selectedIndex == n2) {
            Control control = cTabItem.getControl();
            this.selectedIndex = -1;
            int n4 = this.mru ? this.priority[0] : Math.max(0, n2 - 1);
            this.setSelection(n4, true);
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        } else if (this.selectedIndex > n2) {
            --this.selectedIndex;
        }
        this.updateFolder(12);
    }

    public boolean getBorderVisible() {
        this.checkWidget();
        return this.borderVisible;
    }

    ToolBar getChevron() {
        if (this.chevronTb == null) {
            this.chevronTb = new ToolBar(this, 0x800000);
            this.initAccessibleChevronTb();
            this.addTabControl(this.chevronTb, 131072, -1, false);
        }
        if (this.chevronItem == null) {
            this.chevronItem = new ToolItem(this.chevronTb, 8);
            this.chevronItem.setToolTipText(SWT.getMessage("SWT_ShowList"));
            this.chevronItem.addListener(13, this.listener);
        }
        return this.chevronTb;
    }

    boolean getChevronVisible() {
        this.checkWidget();
        return this.chevronVisible;
    }

    @Override
    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle rectangle = this.renderer.computeTrim(-1, 4, 0, 0, 0, 0);
        Point point = this.getSize();
        int n2 = this.getWrappedHeight(point);
        if (this.onBottom) {
            rectangle.height += n2;
        } else {
            rectangle.y -= n2;
            rectangle.height += n2;
        }
        if (this.minimized) {
            return new Rectangle(-rectangle.x, -rectangle.y, 0, 0);
        }
        int n3 = point.x - rectangle.width;
        int n4 = point.y - rectangle.height;
        return new Rectangle(-rectangle.x, -rectangle.y, n3, n4);
    }

    public CTabItem getItem(int n2) {
        if (n2 < 0 || n2 >= this.items.length) {
            SWT.error(6);
        }
        return this.items[n2];
    }

    public CTabItem getItem(Point point) {
        if (this.items.length == 0) {
            return null;
        }
        this.runUpdate();
        Point point2 = this.getSize();
        Rectangle rectangle = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        if (point2.x <= rectangle.width) {
            return null;
        }
        for (int i2 = 0; i2 < this.priority.length; ++i2) {
            CTabItem cTabItem = this.items[this.priority[i2]];
            Rectangle rectangle2 = cTabItem.getBounds();
            if (!rectangle2.contains(point)) continue;
            return cTabItem;
        }
        return null;
    }

    public int getItemCount() {
        return this.items.length;
    }

    public CTabItem[] getItems() {
        CTabItem[] cTabItemArray = new CTabItem[this.items.length];
        System.arraycopy(this.items, 0, cTabItemArray, 0, this.items.length);
        return cTabItemArray;
    }

    int getLeftItemEdge(GC gC, int n2) {
        Rectangle rectangle = this.renderer.computeTrim(n2, 0, 0, 0, 0, 0);
        int n3 = -rectangle.x;
        int n4 = 0;
        for (int i2 = 0; i2 < this.controls.length; ++i2) {
            if ((this.controlAlignments[i2] & 0x4000) == 0 || this.controls[i2].isDisposed() || !this.controls[i2].getVisible()) continue;
            n4 += this.controls[i2].computeSize((int)-1, (int)-1).x;
        }
        if (n4 != 0) {
            n4 += 6;
        }
        return Math.max(0, n3 += n4);
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return '\u0000';
            }
            if (string.charAt(n2) != '&') {
                return Character.toLowerCase(string.charAt(n2));
            }
            if (++n2 >= n3) break;
        }
        return '\u0000';
    }

    String stripMnemonic(String string) {
        int n2 = 0;
        int n3 = string.length();
        while (true) {
            if (n2 < n3 && string.charAt(n2) != '&') {
                ++n2;
                continue;
            }
            if (++n2 >= n3) {
                return string;
            }
            if (string.charAt(n2) != '&') {
                return string.substring(0, n2 - 1) + string.substring(n2, n3);
            }
            if (++n2 >= n3) break;
        }
        return string;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    public boolean getMinimizeVisible() {
        this.checkWidget();
        return this.showMin;
    }

    public int getMinimumCharacters() {
        this.checkWidget();
        return this.minChars;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public boolean getMaximizeVisible() {
        this.checkWidget();
        return this.showMax;
    }

    public boolean getMRUVisible() {
        this.checkWidget();
        return this.mru;
    }

    public CTabFolderRenderer getRenderer() {
        this.checkWidget();
        return this.renderer;
    }

    int getRightItemEdge(GC gC) {
        Rectangle rectangle = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        int n2 = this.getSize().x - (rectangle.width + rectangle.x);
        int n3 = 0;
        for (int i2 = 0; i2 < this.controls.length; ++i2) {
            int n4 = this.controlAlignments[i2];
            if ((n4 & 0x40) != 0 || (n4 & 0x4000) != 0 || this.controls[i2].isDisposed() || !this.controls[i2].getVisible()) continue;
            Point point = this.controls[i2].computeSize(-1, -1);
            n3 += point.x;
        }
        if (n3 != 0) {
            n3 += 6;
        }
        return Math.max(0, n2 -= n3);
    }

    public CTabItem getSelection() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.items[this.selectedIndex];
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        return this.selectionForeground;
    }

    public int getSelectionIndex() {
        return this.selectedIndex;
    }

    public boolean getSimple() {
        this.checkWidget();
        return this.simple;
    }

    public boolean getSingle() {
        this.checkWidget();
        return this.single;
    }

    @Override
    public int getStyle() {
        int n2 = super.getStyle();
        n2 &= 0xFFFFFB7F;
        n2 |= this.onBottom ? 1024 : 128;
        n2 &= 0xFFFFFFF9;
        n2 |= this.single ? 4 : 2;
        if (this.borderVisible) {
            n2 |= 0x800;
        }
        n2 &= 0xFFFFFFBF;
        if (this.showClose) {
            n2 |= 0x40;
        }
        return n2;
    }

    public int getTabHeight() {
        this.checkWidget();
        if (this.fixedTabHeight != -1) {
            return this.fixedTabHeight;
        }
        return this.tabHeight - 1;
    }

    public int getTabPosition() {
        this.checkWidget();
        return this.onBottom ? 1024 : 128;
    }

    public Control getTopRight() {
        this.checkWidget();
        return this.topRight;
    }

    public int getTopRightAlignment() {
        this.checkWidget();
        return this.topRightAlignment;
    }

    public boolean getUnselectedCloseVisible() {
        this.checkWidget();
        return this.showUnselectedClose;
    }

    public boolean getUnselectedImageVisible() {
        this.checkWidget();
        return this.showUnselectedImage;
    }

    public int indexOf(CTabItem cTabItem) {
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            if (this.items[i2] != cTabItem) continue;
            return i2;
        }
        return -1;
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new CTabFolder$1(this));
        accessible.addAccessibleControlListener(new CTabFolder$2(this));
        this.addListener(13, event -> {
            if (this.isFocusControl()) {
                if (this.selectedIndex == -1) {
                    accessible.setFocus(-1);
                } else {
                    accessible.setFocus(this.selectedIndex);
                }
            }
        });
        this.addListener(15, event -> {
            if (this.selectedIndex == -1) {
                accessible.setFocus(-1);
            } else {
                accessible.setFocus(this.selectedIndex);
            }
        });
    }

    void initAccessibleMinMaxTb() {
        this.minMaxTb.getAccessible().addAccessibleListener(new CTabFolder$3(this));
    }

    void initAccessibleChevronTb() {
        this.chevronTb.getAccessible().addAccessibleListener(new CTabFolder$4(this));
    }

    void onKeyDown(Event event) {
        this.runUpdate();
        switch (event.keyCode) {
            case 0x1000003: 
            case 0x1000004: {
                int n2;
                int n3;
                int n4 = this.items.length;
                if (n4 == 0) {
                    return;
                }
                if (this.selectedIndex == -1) {
                    return;
                }
                int n5 = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                int n6 = n3 = event.keyCode == n5 ? -1 : 1;
                if (!this.mru) {
                    n2 = this.selectedIndex + n3;
                } else {
                    int[] nArray = new int[this.items.length];
                    int n7 = 0;
                    int n8 = -1;
                    for (int i2 = 0; i2 < this.items.length; ++i2) {
                        if (!this.items[i2].showing) continue;
                        if (i2 == this.selectedIndex) {
                            n8 = n7;
                        }
                        nArray[n7++] = i2;
                    }
                    if (n8 + n3 >= 0 && n8 + n3 < n7) {
                        n2 = nArray[n8 + n3];
                    } else {
                        if (this.showChevron) {
                            Rectangle rectangle = this.chevronItem.getBounds();
                            rectangle = event.display.map((Control)this.chevronTb, (Control)this, rectangle);
                            CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                            cTabFolderEvent.widget = this;
                            cTabFolderEvent.time = event.time;
                            cTabFolderEvent.x = rectangle.x;
                            cTabFolderEvent.y = rectangle.y;
                            cTabFolderEvent.width = rectangle.width;
                            cTabFolderEvent.height = rectangle.height;
                            cTabFolderEvent.doit = true;
                            for (int i3 = 0; i3 < this.folderListeners.length; ++i3) {
                                this.folderListeners[i3].showList(cTabFolderEvent);
                            }
                            if (cTabFolderEvent.doit && !this.isDisposed()) {
                                this.showList(rectangle);
                            }
                        }
                        return;
                    }
                }
                if (n2 < 0 || n2 >= n4) {
                    return;
                }
                this.setSelection(n2, true);
                this.forceFocus();
            }
        }
    }

    void onDispose(Event event) {
        int n2;
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.inDispose = true;
        if (this.showMenu != null && !this.showMenu.isDisposed()) {
            this.showMenu.dispose();
            this.showMenu = null;
        }
        int n3 = this.items.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.items[n2] == null) continue;
            this.items[n2].dispose();
        }
        this.gradientColors = null;
        this.selectionGradientColors = null;
        this.selectionGradientPercents = null;
        this.selectionBgImage = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        if (this.controlBkImages != null) {
            for (n2 = 0; n2 < this.controlBkImages.length; ++n2) {
                if (this.controlBkImages[n2] == null) continue;
                this.controlBkImages[n2].dispose();
                this.controlBkImages[n2] = null;
            }
            this.controlBkImages = null;
        }
        this.controls = null;
        this.controlAlignments = null;
        this.controlRects = null;
        if (this.maxImage != null) {
            this.maxImage.dispose();
        }
        this.maxImage = null;
        if (this.minImage != null) {
            this.minImage.dispose();
        }
        this.minImage = null;
        if (this.chevronImage != null) {
            this.chevronImage.dispose();
        }
        this.chevronImage = null;
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        this.renderer = null;
        this.minItem = null;
        this.maxItem = null;
        this.minMaxTb = null;
        this.chevronItem = null;
        this.chevronTb = null;
        if (this.folderListeners.length != 0) {
            this.folderListeners = new CTabFolder2Listener[0];
        }
        if (this.tabListeners.length != 0) {
            this.tabListeners = new CTabFolderListener[0];
        }
    }

    void onDragDetect(Event event) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            if (!this.items[i2].closeRect.contains(event.x, event.y)) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            event.type = 0;
        }
    }

    void onFocus(Event event) {
        this.checkWidget();
        if (this.selectedIndex >= 0) {
            this.redraw();
        } else {
            this.setSelection(0, true);
        }
    }

    boolean onMnemonic(Event event, boolean bl2) {
        char c2 = event.character;
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            char c3;
            if (this.items[i2] == null || (c3 = this._findMnemonic(this.items[i2].getText())) == '\u0000' || Character.toLowerCase(c2) != c3) continue;
            if (bl2) {
                this.setSelection(i2, true);
                this.forceFocus();
            }
            return true;
        }
        return false;
    }

    void onMenuDetect(Event event) {
        if (event.detail == 1 && this.selectedIndex != -1) {
            CTabItem cTabItem = this.items[this.selectedIndex];
            Rectangle rectangle = this.getDisplay().map((Control)this, null, cTabItem.getBounds());
            if (!rectangle.contains(event.x, event.y)) {
                Rectangle rectangle2 = this.renderer.computeTrim(this.selectedIndex, 0, 0, 0, 0, 0);
                Rectangle rectangle3 = this.renderer.computeTrim(-8, 0, 0, 0, 0, 0);
                event.x = rectangle.x + rectangle.width - cTabItem.closeRect.width + rectangle2.x - rectangle3.width;
                event.y = rectangle.y - rectangle2.y - rectangle3.y;
            }
        }
    }

    void onMouseDoubleClick(Event event) {
        if (event.button != 1 || (event.stateMask & 0x100000) != 0 || (event.stateMask & 0x200000) != 0) {
            return;
        }
        Event event2 = new Event();
        event2.item = this.getItem(new Point(event.x, event.y));
        if (event2.item != null) {
            this.notifyListeners(14, event2);
        }
    }

    void onMouse(Event event) {
        if (this.isDisposed()) {
            return;
        }
        int n2 = event.x;
        int n3 = event.y;
        switch (event.type) {
            case 6: {
                this.setToolTipText(null);
                break;
            }
            case 7: {
                for (int i2 = 0; i2 < this.items.length; ++i2) {
                    CTabItem cTabItem = this.items[i2];
                    if (i2 != this.selectedIndex && cTabItem.closeImageState != 8) {
                        cTabItem.closeImageState = 8;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    if ((cTabItem.state & 0x20) != 0) {
                        cTabItem.state &= 0xFFFFFFDF;
                        this.redraw(cTabItem.x, cTabItem.y, cTabItem.width, cTabItem.height, false);
                    }
                    if (i2 != this.selectedIndex || cTabItem.closeImageState == 0) continue;
                    cTabItem.closeImageState = 0;
                    this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                }
                break;
            }
            case 3: 
            case 32: {
                if (this.hoverTb && this.hoverRect.contains(n2, n3) && !this.hovering) {
                    this.hovering = true;
                    this.updateItems();
                    this.hoverTimerRunning = true;
                    event.display.timerExec(2000, new CTabFolder$5(this));
                    return;
                }
                if (event.button != 1) {
                    return;
                }
                CTabItem cTabItem = null;
                if (this.single) {
                    Rectangle rectangle;
                    if (this.selectedIndex != -1 && (rectangle = this.items[this.selectedIndex].getBounds()).contains(n2, n3)) {
                        cTabItem = this.items[this.selectedIndex];
                    }
                } else {
                    for (int i3 = 0; i3 < this.items.length; ++i3) {
                        Rectangle rectangle = this.items[i3].getBounds();
                        if (!rectangle.contains(n2, n3)) continue;
                        cTabItem = this.items[i3];
                    }
                }
                if (cTabItem == null) break;
                if (cTabItem.closeRect.contains(n2, n3)) {
                    cTabItem.closeImageState = 2;
                    this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    this.update();
                    return;
                }
                int n4 = this.indexOf(cTabItem);
                if (cTabItem.showing) {
                    int n5 = this.selectedIndex;
                    this.setSelection(n4, true);
                    if (n5 == this.selectedIndex) {
                        this.forceFocus();
                    }
                }
                return;
            }
            case 5: {
                this._setToolTipText(event.x, event.y);
                boolean bl2 = false;
                for (int i4 = 0; i4 < this.items.length; ++i4) {
                    CTabItem cTabItem = this.items[i4];
                    bl2 = false;
                    if (cTabItem.getBounds().contains(n2, n3)) {
                        bl2 = true;
                        if (cTabItem.closeRect.contains(n2, n3)) {
                            if (cTabItem.closeImageState != 2 && cTabItem.closeImageState != 32) {
                                cTabItem.closeImageState = 32;
                                this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                            }
                        } else if (cTabItem.closeImageState != 0) {
                            cTabItem.closeImageState = 0;
                            this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                        }
                        if ((cTabItem.state & 0x20) == 0) {
                            cTabItem.state |= 0x20;
                            this.redraw(cTabItem.x, cTabItem.y, cTabItem.width, cTabItem.height, false);
                        }
                    }
                    if (i4 != this.selectedIndex && cTabItem.closeImageState != 8 && !bl2) {
                        cTabItem.closeImageState = 8;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    if ((cTabItem.state & 0x20) != 0 && !bl2) {
                        cTabItem.state &= 0xFFFFFFDF;
                        this.redraw(cTabItem.x, cTabItem.y, cTabItem.width, cTabItem.height, false);
                    }
                    if (i4 != this.selectedIndex || cTabItem.closeImageState == 0 || bl2) continue;
                    cTabItem.closeImageState = 0;
                    this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                }
                break;
            }
            case 4: {
                Object object;
                int n6;
                Serializable serializable;
                if (event.button != 1) {
                    return;
                }
                CTabItem cTabItem = null;
                if (this.single) {
                    Rectangle rectangle;
                    if (this.selectedIndex != -1 && (rectangle = this.items[this.selectedIndex].getBounds()).contains(n2, n3)) {
                        cTabItem = this.items[this.selectedIndex];
                    }
                } else {
                    for (int i5 = 0; i5 < this.items.length; ++i5) {
                        serializable = this.items[i5].getBounds();
                        if (!serializable.contains(n2, n3)) continue;
                        cTabItem = this.items[i5];
                    }
                }
                if (cTabItem == null || !cTabItem.closeRect.contains(n2, n3)) break;
                boolean bl3 = cTabItem.closeImageState == 2;
                cTabItem.closeImageState = 32;
                this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                if (!bl3) {
                    return;
                }
                serializable = new CTabFolderEvent(this);
                ((CTabFolderEvent)serializable).widget = this;
                ((CTabFolderEvent)serializable).time = event.time;
                ((CTabFolderEvent)serializable).item = cTabItem;
                ((CTabFolderEvent)serializable).doit = true;
                for (n6 = 0; n6 < this.folderListeners.length; ++n6) {
                    object = this.folderListeners[n6];
                    object.close((CTabFolderEvent)serializable);
                }
                for (n6 = 0; n6 < this.tabListeners.length; ++n6) {
                    object = this.tabListeners[n6];
                    object.itemClosed((CTabFolderEvent)serializable);
                }
                if (((CTabFolderEvent)serializable).doit) {
                    cTabItem.dispose();
                }
                if (!this.isDisposed() && cTabItem.isDisposed()) {
                    Display display = this.getDisplay();
                    object = display.getCursorLocation();
                    object = display.map(null, this, ((Point)object).x, ((Point)object).y);
                    CTabItem cTabItem2 = this.getItem((Point)object);
                    if (cTabItem2 != null) {
                        if (cTabItem2.closeRect.contains((Point)object)) {
                            if (cTabItem2.closeImageState != 2 && cTabItem2.closeImageState != 32) {
                                cTabItem2.closeImageState = 32;
                                this.redraw(cTabItem2.closeRect.x, cTabItem2.closeRect.y, cTabItem2.closeRect.width, cTabItem2.closeRect.height, false);
                            }
                        } else if (cTabItem2.closeImageState != 0) {
                            cTabItem2.closeImageState = 0;
                            this.redraw(cTabItem2.closeRect.x, cTabItem2.closeRect.y, cTabItem2.closeRect.width, cTabItem2.closeRect.height, false);
                        }
                    }
                }
                return;
            }
        }
    }

    void onPageTraversal(Event event) {
        int n2 = this.items.length;
        if (n2 == 0) {
            return;
        }
        int n3 = this.selectedIndex;
        if (n3 == -1) {
            n3 = 0;
        } else {
            int n4;
            int n5 = n4 = event.detail == 512 ? 1 : -1;
            if (!this.mru) {
                n3 = (this.selectedIndex + n4 + n2) % n2;
            } else {
                int[] nArray = new int[this.items.length];
                int n6 = 0;
                int n7 = -1;
                for (int i2 = 0; i2 < this.items.length; ++i2) {
                    if (!this.items[i2].showing) continue;
                    if (i2 == this.selectedIndex) {
                        n7 = n6;
                    }
                    nArray[n6++] = i2;
                }
                if (n7 + n4 >= 0 && n7 + n4 < n6) {
                    n3 = nArray[n7 + n4];
                } else if (this.showChevron) {
                    Rectangle rectangle = this.chevronItem.getBounds();
                    rectangle = event.display.map((Control)this.chevronTb, (Control)this, rectangle);
                    CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                    cTabFolderEvent.widget = this;
                    cTabFolderEvent.time = event.time;
                    cTabFolderEvent.x = rectangle.x;
                    cTabFolderEvent.y = rectangle.y;
                    cTabFolderEvent.width = rectangle.width;
                    cTabFolderEvent.height = rectangle.height;
                    cTabFolderEvent.doit = true;
                    for (int i3 = 0; i3 < this.folderListeners.length; ++i3) {
                        this.folderListeners[i3].showList(cTabFolderEvent);
                    }
                    if (cTabFolderEvent.doit && !this.isDisposed()) {
                        this.showList(rectangle);
                    }
                }
            }
        }
        this.setSelection(n3, true);
    }

    void onPaint(Event event) {
        if (this.inDispose) {
            return;
        }
        Font font = this.getFont();
        if (this.oldFont == null || !this.oldFont.equals(font)) {
            this.oldFont = font;
            if (!this.updateTabHeight(false)) {
                this.updateItems();
                this.redraw();
                return;
            }
        }
        GC gC = event.gc;
        Font font2 = gC.getFont();
        Color color = gC.getBackground();
        Color color2 = gC.getForeground();
        Point point = this.getSize();
        Rectangle rectangle = new Rectangle(0, 0, point.x, point.y);
        this.renderer.draw(-1, 24, rectangle, gC);
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
        this.renderer.draw(-2, 24, rectangle, gC);
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
        if (!this.single) {
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                Rectangle rectangle2 = this.items[i2].getBounds();
                if (i2 == this.selectedIndex || !event.getBounds().intersects(rectangle2)) continue;
                this.renderer.draw(i2, 0x18 | this.items[i2].state, rectangle2, gC);
            }
        }
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
        if (this.selectedIndex != -1) {
            this.renderer.draw(this.selectedIndex, this.items[this.selectedIndex].state | 8 | 0x10, this.items[this.selectedIndex].getBounds(), gC);
        }
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
        if (this.hoverTb) {
            Rectangle rectangle3 = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
            int n2 = this.getSize().x - (rectangle3.width + rectangle3.x);
            this.hoverRect = new Rectangle(n2 - 16 - 3, 2, 16, this.getTabHeight() - 2);
            gC.setForeground(gC.getDevice().getSystemColor(18));
            n2 = this.hoverRect.x;
            int n3 = this.hoverRect.y;
            gC.setBackground(gC.getDevice().getSystemColor(1));
            gC.fillRectangle(n2 + this.hoverRect.width - 6, n3, 5, 5);
            gC.drawRectangle(n2 + this.hoverRect.width - 6, n3, 5, 5);
            gC.drawLine(n2 + this.hoverRect.width - 6, n3 + 2, n2 + this.hoverRect.width - 6 + 5, n3 + 2);
            gC.fillRectangle(n2, n3, 5, 2);
            gC.drawRectangle(n2, n3, 5, 2);
        }
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
    }

    void onResize(Event event) {
        if (this.inDispose) {
            return;
        }
        if (this.ignoreResize) {
            return;
        }
        if (this.updateItems()) {
            this.redrawTabs();
        }
        Point point = this.getSize();
        if (this.oldSize == null) {
            this.redraw();
        } else if (this.onBottom && point.y != this.oldSize.y) {
            this.redraw();
        } else {
            int n2 = Math.min(point.x, this.oldSize.x);
            Rectangle rectangle = this.renderer.computeTrim(-1, 0, 0, 0, 0, 0);
            if (point.x != this.oldSize.x) {
                n2 -= rectangle.width + rectangle.x - this.marginWidth + 2;
            }
            if (!this.simple) {
                n2 -= 5;
            }
            int n3 = Math.min(point.y, this.oldSize.y);
            if (point.y != this.oldSize.y) {
                n3 -= rectangle.height + rectangle.y - this.marginHeight;
            }
            int n4 = Math.max(point.x, this.oldSize.x);
            int n5 = Math.max(point.y, this.oldSize.y);
            this.redraw(0, n3, n4, n5 - n3, false);
            this.redraw(n2, 0, n4 - n2, n5, false);
            if (this.hoverTb) {
                this.redraw(this.hoverRect.x, this.hoverRect.y, this.hoverRect.width, this.hoverRect.height, false);
            }
        }
        this.oldSize = point;
    }

    void onSelection(Event event) {
        if (this.hovering) {
            this.hovering = false;
            this.updateItems();
        }
        if (event.widget == this.maxItem) {
            CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
            cTabFolderEvent.widget = this;
            cTabFolderEvent.time = event.time;
            for (int i2 = 0; i2 < this.folderListeners.length; ++i2) {
                if (this.maximized) {
                    this.folderListeners[i2].restore(cTabFolderEvent);
                    continue;
                }
                this.folderListeners[i2].maximize(cTabFolderEvent);
            }
        } else if (event.widget == this.minItem) {
            CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
            cTabFolderEvent.widget = this;
            cTabFolderEvent.time = event.time;
            for (int i3 = 0; i3 < this.folderListeners.length; ++i3) {
                if (this.minimized) {
                    this.folderListeners[i3].restore(cTabFolderEvent);
                    continue;
                }
                this.folderListeners[i3].minimize(cTabFolderEvent);
            }
        } else if (event.widget == this.chevronItem) {
            Rectangle rectangle = this.chevronItem.getBounds();
            rectangle = event.display.map((Control)this.chevronTb, (Control)this, rectangle);
            CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
            cTabFolderEvent.widget = this;
            cTabFolderEvent.time = event.time;
            cTabFolderEvent.x = rectangle.x;
            cTabFolderEvent.y = rectangle.y;
            cTabFolderEvent.width = rectangle.width;
            cTabFolderEvent.height = rectangle.height;
            cTabFolderEvent.doit = true;
            for (int i4 = 0; i4 < this.folderListeners.length; ++i4) {
                this.folderListeners[i4].showList(cTabFolderEvent);
            }
            if (cTabFolderEvent.doit && !this.isDisposed()) {
                this.showList(rectangle);
            }
        }
    }

    void onTraverse(Event event) {
        if (this.ignoreTraverse) {
            return;
        }
        this.runUpdate();
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                Control control = this.getDisplay().getFocusControl();
                if (control != this) break;
                event.doit = true;
                break;
            }
            case 128: {
                event.doit = this.onMnemonic(event, false);
                break;
            }
            case 256: 
            case 512: {
                event.doit = this.items.length > 0;
            }
        }
        this.ignoreTraverse = true;
        this.notifyListeners(31, event);
        this.ignoreTraverse = false;
        event.type = 0;
        if (this.isDisposed()) {
            return;
        }
        if (!event.doit) {
            return;
        }
        switch (event.detail) {
            case 128: {
                this.onMnemonic(event, true);
                event.detail = 0;
                break;
            }
            case 256: 
            case 512: {
                this.onPageTraversal(event);
                event.detail = 0;
            }
        }
    }

    void redrawTabs() {
        Point point = this.getSize();
        Rectangle rectangle = this.renderer.computeTrim(-1, 0, 0, 0, 0, 0);
        if (this.onBottom) {
            int n2 = rectangle.height + rectangle.y - this.marginHeight;
            this.redraw(0, point.y - n2 - 1, point.x, n2 + 1, false);
        } else {
            this.redraw(0, 0, point.x, -rectangle.y - this.marginHeight + 1, false);
        }
    }

    public void removeCTabFolder2Listener(CTabFolder2Listener cTabFolder2Listener) {
        this.checkWidget();
        if (cTabFolder2Listener == null) {
            SWT.error(4);
        }
        if (this.folderListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.folderListeners.length; ++i2) {
            if (cTabFolder2Listener != this.folderListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.folderListeners.length == 1) {
            this.folderListeners = new CTabFolder2Listener[0];
            return;
        }
        CTabFolder2Listener[] cTabFolder2ListenerArray = new CTabFolder2Listener[this.folderListeners.length - 1];
        System.arraycopy(this.folderListeners, 0, cTabFolder2ListenerArray, 0, n2);
        System.arraycopy(this.folderListeners, n2 + 1, cTabFolder2ListenerArray, n2, this.folderListeners.length - n2 - 1);
        this.folderListeners = cTabFolder2ListenerArray;
    }

    public void removeCTabFolderListener(CTabFolderListener cTabFolderListener) {
        this.checkWidget();
        if (cTabFolderListener == null) {
            SWT.error(4);
        }
        if (this.tabListeners.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.tabListeners.length; ++i2) {
            if (cTabFolderListener != this.tabListeners[i2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (this.tabListeners.length == 1) {
            this.tabListeners = new CTabFolderListener[0];
            return;
        }
        CTabFolderListener[] cTabFolderListenerArray = new CTabFolderListener[this.tabListeners.length - 1];
        System.arraycopy(this.tabListeners, 0, cTabFolderListenerArray, 0, n2);
        System.arraycopy(this.tabListeners, n2 + 1, cTabFolderListenerArray, n2, this.tabListeners.length - n2 - 1);
        this.tabListeners = cTabFolderListenerArray;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    @Override
    public void reskin(int n2) {
        super.reskin(n2);
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            this.items[i2].reskin(n2);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.renderer.createAntialiasColors();
        this.updateBkImages();
        this.redraw();
    }

    public void setBackground(Color[] colorArray, int[] nArray) {
        this.setBackground(colorArray, nArray, false);
    }

    public void setBackground(Color[] colorArray, int[] nArray, boolean bl2) {
        int n2;
        this.checkWidget();
        if (colorArray != null) {
            if (nArray == null || nArray.length != colorArray.length - 1) {
                SWT.error(5);
            }
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] < 0 || nArray[n2] > 100) {
                    SWT.error(5);
                }
                if (n2 <= 0 || nArray[n2] >= nArray[n2 - 1]) continue;
                SWT.error(5);
            }
            if (this.getDisplay().getDepth() < 15) {
                colorArray = new Color[]{colorArray[colorArray.length - 1]};
                nArray = new int[]{};
            }
        }
        if (this.gradientColors != null && colorArray != null && this.gradientColors.length == colorArray.length) {
            int n3;
            n2 = 0;
            for (n3 = 0; n3 < this.gradientColors.length && (n2 = this.gradientColors[n3] == null ? (colorArray[n3] == null ? 1 : 0) : (int)(this.gradientColors[n3].equals(colorArray[n3]) ? 1 : 0)) != 0; ++n3) {
            }
            if (n2 != 0) {
                for (n3 = 0; n3 < this.gradientPercents.length; ++n3) {
                    int n4 = n2 = this.gradientPercents[n3] == nArray[n3] ? 1 : 0;
                    if (n2 == 0) break;
                }
            }
            if (n2 != 0 && this.gradientVertical == bl2) {
                return;
            }
        }
        if (colorArray == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
            this.setBackground(null);
        } else {
            this.gradientColors = new Color[colorArray.length];
            for (n2 = 0; n2 < colorArray.length; ++n2) {
                this.gradientColors[n2] = colorArray[n2];
            }
            this.gradientPercents = new int[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.gradientPercents[n2] = nArray[n2];
            }
            this.gradientVertical = bl2;
            this.setBackground(this.gradientColors[this.gradientColors.length - 1]);
        }
        this.redraw();
    }

    @Override
    public void setBackgroundImage(Image image) {
        super.setBackgroundImage(image);
        this.renderer.createAntialiasColors();
        this.redraw();
    }

    public void setBorderVisible(boolean bl2) {
        this.checkWidget();
        if (this.borderVisible == bl2) {
            return;
        }
        this.borderVisible = bl2;
        this.updateFolder(2);
    }

    void setButtonBounds(GC gC) {
        int n2;
        int n3;
        int n4;
        Point point = this.getSize();
        Display display = this.getDisplay();
        if (this.showMax) {
            if (this.minMaxTb == null) {
                this.minMaxTb = new ToolBar(this, 0x800000);
                this.initAccessibleMinMaxTb();
                this.addTabControl(this.minMaxTb, 131072, 0, false);
            }
            if (this.maxItem == null) {
                this.maxItem = new ToolItem(this.minMaxTb, 8);
                if (this.maxImage == null) {
                    this.maxImage = this.createButtonImage(display, -5);
                }
                this.maxItem.setImage(this.maxImage);
                this.maxItem.setToolTipText(this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize"));
                this.maxItem.addListener(13, this.listener);
            }
        } else if (this.maxItem != null) {
            this.maxItem.dispose();
            this.maxItem = null;
        }
        if (this.showMin) {
            if (this.minMaxTb == null) {
                this.minMaxTb = new ToolBar(this, 0x800000);
                this.initAccessibleMinMaxTb();
                this.addTabControl(this.minMaxTb, 131072, 0, false);
            }
            if (this.minItem == null) {
                this.minItem = new ToolItem(this.minMaxTb, 8, 0);
                if (this.minImage == null) {
                    this.minImage = this.createButtonImage(display, -6);
                }
                this.minItem.setImage(this.minImage);
                this.minItem.setToolTipText(this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize"));
                this.minItem.addListener(13, this.listener);
            }
        } else if (this.minItem != null) {
            this.minItem.dispose();
            this.minItem = null;
        }
        if (this.minMaxTb != null && this.minMaxTb.getItemCount() == 0) {
            this.removeTabControl(this.minMaxTb, false);
            this.minMaxTb.dispose();
            this.minMaxTb = null;
        }
        if (this.showChevron) {
            int n5;
            int n6 = this.items.length;
            if (this.single) {
                n5 = this.selectedIndex == -1 ? n6 : n6 - 1;
            } else {
                for (n4 = 0; n4 < this.priority.length && this.items[this.priority[n4]].showing; ++n4) {
                }
                n5 = n6 - n4;
            }
            if (n5 != this.chevronCount) {
                this.chevronCount = n5;
                if (this.chevronImage != null) {
                    this.chevronImage.dispose();
                }
                this.chevronImage = this.createButtonImage(display, -7);
                this.chevronItem.setImage(this.chevronImage);
            }
        }
        boolean[][] blArray = new boolean[1][0];
        Rectangle[] rectangleArray = this.computeControlBounds(point, blArray);
        if (this.fixedTabHeight != -1) {
            n4 = this.fixedTabHeight;
            if (!this.hovering) {
                this.hoverTb = false;
                Rectangle rectangle = this.getBounds();
                for (n3 = 0; n3 < rectangleArray.length; ++n3) {
                    if (blArray[0][n3] || rectangleArray[n3].height <= n4) continue;
                    this.hoverTb = true;
                    break;
                }
                if (this.hoverTb) {
                    for (n3 = 0; n3 < rectangleArray.length; ++n3) {
                        if (blArray[0][n3] || rectangleArray[n3].height <= n4) continue;
                        rectangleArray[n3].x = rectangle.width + 20;
                    }
                }
            }
        }
        n4 = 0;
        for (n2 = 0; n2 < rectangleArray.length; ++n2) {
            if (blArray[0][n2]) continue;
            n4 = Math.max(rectangleArray[n2].height, n4);
        }
        n2 = 0;
        this.ignoreResize = true;
        for (n3 = 0; n3 < this.controls.length; ++n3) {
            if (!this.controls[n3].isDisposed()) {
                if (blArray[0][n3]) {
                    this.controls[n3].setBounds(rectangleArray[n3]);
                } else {
                    this.controls[n3].moveAbove(null);
                    this.controls[n3].setBounds(rectangleArray[n3].x, rectangleArray[n3].y, rectangleArray[n3].width, n4);
                }
            }
            if (n2 != 0 || rectangleArray[n3].equals(this.controlRects[n3])) continue;
            n2 = 1;
        }
        this.ignoreResize = false;
        this.controlRects = rectangleArray;
        if (n2 != 0 || this.hovering) {
            this.updateBkImages();
        }
    }

    @Override
    public boolean setFocus() {
        CTabItem cTabItem;
        this.checkWidget();
        Control control = this.getDisplay().getFocusControl();
        boolean bl2 = this.isAncestor(control);
        if (bl2 && (cTabItem = this.getSelection()) != null && cTabItem.setFocus()) {
            return true;
        }
        return super.setFocus();
    }

    boolean isAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.getParent();
        }
        return control == this;
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.equals(this.getFont())) {
            return;
        }
        super.setFont(font);
        this.oldFont = this.getFont();
        this.updateFolder(2);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.redraw();
    }

    public void setInsertMark(CTabItem cTabItem, boolean bl2) {
        this.checkWidget();
    }

    public void setInsertMark(int n2, boolean bl2) {
        this.checkWidget();
        if (n2 < -1 || n2 >= this.getItemCount()) {
            SWT.error(5);
        }
    }

    boolean setItemLocation(GC gC) {
        boolean bl2 = false;
        if (this.items.length == 0) {
            return false;
        }
        Rectangle rectangle = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        int n2 = rectangle.height + rectangle.y;
        int n3 = -rectangle.y;
        Point point = this.getSize();
        int n4 = this.onBottom ? Math.max(n2, point.y - n2 - this.tabHeight) : n3;
        Point point2 = this.renderer.computeSize(-8, 0, gC, -1, -1);
        int n5 = this.getLeftItemEdge(gC, -3);
        if (this.single) {
            int n6 = this.getDisplay().getBounds().width + 10;
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                CTabItem cTabItem = this.items[i2];
                if (i2 == this.selectedIndex) {
                    this.firstIndex = this.selectedIndex;
                    int n7 = cTabItem.x;
                    int n8 = cTabItem.y;
                    cTabItem.x = n5;
                    cTabItem.y = n4;
                    cTabItem.showing = true;
                    if (this.showClose || cTabItem.showClose) {
                        cTabItem.closeRect.x = n5 - this.renderer.computeTrim((int)i2, (int)0, (int)0, (int)0, (int)0, (int)0).x;
                        int n9 = cTabItem.closeRect.y = this.onBottom ? point.y - n2 - this.tabHeight + (this.tabHeight - point2.y) / 2 : n3 + (this.tabHeight - point2.y) / 2;
                    }
                    if (cTabItem.x == n7 && cTabItem.y == n8) continue;
                    bl2 = true;
                    continue;
                }
                cTabItem.x = n6;
                cTabItem.showing = false;
            }
        } else {
            int n10;
            int n11 = this.getRightItemEdge(gC);
            int n12 = n11 - n5;
            int n13 = 0;
            for (n10 = 0; n10 < this.priority.length; ++n10) {
                CTabItem cTabItem = this.items[this.priority[n10]];
                cTabItem.showing = n10 == 0 ? true : cTabItem.width > 0 && (n13 += cTabItem.width) <= n12;
            }
            n10 = this.getLeftItemEdge(gC, -2);
            int n14 = this.getDisplay().getBounds().width + 10;
            this.firstIndex = this.items.length - 1;
            for (int i3 = 0; i3 < this.items.length; ++i3) {
                CTabItem cTabItem = this.items[i3];
                if (!cTabItem.showing) {
                    if (cTabItem.x != n14) {
                        bl2 = true;
                    }
                    cTabItem.x = n14;
                    continue;
                }
                this.firstIndex = Math.min(this.firstIndex, i3);
                if (cTabItem.x != n10 || cTabItem.y != n4) {
                    bl2 = true;
                }
                cTabItem.x = n10;
                cTabItem.y = n4;
                int n15 = 0;
                if (i3 == this.selectedIndex) {
                    n15 |= 2;
                }
                Rectangle rectangle2 = this.renderer.computeTrim(i3, n15, 0, 0, 0, 0);
                cTabItem.closeRect.x = cTabItem.x + cTabItem.width - (rectangle2.width + rectangle2.x) - point2.x;
                cTabItem.closeRect.y = this.onBottom ? point.y - n2 - this.tabHeight + (this.tabHeight - point2.y) / 2 : n3 + (this.tabHeight - point2.y) / 2;
                n10 += cTabItem.width;
                if (this.simple || i3 != this.selectedIndex) continue;
                n10 -= this.renderer.curveIndent;
            }
        }
        return bl2;
    }

    void setItemOrder(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length != this.items.length) {
            SWT.error(5);
        }
        int n2 = -1;
        boolean[] blArray = new boolean[this.items.length];
        CTabItem[] cTabItemArray = new CTabItem[this.items.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2];
            if (0 > n3 || n3 >= this.items.length) {
                SWT.error(5);
            }
            if (blArray[n3]) {
                SWT.error(5);
            }
            blArray[n3] = true;
            if (n3 == this.selectedIndex) {
                n2 = i2;
            }
            cTabItemArray[i2] = this.items[n3];
        }
        this.items = cTabItemArray;
        this.selectedIndex = n2;
        this.updateFolder(2);
    }

    boolean setItemSize(GC gC) {
        int[] nArray;
        int n2;
        int n3;
        boolean bl2 = false;
        if (this.isDisposed()) {
            return bl2;
        }
        Point point = this.getSize();
        if (point.x <= 0 || point.y <= 0) {
            return bl2;
        }
        ToolBar toolBar = this.getChevron();
        if (toolBar != null) {
            toolBar.setVisible(false);
        }
        this.showChevron = false;
        if (this.single) {
            boolean bl3 = this.showChevron = this.chevronVisible && this.items.length > 1;
            if (this.showChevron) {
                toolBar.setVisible(true);
            }
            if (this.selectedIndex != -1) {
                CTabItem cTabItem = this.items[this.selectedIndex];
                int n4 = this.renderer.computeSize((int)this.selectedIndex, (int)2, (GC)gC, (int)-1, (int)-1).x;
                n4 = Math.min(n4, this.getRightItemEdge(gC) - this.getLeftItemEdge(gC, -3));
                if (cTabItem.height != this.tabHeight || cTabItem.width != n4) {
                    bl2 = true;
                    cTabItem.shortenedText = null;
                    cTabItem.shortenedTextWidth = 0;
                    cTabItem.height = this.tabHeight;
                    cTabItem.width = n4;
                    cTabItem.closeRect.height = 0;
                    cTabItem.closeRect.width = 0;
                    if (this.showClose || cTabItem.showClose) {
                        Point point2 = this.renderer.computeSize(-8, 2, gC, -1, -1);
                        cTabItem.closeRect.width = point2.x;
                        cTabItem.closeRect.height = point2.y;
                    }
                }
            }
            return bl2;
        }
        if (this.items.length == 0) {
            return bl2;
        }
        int n5 = Math.max(0, this.getRightItemEdge(gC) - this.getLeftItemEdge(gC, -3));
        int n6 = 0;
        int[] nArray2 = new int[this.items.length];
        for (n3 = 0; n3 < this.priority.length; ++n3) {
            int n7 = this.priority[n3];
            n2 = 0x1000000;
            if (n7 == this.selectedIndex) {
                n2 |= 2;
            }
            nArray2[n7] = this.renderer.computeSize((int)n7, (int)n2, (GC)gC, (int)-1, (int)-1).x;
            if ((n6 += nArray2[n7]) > n5) break;
        }
        if (n6 > n5) {
            boolean bl4 = this.showChevron = this.chevronVisible && this.items.length > 1;
            if (this.showChevron) {
                n5 -= toolBar.computeSize((int)-1, (int)-1).x;
                toolBar.setVisible(true);
            }
            nArray = nArray2;
            int n8 = n3 = this.selectedIndex != -1 ? this.selectedIndex : 0;
            if (n5 < nArray[n3]) {
                nArray[n3] = Math.max(0, n5);
            }
        } else {
            int n9;
            n3 = 0;
            int[] nArray3 = new int[this.items.length];
            for (n2 = 0; n2 < this.items.length; ++n2) {
                n9 = 0;
                if (n2 == this.selectedIndex) {
                    n9 |= 2;
                }
                nArray3[n2] = this.renderer.computeSize((int)n2, (int)n9, (GC)gC, (int)-1, (int)-1).x;
                n3 += nArray3[n2];
            }
            if (n3 <= n5) {
                nArray = nArray3;
            } else {
                n2 = (n5 - n6) / this.items.length;
                while (true) {
                    n9 = 0;
                    int n10 = 0;
                    for (int i2 = 0; i2 < this.items.length; ++i2) {
                        if (nArray3[i2] > nArray2[i2] + n2) {
                            n10 += nArray2[i2] + n2;
                            ++n9;
                            continue;
                        }
                        n10 += nArray3[i2];
                    }
                    if (n10 >= n5) {
                        --n2;
                        break;
                    }
                    if (n9 == 0 || n5 - n10 < n9) break;
                    ++n2;
                }
                nArray = new int[this.items.length];
                for (n9 = 0; n9 < this.items.length; ++n9) {
                    nArray[n9] = Math.min(nArray3[n9], nArray2[n9] + n2);
                }
            }
        }
        for (n3 = 0; n3 < this.items.length; ++n3) {
            CTabItem cTabItem = this.items[n3];
            n2 = nArray[n3];
            if (cTabItem.height == this.tabHeight && cTabItem.width == n2) continue;
            bl2 = true;
            cTabItem.shortenedText = null;
            cTabItem.shortenedTextWidth = 0;
            cTabItem.height = this.tabHeight;
            cTabItem.width = n2;
            cTabItem.closeRect.height = 0;
            cTabItem.closeRect.width = 0;
            if (!this.showClose && !cTabItem.showClose || n3 != this.selectedIndex && !this.showUnselectedClose) continue;
            Point point3 = this.renderer.computeSize(-8, 0, gC, -1, -1);
            cTabItem.closeRect.width = point3.x;
            cTabItem.closeRect.height = point3.y;
        }
        return bl2;
    }

    public void setMaximizeVisible(boolean bl2) {
        this.checkWidget();
        if (this.showMax == bl2) {
            return;
        }
        this.showMax = bl2;
        this.updateFolder(10);
    }

    @Override
    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMaximized(boolean bl2) {
        this.checkWidget();
        if (this.maximized == bl2) {
            return;
        }
        if (bl2 && this.minimized) {
            this.setMinimized(false);
        }
        this.maximized = bl2;
        if (this.minMaxTb != null && this.maxItem != null) {
            if (this.maxImage != null) {
                this.maxImage.dispose();
            }
            this.maxImage = this.createButtonImage(this.getDisplay(), -5);
            this.maxItem.setImage(this.maxImage);
            this.maxItem.setToolTipText(this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize"));
        }
    }

    public void setMinimizeVisible(boolean bl2) {
        this.checkWidget();
        if (this.showMin == bl2) {
            return;
        }
        this.showMin = bl2;
        this.updateFolder(10);
    }

    public void setMinimized(boolean bl2) {
        this.checkWidget();
        if (this.minimized == bl2) {
            return;
        }
        if (bl2 && this.maximized) {
            this.setMaximized(false);
        }
        this.minimized = bl2;
        if (this.minMaxTb != null && this.minItem != null) {
            if (this.minImage != null) {
                this.minImage.dispose();
            }
            this.minImage = this.createButtonImage(this.getDisplay(), -6);
            this.minItem.setImage(this.minImage);
            this.minItem.setToolTipText(this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize"));
        }
    }

    public void setMinimumCharacters(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            SWT.error(6);
        }
        if (this.minChars == n2) {
            return;
        }
        this.minChars = n2;
        this.updateFolder(4);
    }

    public void setMRUVisible(boolean bl2) {
        this.checkWidget();
        if (this.mru == bl2) {
            return;
        }
        this.mru = bl2;
        if (!this.mru) {
            if (this.firstIndex == -1) {
                return;
            }
            int n2 = this.firstIndex;
            int n3 = 0;
            int n4 = this.firstIndex;
            while (n4 < this.items.length) {
                this.priority[n3++] = n4++;
            }
            n4 = 0;
            while (n4 < n2) {
                this.priority[n3++] = n4++;
            }
            this.updateFolder(4);
        }
    }

    public void setRenderer(CTabFolderRenderer cTabFolderRenderer) {
        this.checkWidget();
        if (this.renderer == cTabFolderRenderer || this.useDefaultRenderer && cTabFolderRenderer == null) {
            return;
        }
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        boolean bl2 = this.useDefaultRenderer = cTabFolderRenderer == null;
        if (this.useDefaultRenderer) {
            cTabFolderRenderer = new CTabFolderRenderer(this);
        }
        this.renderer = cTabFolderRenderer;
        this.updateFolder(2);
    }

    public void setSelection(CTabItem cTabItem) {
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        int n2 = this.indexOf(cTabItem);
        this.setSelection(n2);
    }

    public void setSelection(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 >= this.items.length) {
            return;
        }
        CTabItem cTabItem = this.items[n2];
        if (this.selectedIndex == n2) {
            this.showItem(cTabItem);
            return;
        }
        int n3 = this.selectedIndex;
        this.selectedIndex = n2;
        if (n3 != -1) {
            this.items[n3].closeImageState = 8;
            this.items[n3].state &= 0xFFFFFFFD;
        }
        cTabItem.closeImageState = 0;
        cTabItem.showing = false;
        cTabItem.state |= 2;
        Control control = cTabItem.control;
        Control control2 = null;
        if (n3 != -1) {
            control2 = this.items[n3].control;
        }
        if (control != control2) {
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            if (control2 != null && !control2.isDisposed()) {
                control2.setVisible(false);
            }
        }
        this.showItem(cTabItem);
        this.redraw();
    }

    void setSelection(int n2, boolean bl2) {
        int n3 = this.selectedIndex;
        this.setSelection(n2);
        if (bl2 && this.selectedIndex != n3 && this.selectedIndex != -1) {
            Event event = new Event();
            event.item = this.getItem(this.selectedIndex);
            this.notifyListeners(13, event);
        }
    }

    public void setSelectionBackground(Color color) {
        if (this.inDispose) {
            return;
        }
        this.checkWidget();
        this.setSelectionHighlightGradientColor(null);
        if (this.selectionBackground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(25);
        }
        this.selectionBackground = color;
        this.renderer.createAntialiasColors();
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionBackground(Color[] colorArray, int[] nArray) {
        this.setSelectionBackground(colorArray, nArray, false);
    }

    public void setSelectionBackground(Color[] colorArray, int[] nArray, boolean bl2) {
        int n2;
        int n3;
        this.checkWidget();
        Color color = null;
        if (colorArray != null) {
            if (nArray == null || nArray.length != colorArray.length - 1 && nArray.length != colorArray.length - 2) {
                SWT.error(5);
            }
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] < 0 || nArray[n3] > 100) {
                    SWT.error(5);
                }
                if (n3 <= 0 || nArray[n3] >= nArray[n3 - 1]) continue;
                SWT.error(5);
            }
            if (nArray.length == colorArray.length - 2) {
                color = colorArray[colorArray.length - 1];
                n2 = colorArray.length - 1;
            } else {
                n2 = colorArray.length;
            }
            if (this.getDisplay().getDepth() < 15) {
                colorArray = new Color[]{colorArray[n2 - 1]};
                n2 = colorArray.length;
                nArray = new int[]{};
            }
        } else {
            n2 = 0;
        }
        if (this.selectionBgImage == null) {
            if (this.selectionGradientColors != null && colorArray != null && this.selectionGradientColors.length == n2) {
                int n4;
                n3 = 0;
                for (n4 = 0; n4 < this.selectionGradientColors.length && (n3 = this.selectionGradientColors[n4] == null ? (colorArray[n4] == null ? 1 : 0) : (int)(this.selectionGradientColors[n4].equals(colorArray[n4]) ? 1 : 0)) != 0; ++n4) {
                }
                if (n3 != 0) {
                    for (n4 = 0; n4 < this.selectionGradientPercents.length; ++n4) {
                        int n5 = n3 = this.selectionGradientPercents[n4] == nArray[n4] ? 1 : 0;
                        if (n3 == 0) break;
                    }
                }
                if (n3 != 0 && this.selectionGradientVertical == bl2) {
                    return;
                }
            }
        } else {
            this.selectionBgImage = null;
        }
        if (colorArray == null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
            this.selectionGradientVertical = false;
            this.setSelectionBackground((Color)null);
            this.setSelectionHighlightGradientColor(null);
        } else {
            this.selectionGradientColors = new Color[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                this.selectionGradientColors[n3] = colorArray[n3];
            }
            this.selectionGradientPercents = new int[nArray.length];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                this.selectionGradientPercents[n3] = nArray[n3];
            }
            this.selectionGradientVertical = bl2;
            this.setSelectionBackground(this.selectionGradientColors[this.selectionGradientColors.length - 1]);
            this.setSelectionHighlightGradientColor(color);
        }
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    void setSelectionHighlightGradientColor(Color color) {
        if (this.inDispose) {
            return;
        }
        this.renderer.setSelectionHighlightGradientColor(color);
    }

    public void setSelectionBackground(Image image) {
        this.checkWidget();
        this.setSelectionHighlightGradientColor(null);
        if (image == this.selectionBgImage) {
            return;
        }
        if (image != null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
            this.renderer.disposeSelectionHighlightGradientColors();
        }
        this.selectionBgImage = image;
        this.renderer.createAntialiasColors();
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (this.selectionForeground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(24);
        }
        this.selectionForeground = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSimple(boolean bl2) {
        this.checkWidget();
        if (this.simple != bl2) {
            this.simple = bl2;
            this.updateFolder(10);
        }
    }

    public void setSingle(boolean bl2) {
        this.checkWidget();
        if (this.single != bl2) {
            this.single = bl2;
            if (!bl2) {
                for (int i2 = 0; i2 < this.items.length; ++i2) {
                    if (i2 == this.selectedIndex || this.items[i2].closeImageState != 0) continue;
                    this.items[i2].closeImageState = 8;
                }
            }
            this.updateFolder(2);
        }
    }

    int getControlY(Point point, Rectangle[] rectangleArray, int n2, int n3, int n4) {
        int n5 = this.fixedTabHeight != -1 ? 0 : (this.tabHeight - rectangleArray[n4].height) / 2;
        return this.onBottom ? point.y - n2 - this.tabHeight + n5 : 1 + n3 + n5;
    }

    public void setTabHeight(int n2) {
        this.checkWidget();
        if (n2 < -1) {
            SWT.error(5);
        }
        this.fixedTabHeight = n2;
        this.updateFolder(8);
    }

    public void setTabPosition(int n2) {
        this.checkWidget();
        if (n2 != 128 && n2 != 1024) {
            SWT.error(5);
        }
        if (this.onBottom != (n2 == 1024)) {
            this.onBottom = n2 == 1024;
            this.updateFolder(2);
        }
    }

    public void setTopRight(Control control) {
        this.setTopRight(control, 131072);
    }

    public void setTopRight(Control control, int n2) {
        this.checkWidget();
        if (n2 != 131072 && n2 != 4 && n2 != 131136) {
            SWT.error(5);
        }
        if (control != null && (control.isDisposed() || control.getParent() != this)) {
            SWT.error(5);
        }
        if (this.topRight == control && this.topRightAlignment == n2) {
            return;
        }
        if (this.topRight != null && !this.topRight.isDisposed()) {
            this.removeTabControl(this.topRight, false);
        }
        this.topRight = control;
        this.topRightAlignment = n2;
        n2 &= 0xFFFDFFFF;
        if (control != null) {
            this.addTabControl(control, 0x20000 | n2, -1, false);
        }
        this.updateFolder(10);
    }

    public void setUnselectedCloseVisible(boolean bl2) {
        this.checkWidget();
        if (this.showUnselectedClose == bl2) {
            return;
        }
        this.showUnselectedClose = bl2;
        this.updateFolder(2);
    }

    public void setUnselectedImageVisible(boolean bl2) {
        this.checkWidget();
        if (this.showUnselectedImage == bl2) {
            return;
        }
        this.showUnselectedImage = bl2;
        this.updateFolder(2);
    }

    public void showItem(CTabItem cTabItem) {
        int n2;
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        if (cTabItem.isDisposed()) {
            SWT.error(5);
        }
        if ((n2 = this.indexOf(cTabItem)) == -1) {
            SWT.error(5);
        }
        int n3 = -1;
        for (int i2 = 0; i2 < this.priority.length; ++i2) {
            if (this.priority[i2] != n2) continue;
            n3 = i2;
            break;
        }
        if (this.mru) {
            int[] nArray = new int[this.priority.length];
            System.arraycopy(this.priority, 0, nArray, 1, n3);
            System.arraycopy(this.priority, n3 + 1, nArray, n3 + 1, this.priority.length - n3 - 1);
            nArray[0] = n2;
            this.priority = nArray;
        }
        if (cTabItem.showing) {
            return;
        }
        this.updateFolder(4);
    }

    void showList(Rectangle rectangle) {
        Object object;
        int n2;
        if (this.items.length == 0 || !this.showChevron) {
            return;
        }
        if (this.showMenu == null || this.showMenu.isDisposed()) {
            this.showMenu = new Menu(this.getShell(), this.getStyle() & 0x6000000);
        } else {
            MenuItem[] menuItemArray = this.showMenu.getItems();
            for (n2 = 0; n2 < menuItemArray.length; ++n2) {
                menuItemArray[n2].dispose();
            }
        }
        for (n2 = 0; n2 < this.items.length; ++n2) {
            CTabItem cTabItem = this.items[n2];
            if (cTabItem.showing) continue;
            object = new MenuItem(this.showMenu, 0);
            ((MenuItem)object).setText(cTabItem.getText());
            ((MenuItem)object).setImage(cTabItem.getImage());
            ((Widget)object).setData("CTabFolder_showList_Index", cTabItem);
            ((MenuItem)object).addSelectionListener(new CTabFolder$6(this));
        }
        n2 = rectangle.x;
        int n3 = rectangle.y + rectangle.height;
        object = this.getDisplay().map(this, null, n2, n3);
        this.showMenu.setLocation(((Point)object).x, ((Point)object).y);
        this.showMenu.setVisible(true);
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selectedIndex != -1) {
            this.showItem(this.getSelection());
        }
    }

    void _setToolTipText(int n2, int n3) {
        String string = this.getToolTipText();
        String string2 = this._getToolTip(n2, n3);
        if (string2 == null || !string2.equals(string)) {
            this.setToolTipText(string2);
        }
    }

    boolean updateItems() {
        return this.updateItems(this.selectedIndex);
    }

    boolean updateItems(int n2) {
        int n3;
        int n4;
        GC gC = new GC(this);
        if (!this.single && !this.mru && n2 != -1) {
            int n5;
            n4 = n2;
            if (this.priority[0] < n2) {
                int n6;
                int n7;
                n3 = this.getRightItemEdge(gC) - this.getLeftItemEdge(gC, -3);
                n5 = 0;
                int[] nArray = new int[this.items.length];
                for (n7 = this.priority[0]; n7 <= n2; ++n7) {
                    n6 = 0x1000000;
                    if (n7 == this.selectedIndex) {
                        n6 |= 2;
                    }
                    nArray[n7] = this.renderer.computeSize((int)n7, (int)n6, (GC)gC, (int)-1, (int)-1).x;
                    if ((n5 += nArray[n7]) > n3) break;
                }
                if (n5 > n3) {
                    n5 = 0;
                    n7 = n2;
                    while (n7 >= 0) {
                        n6 = 0x1000000;
                        if (n7 == this.selectedIndex) {
                            n6 |= 2;
                        }
                        if (nArray[n7] == 0) {
                            nArray[n7] = this.renderer.computeSize((int)n7, (int)n6, (GC)gC, (int)-1, (int)-1).x;
                        }
                        if ((n5 += nArray[n7]) <= n3) {
                            n4 = n7--;
                            continue;
                        }
                        break;
                    }
                } else {
                    n4 = this.priority[0];
                    for (n7 = n2 + 1; n7 < this.items.length; ++n7) {
                        n6 = 0x1000000;
                        if (n7 == this.selectedIndex) {
                            n6 |= 2;
                        }
                        nArray[n7] = this.renderer.computeSize((int)n7, (int)n6, (GC)gC, (int)-1, (int)-1).x;
                        if ((n5 += nArray[n7]) >= n3) break;
                    }
                    if (n5 < n3) {
                        n7 = this.priority[0] - 1;
                        while (n7 >= 0) {
                            n6 = 0x1000000;
                            if (n7 == this.selectedIndex) {
                                n6 |= 2;
                            }
                            if (nArray[n7] == 0) {
                                nArray[n7] = this.renderer.computeSize((int)n7, (int)n6, (GC)gC, (int)-1, (int)-1).x;
                            }
                            if ((n5 += nArray[n7]) <= n3) {
                                n4 = n7--;
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
            if (n4 != this.priority[0]) {
                n3 = 0;
                n5 = n4;
                while (n5 < this.items.length) {
                    this.priority[n3++] = n5++;
                }
                n5 = n4 - 1;
                while (n5 >= 0) {
                    this.priority[n3++] = n5--;
                }
            }
        }
        n4 = this.showChevron;
        n3 = this.setItemSize(gC);
        n3 |= this.setItemLocation(gC);
        this.setButtonBounds(gC);
        if ((n3 |= this.showChevron != n4 ? 1 : 0) != 0 && this.getToolTipText() != null) {
            Point point = this.getDisplay().getCursorLocation();
            point = this.toControl(point);
            this._setToolTipText(point.x, point.y);
        }
        gC.dispose();
        return n3 != 0;
    }

    boolean updateTabHeight(boolean bl2) {
        int n2 = this.tabHeight;
        GC gC = new GC(this);
        this.tabHeight = this.renderer.computeSize((int)-2, (int)0, (GC)gC, (int)-1, (int)-1).y;
        gC.dispose();
        if (this.fixedTabHeight == -1 && this.controls != null && this.controls.length > 0) {
            for (int i2 = 0; i2 < this.controls.length; ++i2) {
                if ((this.controlAlignments[i2] & 0x40) != 0 || this.controls[i2].isDisposed() || !this.controls[i2].getVisible()) continue;
                int n3 = this.controls[i2].computeSize((int)-1, (int)-1).y;
                this.tabHeight = Math.max(n3 += this.renderer.computeTrim((int)-2, (int)0, (int)0, (int)0, (int)0, (int)0).height + 1, this.tabHeight);
            }
        }
        if (!bl2 && this.tabHeight == n2) {
            return false;
        }
        this.oldSize = null;
        return true;
    }

    void updateFolder(int n2) {
        this.updateFlags |= n2;
        if (this.updateRun != null) {
            return;
        }
        this.updateRun = () -> {
            this.updateRun = null;
            if (this.isDisposed()) {
                return;
            }
            this.runUpdate();
        };
        this.getDisplay().asyncExec(this.updateRun);
    }

    void runUpdate() {
        if (this.updateFlags == 0) {
            return;
        }
        int n2 = this.updateFlags;
        this.updateFlags = 0;
        Rectangle rectangle = this.getClientArea();
        this.updateTabHeight(false);
        this.updateItems(this.selectedIndex);
        if ((n2 & 2) != 0) {
            this.redraw();
        } else if ((n2 & 4) != 0) {
            this.redrawTabs();
        }
        Rectangle rectangle2 = this.getClientArea();
        if (!rectangle.equals(rectangle2)) {
            this.notifyListeners(11, new Event());
            this.layout();
        }
    }

    void updateBkImages() {
        if (this.controls != null && this.controls.length > 0) {
            for (int i2 = 0; i2 < this.controls.length; ++i2) {
                boolean bl2;
                Control control = this.controls[i2];
                if (control.isDisposed()) continue;
                if (this.hovering) {
                    if (control instanceof Composite) {
                        ((Composite)control).setBackgroundMode(0);
                    }
                    control.setBackgroundImage(null);
                    control.setBackground(this.getBackground());
                    continue;
                }
                if (control instanceof Composite) {
                    ((Composite)control).setBackgroundMode(1);
                }
                Rectangle rectangle = control.getBounds();
                int n2 = this.getTabHeight();
                int n3 = this.getSize().y;
                boolean bl3 = this.onBottom ? rectangle.y + rectangle.height < n3 - n2 : (bl2 = rectangle.y > n2);
                if (bl2 || this.gradientColors == null) {
                    control.setBackgroundImage(null);
                    control.setBackground(this.getBackground());
                    continue;
                }
                rectangle.width = 10;
                if (!this.onBottom) {
                    rectangle.y = -rectangle.y;
                    rectangle.height -= 2 * rectangle.y - 1;
                } else {
                    rectangle.height += n3 - (rectangle.y + rectangle.height);
                    rectangle.y = -1;
                }
                rectangle.x = 0;
                if (this.controlBkImages[i2] != null) {
                    this.controlBkImages[i2].dispose();
                }
                this.controlBkImages[i2] = new Image((Device)control.getDisplay(), rectangle);
                GC gC = new GC(this.controlBkImages[i2]);
                this.renderer.draw(-4, 0, rectangle, gC);
                gC.dispose();
                control.setBackground(null);
                control.setBackgroundImage(this.controlBkImages[i2]);
            }
        }
    }

    String _getToolTip(int n2, int n3) {
        CTabItem cTabItem = this.getItem(new Point(n2, n3));
        if (cTabItem == null) {
            return null;
        }
        if (!cTabItem.showing) {
            return null;
        }
        if ((this.showClose || cTabItem.showClose) && cTabItem.closeRect.contains(n2, n3)) {
            return SWT.getMessage("SWT_Close");
        }
        return cTabItem.getToolTipText();
    }

    void addTabControl(Control control, int n2) {
        this.checkWidget();
        this.addTabControl(control, n2, -1, true);
    }

    void addTabControl(Control control, int n2, int n3, boolean bl2) {
        int n4;
        switch (n2) {
            case 16384: 
            case 131072: 
            case 131076: 
            case 131136: 
            case 131140: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        for (n4 = 0; n4 < this.controls.length; ++n4) {
            if (this.controls[n4] != control) continue;
            SWT.error(5);
        }
        n4 = this.controls.length;
        control.addListener(11, this.listener);
        Control[] controlArray = new Control[n4 + 1];
        System.arraycopy(this.controls, 0, controlArray, 0, n4);
        this.controls = controlArray;
        int[] nArray = new int[n4 + 1];
        System.arraycopy(this.controlAlignments, 0, nArray, 0, n4);
        this.controlAlignments = nArray;
        Rectangle[] rectangleArray = new Rectangle[n4 + 1];
        System.arraycopy(this.controlRects, 0, rectangleArray, 0, n4);
        this.controlRects = rectangleArray;
        Image[] imageArray = new Image[n4 + 1];
        System.arraycopy(this.controlBkImages, 0, imageArray, 0, n4);
        this.controlBkImages = imageArray;
        if (n3 == -1) {
            n3 = n4;
            if (this.chevronTb != null && control != this.chevronTb) {
                --n3;
            }
        }
        System.arraycopy(this.controls, n3, this.controls, n3 + 1, n4 - n3);
        System.arraycopy(this.controlAlignments, n3, this.controlAlignments, n3 + 1, n4 - n3);
        System.arraycopy(this.controlRects, n3, this.controlRects, n3 + 1, n4 - n3);
        System.arraycopy(this.controlBkImages, n3, this.controlBkImages, n3 + 1, n4 - n3);
        this.controls[n3] = control;
        this.controlAlignments[n3] = n2;
        this.controlRects[n3] = new Rectangle(0, 0, 0, 0);
        if (bl2) {
            this.updateFolder(10);
        }
    }

    void removeTabControl(Control control) {
        this.checkWidget();
        this.removeTabControl(control, true);
    }

    void removeTabControl(Control control, boolean bl2) {
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        int n2 = -1;
        for (int i2 = 0; i2 < this.controls.length; ++i2) {
            if (this.controls[i2] != control) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            return;
        }
        if (!control.isDisposed()) {
            control.removeListener(11, this.listener);
            control.setBackground(null);
            control.setBackgroundImage(null);
            if (control instanceof Composite) {
                ((Composite)control).setBackgroundMode(0);
            }
        }
        if (this.controlBkImages[n2] != null && !this.controlBkImages[n2].isDisposed()) {
            this.controlBkImages[n2].dispose();
        }
        if (this.controls.length == 1) {
            this.controls = new Control[0];
            this.controlAlignments = new int[0];
            this.controlRects = new Rectangle[0];
            this.controlBkImages = new Image[0];
        } else {
            Control[] controlArray = new Control[this.controls.length - 1];
            System.arraycopy(this.controls, 0, controlArray, 0, n2);
            System.arraycopy(this.controls, n2 + 1, controlArray, n2, this.controls.length - n2 - 1);
            this.controls = controlArray;
            int[] nArray = new int[this.controls.length];
            System.arraycopy(this.controlAlignments, 0, nArray, 0, n2);
            System.arraycopy(this.controlAlignments, n2 + 1, nArray, n2, this.controls.length - n2);
            this.controlAlignments = nArray;
            Rectangle[] rectangleArray = new Rectangle[this.controls.length];
            System.arraycopy(this.controlRects, 0, rectangleArray, 0, n2);
            System.arraycopy(this.controlRects, n2 + 1, rectangleArray, n2, this.controls.length - n2);
            this.controlRects = rectangleArray;
            Image[] imageArray = new Image[this.controls.length];
            System.arraycopy(this.controlBkImages, 0, imageArray, 0, n2);
            System.arraycopy(this.controlBkImages, n2 + 1, imageArray, n2, this.controls.length - n2);
            this.controlBkImages = imageArray;
        }
        if (bl2) {
            this.updateFolder(10);
        }
    }

    int getWrappedHeight(Point point) {
        boolean[][] blArrayArray = new boolean[1][];
        Rectangle[] rectangleArray = this.computeControlBounds(point, blArrayArray);
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            if (!blArrayArray[0][i2]) continue;
            n2 = Math.min(n2, rectangleArray[i2].y);
            n3 = Math.max(n3, rectangleArray[i2].y + rectangleArray[i2].height);
            n4 = n3 - n2;
        }
        return n4;
    }

    void setChevronVisible(boolean bl2) {
        this.checkWidget();
        if (this.chevronVisible == bl2) {
            return;
        }
        this.chevronVisible = bl2;
        this.updateFolder(10);
    }

    boolean shouldHighlight() {
        return this.highlight && this.highlightEnabled;
    }

    public void setHighlightEnabled(boolean bl2) {
        this.checkWidget();
        if (this.highlightEnabled == bl2) {
            return;
        }
        this.highlightEnabled = bl2;
        this.updateFolder(2);
    }

    public boolean getHighlightEnabled() {
        this.checkWidget();
        return this.highlightEnabled;
    }
}

