/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.DPIUtil$AutoScaleImageDataProvider;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHDRAGIMAGE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public TableDragSourceEffect(Table table) {
        super(table);
    }

    @Override
    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    @Override
    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.image = this.getDragSourceImage(dragSourceEvent);
    }

    Image getDragSourceImage(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            SHDRAGIMAGE sHDRAGIMAGE = new SHDRAGIMAGE();
            int n2 = OS.RegisterWindowMessage(new TCHAR(0, "ShellGetDragImage", true));
            if (OS.SendMessage(this.control.handle, n2, 0, sHDRAGIMAGE) != 0) {
                dragSourceEvent.offsetX = (this.control.getStyle() & 0x8000000) != 0 ? sHDRAGIMAGE.sizeDragImage.cx - sHDRAGIMAGE.ptOffset.x : sHDRAGIMAGE.ptOffset.x;
                dragSourceEvent.offsetY = sHDRAGIMAGE.ptOffset.y;
                int n3 = sHDRAGIMAGE.hbmpDragImage;
                if (n3 != 0) {
                    Object object;
                    BITMAP bITMAP = new BITMAP();
                    OS.GetObject(n3, BITMAP.sizeof, bITMAP);
                    int n4 = bITMAP.bmWidth;
                    int n5 = bITMAP.bmHeight;
                    int n6 = OS.GetDC(0);
                    int n7 = OS.CreateCompatibleDC(n6);
                    int n8 = OS.SelectObject(n7, n3);
                    int n9 = OS.CreateCompatibleDC(n6);
                    BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
                    bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
                    bITMAPINFOHEADER.biWidth = n4;
                    bITMAPINFOHEADER.biHeight = -n5;
                    bITMAPINFOHEADER.biPlanes = 1;
                    bITMAPINFOHEADER.biBitCount = (short)32;
                    bITMAPINFOHEADER.biCompression = 0;
                    byte[] byArray = new byte[BITMAPINFOHEADER.sizeof];
                    OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
                    int[] nArray = new int[1];
                    int n10 = OS.CreateDIBSection(0, byArray, 0, nArray, 0, 0);
                    if (n10 == 0) {
                        SWT.error(2);
                    }
                    int n11 = OS.SelectObject(n9, n10);
                    BITMAP bITMAP2 = new BITMAP();
                    OS.GetObject(n10, BITMAP.sizeof, bITMAP2);
                    int n12 = bITMAP2.bmWidthBytes * bITMAP2.bmHeight;
                    OS.BitBlt(n9, 0, 0, n4, n5, n7, 0, 0, 0xCC0020);
                    byte[] byArray2 = new byte[n12];
                    OS.MoveMemory(byArray2, bITMAP2.bmBits, n12);
                    PaletteData paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                    ImageData imageData = new ImageData(n4, n5, bITMAP.bmBitsPixel, paletteData, bITMAP.bmWidthBytes, byArray2);
                    if (sHDRAGIMAGE.crColorKey == -1) {
                        object = new byte[n4 * n5];
                        int n13 = bITMAP2.bmWidthBytes - n4 * 4;
                        int n14 = 0;
                        int n15 = 3;
                        for (int i2 = 0; i2 < n5; ++i2) {
                            for (int i3 = 0; i3 < n4; ++i3) {
                                object[n14++] = byArray2[n15];
                                n15 += 4;
                            }
                            n15 += n13;
                        }
                        imageData.alphaData = object;
                    } else {
                        imageData.transparentPixel = sHDRAGIMAGE.crColorKey << 8;
                    }
                    object = this.control.getDisplay();
                    this.dragSourceImage = new Image((Device)object, new DPIUtil$AutoScaleImageDataProvider((Device)object, imageData, DPIUtil.getDeviceZoom()));
                    OS.SelectObject(n9, n11);
                    OS.DeleteDC(n9);
                    OS.DeleteObject(n10);
                    OS.SelectObject(n7, n8);
                    OS.DeleteDC(n7);
                    OS.ReleaseDC(0, n6);
                    OS.DeleteObject(n3);
                    return this.dragSourceImage;
                }
            }
            return null;
        }
        Table table = (Table)this.control;
        if (table.isListening(40) || table.isListening(42)) {
            return null;
        }
        TableItem[] tableItemArray = table.getSelection();
        if (tableItemArray.length == 0) {
            return null;
        }
        int n16 = OS.SendMessage(table.handle, 4098, 1, 0);
        if (n16 != 0) {
            int n17;
            int n18 = Math.min(tableItemArray.length, 10);
            Rectangle rectangle = DPIUtil.autoScaleUp(tableItemArray[0].getBounds(0));
            for (n17 = 1; n17 < n18; ++n17) {
                rectangle = rectangle.union(DPIUtil.autoScaleUp(tableItemArray[n17].getBounds(0)));
            }
            n17 = OS.GetDC(0);
            int n19 = OS.CreateCompatibleDC(n17);
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && (table.getStyle() & 0x4000000) != 0) {
                OS.SetLayout(n19, 9);
            }
            int n20 = OS.CreateCompatibleBitmap(n17, rectangle.width, rectangle.height);
            int n21 = OS.SelectObject(n19, n20);
            RECT rECT = new RECT();
            rECT.right = rectangle.width;
            rECT.bottom = rectangle.height;
            int n22 = OS.GetStockObject(0);
            OS.FillRect(n19, rECT, n22);
            for (int i4 = 0; i4 < n18; ++i4) {
                TableItem tableItem = tableItemArray[i4];
                Rectangle rectangle2 = DPIUtil.autoScaleUp(tableItem.getBounds(0));
                POINT pOINT = new POINT();
                int n23 = OS.SendMessage(table.handle, 4129, table.indexOf(tableItem), pOINT);
                OS.ImageList_Draw(n23, 0, n19, rectangle2.x - rectangle.x, rectangle2.y - rectangle.y, 4);
                OS.ImageList_Destroy(n23);
            }
            OS.SelectObject(n19, n21);
            OS.DeleteDC(n19);
            OS.ReleaseDC(0, n17);
            Display display = table.getDisplay();
            this.dragSourceImage = Image.win32_new(display, 0, n20);
            return this.dragSourceImage;
        }
        return null;
    }
}

