/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.OS;

public final class Cursor
extends Resource {
    public int handle;
    boolean isIcon;
    static final byte[] HAND_SOURCE = new byte[]{-7, -1, -1, -1, -16, -1, -1, -1, -16, -1, -1, -1, -16, -1, -1, -1, -16, 63, -1, -1, -16, 7, -1, -1, -16, 3, -1, -1, -16, 0, -1, -1, 16, 0, 127, -1, 0, 0, 127, -1, -128, 0, 127, -1, -64, 0, 127, -1, -32, 0, 127, -1, -16, 0, 127, -1, -8, 0, -1, -1, -4, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    static final byte[] HAND_MASK = new byte[]{0, 0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6, -64, 0, 0, 6, -40, 0, 0, 6, -40, 0, 0, 7, -37, 0, 0, 103, -5, 0, 0, 63, -1, 0, 0, 31, -1, 0, 0, 15, -1, 0, 0, 7, -1, 0, 0, 3, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    Cursor(Device device) {
        super(device);
    }

    public Cursor(Device device, int n2) {
        super(device);
        int n3 = 0;
        switch (n2) {
            case 21: {
                n3 = 32649;
                break;
            }
            case 0: {
                n3 = 32512;
                break;
            }
            case 1: {
                n3 = 32514;
                break;
            }
            case 2: {
                n3 = 32515;
                break;
            }
            case 3: {
                n3 = 32650;
                break;
            }
            case 4: {
                n3 = 32651;
                break;
            }
            case 5: {
                n3 = 32646;
                break;
            }
            case 6: {
                n3 = 32643;
                break;
            }
            case 7: {
                n3 = 32645;
                break;
            }
            case 8: {
                n3 = 32642;
                break;
            }
            case 9: {
                n3 = 32644;
                break;
            }
            case 10: {
                n3 = 32645;
                break;
            }
            case 11: {
                n3 = 32645;
                break;
            }
            case 12: {
                n3 = 32644;
                break;
            }
            case 13: {
                n3 = 32644;
                break;
            }
            case 14: {
                n3 = 32643;
                break;
            }
            case 15: {
                n3 = 32642;
                break;
            }
            case 16: {
                n3 = 32643;
                break;
            }
            case 17: {
                n3 = 32642;
                break;
            }
            case 18: {
                n3 = 32516;
                break;
            }
            case 19: {
                n3 = 32513;
                break;
            }
            case 20: {
                n3 = 32648;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.handle = OS.LoadCursor(0, n3);
        if (this.handle == 0 && n2 == 21) {
            int n4 = OS.GetSystemMetrics(13);
            int n5 = OS.GetSystemMetrics(14);
            if (n4 == 32 && n5 == 32) {
                int n6 = OS.GetModuleHandle(null);
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                this.handle = OS.CreateCursor(n6, 5, 0, 32, 32, HAND_SOURCE, HAND_MASK);
            }
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData imageData, ImageData imageData2, int n2, int n3) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            if (imageData.getTransparencyType() != 2) {
                SWT.error(4);
            }
            imageData2 = imageData.getTransparencyMask();
        }
        if (imageData2.width != imageData.width || imageData2.height != imageData.height) {
            SWT.error(5);
        }
        if (n2 >= imageData.width || n2 < 0 || n3 >= imageData.height || n3 < 0) {
            SWT.error(5);
        }
        imageData2 = ImageData.convertMask(imageData2);
        imageData = ImageData.convertMask(imageData);
        byte[] byArray = ImageData.convertPad(imageData.data, imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, 2);
        byte[] byArray2 = ImageData.convertPad(imageData2.data, imageData2.width, imageData2.height, imageData2.depth, imageData2.scanlinePad, 2);
        int n4 = OS.GetModuleHandle(null);
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        this.handle = OS.CreateCursor(n4, n2, n3, imageData.width, imageData.height, byArray, byArray2);
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData imageData, int n2, int n3) {
        super(device);
        Object object;
        if (imageData == null) {
            SWT.error(4);
        }
        if (n2 >= imageData.width || n2 < 0 || n3 >= imageData.height || n3 < 0) {
            SWT.error(5);
        }
        int n4 = 0;
        int n5 = 0;
        if (imageData.maskData == null && imageData.transparentPixel == -1 && (imageData.alpha != -1 || imageData.alphaData != null)) {
            Object object2;
            object = imageData.palette;
            PaletteData paletteData = new PaletteData(65280, 0xFF0000, -16777216);
            ImageData imageData2 = new ImageData(imageData.width, imageData.height, 32, paletteData);
            if (((PaletteData)object).isDirect) {
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, ((PaletteData)object).redMask, ((PaletteData)object).greenMask, ((PaletteData)object).blueMask, 255, null, 0, 0, 0, imageData2.data, imageData2.depth, imageData2.bytesPerLine, imageData2.getByteOrder(), 0, 0, imageData2.width, imageData2.height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, false, false);
            } else {
                object2 = ((PaletteData)object).getRGBs();
                int n6 = ((RGB[])object2).length;
                byte[] byArray = new byte[n6];
                byte[] byArray2 = new byte[n6];
                byte[] byArray3 = new byte[n6];
                for (int i2 = 0; i2 < ((RGB[])object2).length; ++i2) {
                    RGB rGB = object2[i2];
                    if (rGB == null) continue;
                    byArray[i2] = (byte)rGB.red;
                    byArray2[i2] = (byte)rGB.green;
                    byArray3[i2] = (byte)rGB.blue;
                }
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, byArray, byArray2, byArray3, 255, null, 0, 0, 0, imageData2.data, imageData2.depth, imageData2.bytesPerLine, imageData2.getByteOrder(), 0, 0, imageData2.width, imageData2.height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, false, false);
            }
            n4 = Image.createDIB(imageData.width, imageData.height, 32);
            if (n4 == 0) {
                SWT.error(2);
            }
            object2 = new BITMAP();
            OS.GetObject(n4, BITMAP.sizeof, (BITMAP)object2);
            byte[] byArray = imageData2.data;
            if (imageData.alpha != -1) {
                for (int i3 = 3; i3 < byArray.length; i3 += 4) {
                    byArray[i3] = (byte)imageData.alpha;
                }
            } else if (imageData.alphaData != null) {
                int n7 = 3;
                int n8 = 0;
                while (n7 < byArray.length) {
                    byArray[n7] = imageData.alphaData[n8];
                    n7 += 4;
                    ++n8;
                }
            }
            OS.MoveMemory(object2.bmBits, byArray, byArray.length);
            n5 = OS.CreateBitmap(imageData.width, imageData.height, 1, 1, new byte[((imageData.width + 7) / 8 + 3) / 4 * 4 * imageData.height]);
            if (n5 == 0) {
                SWT.error(2);
            }
        } else {
            object = imageData.getTransparencyMask();
            int[] nArray = Image.init(this.device, null, imageData, (ImageData)object);
            n4 = nArray[0];
            n5 = nArray[1];
        }
        object = new ICONINFO();
        ((ICONINFO)object).fIcon = false;
        ((ICONINFO)object).hbmColor = n4;
        ((ICONINFO)object).hbmMask = n5;
        ((ICONINFO)object).xHotspot = n2;
        ((ICONINFO)object).yHotspot = n3;
        this.handle = OS.CreateIconIndirect((ICONINFO)object);
        OS.DeleteObject(n4);
        OS.DeleteObject(n5);
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.isIcon = true;
        this.init();
    }

    @Override
    void destroy() {
        if (this.isIcon) {
            OS.DestroyIcon(this.handle);
        } else if (!OS.IsWinCE) {
            OS.DestroyCursor(this.handle);
        }
        this.handle = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public int hashCode() {
        return this.handle;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }

    public static Cursor win32_new(Device device, int n2) {
        Cursor cursor = new Cursor(device);
        cursor.handle = n2;
        return cursor;
    }
}

