/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import java.util.ArrayList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IOleInPlaceActiveObject;
import org.eclipse.swt.internal.win32.GUITHREADINFO;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame$1;
import org.eclipse.swt.ole.win32.OleFrame$2;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class OleFrame
extends Composite {
    private COMObject iUnknown;
    private COMObject iOleInPlaceFrame;
    private IOleInPlaceActiveObject objIOleInPlaceActiveObject;
    private OleClientSite currentdoc;
    private int refCount = 0;
    private MenuItem[] fileMenuItems;
    private MenuItem[] containerMenuItems;
    private MenuItem[] windowMenuItems;
    private Listener listener;
    private int shellHandle;
    private int oldMenuHandle;
    private int newMenuHandle;
    private static int lastActivatedMenuHandle;
    private static String CHECK_FOCUS;
    private static String HHOOK;
    private static String HHOOKMSG;
    private static boolean ignoreNextKey;
    private static final short[] ACCENTS;
    private static final String CONSUME_KEY = "org.eclipse.swt.OleFrame.ConsumeKey";
    private static final String ACCEL_KEY_HIT = "org.eclipse.swt.internal.win32.accelKeyHit";

    public OleFrame(Composite composite, int n2) {
        super(composite, n2);
        this.createCOMInterfaces();
        this.listener = event -> {
            switch (event.type) {
                case 26: {
                    this.onActivate(event);
                    break;
                }
                case 27: {
                    this.onDeactivate(event);
                    break;
                }
                case 12: {
                    this.onDispose(event);
                    break;
                }
                case 10: 
                case 11: {
                    this.onResize(event);
                    break;
                }
                default: {
                    OLE.error(20);
                }
            }
        };
        this.addListener(26, this.listener);
        this.addListener(27, this.listener);
        this.addListener(12, this.listener);
        this.addListener(11, this.listener);
        this.addListener(10, this.listener);
        this.AddRef();
        Display display = this.getDisplay();
        OleFrame.initCheckFocus(display);
        OleFrame.initMsgHook(display);
    }

    private static void initCheckFocus(Display display) {
        if (display.getData(CHECK_FOCUS) != null) {
            return;
        }
        display.setData(CHECK_FOCUS, CHECK_FOCUS);
        Runnable[] runnableArray = new Runnable[1];
        Control[] controlArray = new Control[1];
        runnableArray[0] = () -> {
            if (controlArray[0] instanceof OleClientSite && !controlArray[0].isDisposed()) {
                int n2 = OS.GetFocus();
                while (n2 != 0) {
                    int n3 = OS.GetWindow(n2, 4);
                    if (n3 != 0) {
                        display.timerExec(50, runnableArray[0]);
                        return;
                    }
                    n2 = OS.GetParent(n2);
                }
            }
            if (controlArray[0] == null || controlArray[0].isDisposed() || !controlArray[0].isFocusControl()) {
                Control control = display.getFocusControl();
                if (control instanceof OleFrame) {
                    OleFrame oleFrame = (OleFrame)control;
                    control = oleFrame.getCurrentDocument();
                }
                if (controlArray[0] != control) {
                    Event event = new Event();
                    if (controlArray[0] instanceof OleClientSite && !controlArray[0].isDisposed()) {
                        controlArray[0].notifyListeners(16, event);
                    }
                    if (control instanceof OleClientSite && !control.isDisposed()) {
                        control.notifyListeners(15, event);
                    }
                }
                controlArray[0] = control;
            }
            display.timerExec(50, runnableArray[0]);
        };
        display.timerExec(50, runnableArray[0]);
    }

    private static void initMsgHook(Display display) {
        int n2;
        int n3;
        if (display.getData(HHOOK) != null) {
            return;
        }
        Callback callback = new Callback(OleFrame.class, "getMsgProc", 3);
        int n4 = callback.getAddress();
        if (n4 == 0) {
            SWT.error(3);
        }
        if ((n3 = OS.SetWindowsHookEx(3, n4, 0, n2 = OS.GetCurrentThreadId())) == 0) {
            callback.dispose();
            return;
        }
        display.setData(HHOOK, new LONG(n3));
        display.setData(HHOOKMSG, new MSG());
        display.disposeExec(() -> {
            if (n3 != 0) {
                OS.UnhookWindowsHookEx(n3);
            }
            if (callback != null) {
                callback.dispose();
            }
        });
    }

    static int getMsgProc(int n2, int n3, int n4) {
        Display display = Display.getCurrent();
        if (display == null) {
            return 0;
        }
        LONG lONG = (LONG)display.getData(HHOOK);
        if (lONG == null) {
            return 0;
        }
        if (n2 < 0 || (n3 & 1) == 0) {
            return OS.CallNextHookEx(lONG.value, n2, n3, n4);
        }
        MSG mSG = (MSG)display.getData(HHOOKMSG);
        OS.MoveMemory(mSG, n4, MSG.sizeof);
        int n5 = mSG.message;
        if (256 <= n5 && n5 <= 264 && display != null) {
            Widget widget = null;
            int n6 = mSG.hwnd;
            while (n6 != 0 && (widget = display.findWidget(n6)) == null) {
                n6 = OS.GetParent(n6);
            }
            if (widget != null && widget instanceof OleClientSite) {
                OleClientSite oleClientSite = (OleClientSite)widget;
                if (oleClientSite.handle == n6) {
                    boolean bl2 = false;
                    int n7 = OS.GetWindowThreadProcessId(mSG.hwnd, null);
                    GUITHREADINFO gUITHREADINFO = new GUITHREADINFO();
                    gUITHREADINFO.cbSize = GUITHREADINFO.sizeof;
                    boolean bl3 = OS.GetGUIThreadInfo(n7, gUITHREADINFO);
                    int n8 = 30;
                    if (!bl3 || (gUITHREADINFO.flags & n8) == 0) {
                        OleFrame oleFrame = oleClientSite.frame;
                        oleFrame.setData(CONSUME_KEY, null);
                        display.setData(ACCEL_KEY_HIT, Boolean.TRUE);
                        bl2 = oleFrame.translateOleAccelerator(mSG);
                        if (display.isDisposed()) {
                            return 0;
                        }
                        display.setData(ACCEL_KEY_HIT, Boolean.FALSE);
                        if (oleFrame.isDisposed()) {
                            return 0;
                        }
                        String string = (String)oleFrame.getData(CONSUME_KEY);
                        if (string != null) {
                            bl2 = string.equals("true");
                        }
                        oleFrame.setData(CONSUME_KEY, null);
                    }
                    boolean bl4 = false;
                    block0 : switch (mSG.message) {
                        case 256: 
                        case 260: {
                            if (OS.IsWinCE) break;
                            switch (mSG.wParam) {
                                case 16: 
                                case 17: 
                                case 18: 
                                case 20: 
                                case 144: 
                                case 145: {
                                    break block0;
                                }
                            }
                            int n9 = OS.MapVirtualKey(mSG.wParam, 2);
                            if (n9 == 0) break;
                            boolean bl5 = bl4 = (n9 & (OS.IsWinNT ? Integer.MIN_VALUE : 32768)) != 0;
                            if (bl4) break;
                            for (int i2 = 0; i2 < ACCENTS.length; ++i2) {
                                short s2 = OS.VkKeyScan(ACCENTS[i2]);
                                if (s2 == -1 || (s2 & 0xFF) != mSG.wParam) continue;
                                int n10 = s2 >> 8;
                                if (OS.GetKeyState(16) < 0 != ((n10 & 1) != 0) || OS.GetKeyState(17) < 0 != ((n10 & 2) != 0) || OS.GetKeyState(18) < 0 != ((n10 & 4) != 0)) continue;
                                if ((n10 & 7) == 0) break block0;
                                bl4 = true;
                                break block0;
                            }
                            break;
                        }
                    }
                    if (!(bl2 || bl4 || ignoreNextKey)) {
                        int n11 = mSG.hwnd;
                        mSG.hwnd = oleClientSite.handle;
                        bl2 = OS.DispatchMessage(mSG) == 1;
                        mSG.hwnd = n11;
                    }
                    block6 : switch (mSG.message) {
                        case 256: 
                        case 260: {
                            switch (mSG.wParam) {
                                case 16: 
                                case 17: 
                                case 18: 
                                case 20: 
                                case 144: 
                                case 145: {
                                    break block6;
                                }
                            }
                            ignoreNextKey = bl4;
                        }
                    }
                    if (bl2) {
                        mSG.message = 0;
                        mSG.lParam = 0;
                        mSG.wParam = 0;
                        OS.MoveMemory(n4, mSG, MSG.sizeof);
                        return 0;
                    }
                }
            }
        }
        return OS.CallNextHookEx(lONG.value, n2, n3, n4);
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private int ContextSensitiveHelp(int n2) {
        return 0;
    }

    private void createCOMInterfaces() {
        this.iUnknown = new OleFrame$1(this, new int[]{2, 0, 0});
        this.iOleInPlaceFrame = new OleFrame$2(this, new int[]{2, 0, 0, 1, 1, 1, 1, 1, 2, 2, 3, 1, 1, 1, 2});
    }

    private void disposeCOMInterfaces() {
        if (this.iUnknown != null) {
            this.iUnknown.dispose();
        }
        this.iUnknown = null;
        if (this.iOleInPlaceFrame != null) {
            this.iOleInPlaceFrame.dispose();
        }
        this.iOleInPlaceFrame = null;
    }

    private int GetBorder(int n2) {
        if (n2 == 0) {
            return -2147024809;
        }
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        OS.MoveMemory(n2, rECT, RECT.sizeof);
        return 0;
    }

    public MenuItem[] getContainerMenus() {
        return this.containerMenuItems;
    }

    public MenuItem[] getFileMenus() {
        return this.fileMenuItems;
    }

    int getIOleInPlaceFrame() {
        return this.iOleInPlaceFrame.getAddress();
    }

    private int getMenuItemID(int n2, int n3) {
        int n4 = 0;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 7;
        OS.GetMenuItemInfo(n2, n3, true, mENUITEMINFO);
        n4 = (mENUITEMINFO.fState & 0x10) == 16 ? mENUITEMINFO.hSubMenu : mENUITEMINFO.wID;
        return n4;
    }

    private int GetWindow(int n2) {
        if (n2 != 0) {
            COM.MoveMemory(n2, new int[]{this.handle}, OS.PTR_SIZEOF);
        }
        return 0;
    }

    public MenuItem[] getWindowMenus() {
        return this.windowMenuItems;
    }

    private int InsertMenus(int n2, int n3) {
        int n4;
        Menu menu = this.getShell().getMenuBar();
        if (menu == null || menu.isDisposed()) {
            COM.MoveMemory(n3, new int[]{0}, 4);
            return 0;
        }
        int n5 = menu.handle;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        int n6 = OS.GetProcessHeap();
        int n7 = 128;
        int n8 = n7 * TCHAR.sizeof;
        int n9 = OS.HeapAlloc(n6, 8, n8);
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 55;
        mENUITEMINFO.dwTypeData = n9;
        mENUITEMINFO.cch = n7;
        int n10 = 0;
        int n11 = 0;
        if (this.fileMenuItems != null) {
            for (n4 = 0; n4 < this.fileMenuItems.length; ++n4) {
                MenuItem menuItem = this.fileMenuItems[n4];
                if (menuItem == null) continue;
                int n12 = menuItem.getParent().indexOf(menuItem);
                mENUITEMINFO.cch = n7;
                if (!OS.GetMenuItemInfo(n5, n12, true, mENUITEMINFO) || !OS.InsertMenuItem(n2, n11, true, mENUITEMINFO)) continue;
                ++n10;
                ++n11;
            }
        }
        COM.MoveMemory(n3, new int[]{n10}, 4);
        n4 = 0;
        if (this.containerMenuItems != null) {
            for (int i2 = 0; i2 < this.containerMenuItems.length; ++i2) {
                MenuItem menuItem = this.containerMenuItems[i2];
                if (menuItem == null) continue;
                int n13 = menuItem.getParent().indexOf(menuItem);
                mENUITEMINFO.cch = n7;
                if (!OS.GetMenuItemInfo(n5, n13, true, mENUITEMINFO) || !OS.InsertMenuItem(n2, n11, true, mENUITEMINFO)) continue;
                ++n4;
                ++n11;
            }
        }
        COM.MoveMemory(n3 + 8, new int[]{n4}, 4);
        int n14 = 0;
        if (this.windowMenuItems != null) {
            for (int i3 = 0; i3 < this.windowMenuItems.length; ++i3) {
                MenuItem menuItem = this.windowMenuItems[i3];
                if (menuItem == null) continue;
                int n15 = menuItem.getParent().indexOf(menuItem);
                mENUITEMINFO.cch = n7;
                if (!OS.GetMenuItemInfo(n5, n15, true, mENUITEMINFO) || !OS.InsertMenuItem(n2, n11, true, mENUITEMINFO)) continue;
                ++n14;
                ++n11;
            }
        }
        COM.MoveMemory(n3 + 16, new int[]{n14}, 4);
        if (n9 != 0) {
            OS.HeapFree(n6, 0, n9);
        }
        return 0;
    }

    void onActivate(Event event) {
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.OnFrameWindowActivate(true);
        }
    }

    void onDeactivate(Event event) {
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.OnFrameWindowActivate(false);
        }
    }

    private void onDispose(Event event) {
        this.releaseObjectInterfaces();
        this.currentdoc = null;
        this.Release();
        this.removeListener(26, this.listener);
        this.removeListener(27, this.listener);
        this.removeListener(12, this.listener);
        this.removeListener(11, this.listener);
        this.removeListener(10, this.listener);
    }

    void onFocusIn(Event event) {
        if (lastActivatedMenuHandle != this.newMenuHandle) {
            this.currentdoc.doVerb(-1);
        }
        if (OS.GetMenu(this.shellHandle) != this.newMenuHandle) {
            OS.SetMenu(this.shellHandle, this.newMenuHandle);
        }
    }

    void onFocusOut(Event event) {
        Control control = this.getDisplay().getFocusControl();
        if (OS.GetMenu(this.shellHandle) != this.oldMenuHandle && control != null && control.handle != this.shellHandle) {
            OS.SetMenu(this.shellHandle, this.oldMenuHandle);
        }
    }

    private void onResize(Event event) {
        if (this.objIOleInPlaceActiveObject != null) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            this.objIOleInPlaceActiveObject.ResizeBorder(rECT, this.iOleInPlaceFrame.getAddress(), true);
        }
    }

    private int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n2, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIOleInPlaceFrame)) {
            COM.MoveMemory(n3, new int[]{this.iOleInPlaceFrame.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory(n3, new int[]{0}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
            if (COM.FreeUnusedLibraries) {
                COM.CoFreeUnusedLibraries();
            }
        }
        return this.refCount;
    }

    private void releaseObjectInterfaces() {
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.Release();
        }
        this.objIOleInPlaceActiveObject = null;
    }

    private int RemoveMenus(int n2) {
        int n3;
        int n4;
        MenuItem menuItem;
        int n5;
        Menu menu = this.getShell().getMenuBar();
        if (menu == null || menu.isDisposed()) {
            return 1;
        }
        int n6 = menu.handle;
        ArrayList<LONG> arrayList = new ArrayList<LONG>();
        if (this.fileMenuItems != null) {
            for (n5 = 0; n5 < this.fileMenuItems.length; ++n5) {
                menuItem = this.fileMenuItems[n5];
                if (menuItem == null || menuItem.isDisposed()) continue;
                n4 = menuItem.getParent().indexOf(menuItem);
                n3 = this.getMenuItemID(n6, n4);
                arrayList.add(new LONG(n3));
            }
        }
        if (this.containerMenuItems != null) {
            for (n5 = 0; n5 < this.containerMenuItems.length; ++n5) {
                menuItem = this.containerMenuItems[n5];
                if (menuItem == null || menuItem.isDisposed()) continue;
                n4 = menuItem.getParent().indexOf(menuItem);
                n3 = this.getMenuItemID(n6, n4);
                arrayList.add(new LONG(n3));
            }
        }
        if (this.windowMenuItems != null) {
            for (n5 = 0; n5 < this.windowMenuItems.length; ++n5) {
                menuItem = this.windowMenuItems[n5];
                if (menuItem == null || menuItem.isDisposed()) continue;
                n4 = menuItem.getParent().indexOf(menuItem);
                n3 = this.getMenuItemID(n6, n4);
                arrayList.add(new LONG(n3));
            }
        }
        for (int i2 = n5 = OS.GetMenuItemCount(n2) - 1; i2 >= 0; --i2) {
            n4 = this.getMenuItemID(n2, i2);
            if (!arrayList.contains(new LONG(n4))) continue;
            OS.RemoveMenu(n2, i2, 1024);
        }
        return 0;
    }

    private int RequestBorderSpace(int n2) {
        return 0;
    }

    int SetActiveObject(int n2, int n3) {
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.Release();
            this.objIOleInPlaceActiveObject = null;
        }
        if (n2 != 0) {
            this.objIOleInPlaceActiveObject = new IOleInPlaceActiveObject(n2);
            this.objIOleInPlaceActiveObject.AddRef();
        }
        return 0;
    }

    private int SetBorderSpace(int n2) {
        if (this.objIOleInPlaceActiveObject == null) {
            return 0;
        }
        RECT rECT = new RECT();
        if (n2 == 0 || this.currentdoc == null) {
            return 0;
        }
        COM.MoveMemory(rECT, n2, RECT.sizeof);
        this.currentdoc.setBorderSpace(rECT);
        return 0;
    }

    public void setContainerMenus(MenuItem[] menuItemArray) {
        this.containerMenuItems = menuItemArray;
    }

    OleClientSite getCurrentDocument() {
        return this.currentdoc;
    }

    void setCurrentDocument(OleClientSite oleClientSite) {
        this.currentdoc = oleClientSite;
        if (this.currentdoc != null && this.objIOleInPlaceActiveObject != null) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            this.objIOleInPlaceActiveObject.ResizeBorder(rECT, this.iOleInPlaceFrame.getAddress(), true);
        }
    }

    public void setFileMenus(MenuItem[] menuItemArray) {
        this.fileMenuItems = menuItemArray;
    }

    private int SetMenu(int n2, int n3, int n4) {
        Menu menu;
        int n5 = 0;
        if (this.objIOleInPlaceActiveObject != null) {
            n5 = this.objIOleInPlaceActiveObject.getAddress();
        }
        if ((menu = this.getShell().getMenuBar()) == null || menu.isDisposed()) {
            return COM.OleSetMenuDescriptor(0, this.getShell().handle, n4, this.iOleInPlaceFrame.getAddress(), n5);
        }
        int n6 = menu.getShell().handle;
        if (n2 == 0 && n3 == 0) {
            n2 = menu.handle;
        }
        if (n2 == 0) {
            return -2147467259;
        }
        this.shellHandle = n6;
        this.oldMenuHandle = menu.handle;
        lastActivatedMenuHandle = this.newMenuHandle = n2;
        return COM.OleSetMenuDescriptor(n3, n6, n4, this.iOleInPlaceFrame.getAddress(), n5);
    }

    public void setWindowMenus(MenuItem[] menuItemArray) {
        this.windowMenuItems = menuItemArray;
    }

    private boolean translateOleAccelerator(MSG mSG) {
        if (this.objIOleInPlaceActiveObject == null) {
            return false;
        }
        int n2 = this.objIOleInPlaceActiveObject.TranslateAccelerator(mSG);
        return n2 != 1 && n2 != -2147467263;
    }

    private int TranslateAccelerator(int n2, int n3) {
        Menu menu = this.getShell().getMenuBar();
        if (menu == null || menu.isDisposed() || !menu.isEnabled()) {
            return 1;
        }
        if (n3 < 0) {
            return 1;
        }
        Shell shell = menu.getShell();
        int n4 = shell.handle;
        int n5 = OS.SendMessage(n4, 32769, 0, 0);
        if (n5 == 0) {
            return 1;
        }
        MSG mSG = new MSG();
        OS.MoveMemory(mSG, n2, MSG.sizeof);
        int n6 = OS.TranslateAccelerator(n4, n5, mSG);
        return n6 == 0 ? 1 : 0;
    }

    static /* synthetic */ int access$000(OleFrame oleFrame, int n2, int n3) {
        return oleFrame.QueryInterface(n2, n3);
    }

    static /* synthetic */ int access$100(OleFrame oleFrame, int n2) {
        return oleFrame.GetWindow(n2);
    }

    static /* synthetic */ int access$200(OleFrame oleFrame, int n2) {
        return oleFrame.ContextSensitiveHelp(n2);
    }

    static /* synthetic */ int access$300(OleFrame oleFrame, int n2) {
        return oleFrame.GetBorder(n2);
    }

    static /* synthetic */ int access$400(OleFrame oleFrame, int n2) {
        return oleFrame.RequestBorderSpace(n2);
    }

    static /* synthetic */ int access$500(OleFrame oleFrame, int n2) {
        return oleFrame.SetBorderSpace(n2);
    }

    static /* synthetic */ int access$600(OleFrame oleFrame, int n2, int n3) {
        return oleFrame.InsertMenus(n2, n3);
    }

    static /* synthetic */ int access$700(OleFrame oleFrame, int n2, int n3, int n4) {
        return oleFrame.SetMenu(n2, n3, n4);
    }

    static /* synthetic */ int access$800(OleFrame oleFrame, int n2) {
        return oleFrame.RemoveMenus(n2);
    }

    static /* synthetic */ int access$900(OleFrame oleFrame, int n2, int n3) {
        return oleFrame.TranslateAccelerator(n2, n3);
    }

    static {
        CHECK_FOCUS = "OLE_CHECK_FOCUS";
        HHOOK = "OLE_HHOOK";
        HHOOKMSG = "OLE_HHOOK_MSG";
        ACCENTS = new short[]{126, 96, 39, 94, 34};
    }
}

