/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.util.LinkedHashSet;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.win32.FILETIME;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PROCESS_INFORMATION;
import org.eclipse.swt.internal.win32.SHELLEXECUTEINFO;
import org.eclipse.swt.internal.win32.SHFILEINFO;
import org.eclipse.swt.internal.win32.SHFILEINFOA;
import org.eclipse.swt.internal.win32.SHFILEINFOW;
import org.eclipse.swt.internal.win32.STARTUPINFO;
import org.eclipse.swt.internal.win32.TCHAR;

public final class Program {
    String name;
    String command;
    String iconName;
    String extension;
    static final String[] ARGUMENTS = new String[]{"%1", "%l", "%L"};

    Program() {
    }

    static String assocQueryString(int n2, TCHAR tCHAR, boolean bl2) {
        int n3 = 1056;
        TCHAR tCHAR2 = new TCHAR(0, 1024);
        int[] nArray = new int[]{tCHAR2.length()};
        int n4 = OS.AssocQueryString(n3, n2, tCHAR, null, tCHAR2, nArray);
        if (n4 == -2147467261) {
            tCHAR2 = new TCHAR(0, nArray[0]);
            n4 = OS.AssocQueryString(n3, n2, tCHAR, null, tCHAR2, nArray);
        }
        if (n4 == 0) {
            if (!OS.IsWinCE && bl2) {
                int n5 = OS.ExpandEnvironmentStrings(tCHAR2, null, 0);
                if (n5 != 0) {
                    TCHAR tCHAR3 = new TCHAR(0, n5);
                    OS.ExpandEnvironmentStrings(tCHAR2, tCHAR3, n5);
                    return tCHAR3.toString(0, Math.max(0, n5 - 1));
                }
                return "";
            }
            return tCHAR2.toString(0, Math.max(0, nArray[0] - 1));
        }
        return null;
    }

    public static Program findProgram(String string) {
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) != '.') {
            string = "." + string;
        }
        TCHAR tCHAR = new TCHAR(0, string, true);
        Program program = null;
        if (OS.IsWinCE) {
            int[] nArray = new int[1];
            if (OS.RegOpenKeyEx(Integer.MIN_VALUE, tCHAR, 0, 131097, nArray) != 0) {
                return null;
            }
            int[] nArray2 = new int[1];
            int n2 = OS.RegQueryValueEx(nArray[0], null, 0, null, (TCHAR)null, nArray2);
            if (n2 == 0) {
                TCHAR tCHAR2;
                int n3 = nArray2[0] / TCHAR.sizeof;
                if (nArray2[0] % TCHAR.sizeof != 0) {
                    ++n3;
                }
                if ((n2 = OS.RegQueryValueEx(nArray[0], null, 0, null, tCHAR2 = new TCHAR(0, n3), nArray2)) == 0) {
                    program = Program.getProgram(tCHAR2.toString(0, tCHAR2.strlen()), string);
                }
            }
            OS.RegCloseKey(nArray[0]);
        } else {
            String string2 = Program.assocQueryString(1, tCHAR, true);
            if (string2 != null) {
                String string3;
                String string4 = null;
                if (string4 == null) {
                    string4 = Program.assocQueryString(3, tCHAR, false);
                }
                if (string4 == null) {
                    string4 = Program.assocQueryString(4, tCHAR, false);
                }
                if (string4 == null) {
                    string4 = "";
                }
                if ((string3 = Program.assocQueryString(15, tCHAR, true)) == null) {
                    string3 = "";
                }
                program = new Program();
                program.name = string4;
                program.command = string2;
                program.iconName = string3;
                program.extension = string;
            }
        }
        return program;
    }

    public static String[] getExtensions() {
        String[] stringArray;
        String[] stringArray2 = new String[1024];
        TCHAR tCHAR = new TCHAR(0, 1024);
        int[] nArray = new int[]{tCHAR.length()};
        FILETIME fILETIME = new FILETIME();
        int n2 = 0;
        int n3 = 0;
        while (OS.RegEnumKeyEx(Integer.MIN_VALUE, n2, tCHAR, nArray, null, null, null, fILETIME) != 259) {
            stringArray = tCHAR.toString(0, nArray[0]);
            nArray[0] = tCHAR.length();
            if (stringArray.length() > 0 && stringArray.charAt(0) == '.') {
                if (n3 == stringArray2.length) {
                    String[] stringArray3 = new String[stringArray2.length + 1024];
                    System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
                    stringArray2 = stringArray3;
                }
                stringArray2[n3++] = stringArray;
            }
            ++n2;
        }
        if (n3 != stringArray2.length) {
            stringArray = new String[n3];
            System.arraycopy(stringArray2, 0, stringArray, 0, n3);
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    static String getKeyValue(String string, boolean bl2) {
        TCHAR tCHAR = new TCHAR(0, string, true);
        int[] nArray = new int[1];
        if (OS.RegOpenKeyEx(Integer.MIN_VALUE, tCHAR, 0, 131097, nArray) != 0) {
            return null;
        }
        String string2 = null;
        int[] nArray2 = new int[1];
        if (OS.RegQueryValueEx(nArray[0], (TCHAR)null, 0, null, (TCHAR)null, nArray2) == 0) {
            TCHAR tCHAR2;
            string2 = "";
            int n2 = nArray2[0] / TCHAR.sizeof;
            if (nArray2[0] % TCHAR.sizeof != 0) {
                ++n2;
            }
            if (n2 != 0 && OS.RegQueryValueEx(nArray[0], null, 0, null, tCHAR2 = new TCHAR(0, n2), nArray2) == 0) {
                if (!OS.IsWinCE && bl2) {
                    n2 = OS.ExpandEnvironmentStrings(tCHAR2, null, 0);
                    if (n2 != 0) {
                        TCHAR tCHAR3 = new TCHAR(0, n2);
                        OS.ExpandEnvironmentStrings(tCHAR2, tCHAR3, n2);
                        string2 = tCHAR3.toString(0, Math.max(0, n2 - 1));
                    }
                } else {
                    n2 = Math.max(0, tCHAR2.length() - 1);
                    string2 = tCHAR2.toString(0, n2);
                }
            }
        }
        if (nArray[0] != 0) {
            OS.RegCloseKey(nArray[0]);
        }
        return string2;
    }

    static Program getProgram(String string, String string2) {
        String string3 = Program.getKeyValue(string, false);
        if (string3 == null || string3.length() == 0) {
            string3 = string;
        }
        String string4 = "\\shell";
        String string5 = Program.getKeyValue(string + string4, true);
        if (string5 == null || string5.length() == 0) {
            string5 = "open";
        }
        String string6 = "\\shell\\" + string5 + "\\command";
        String string7 = Program.getKeyValue(string + string6, true);
        if (string7 == null || string7.length() == 0) {
            return null;
        }
        String string8 = "\\DefaultIcon";
        String string9 = Program.getKeyValue(string + string8, true);
        if (string9 == null) {
            string9 = "";
        }
        Program program = new Program();
        program.name = string3;
        program.command = string7;
        program.iconName = string9;
        program.extension = string2;
        return program;
    }

    public static Program[] getPrograms() {
        LinkedHashSet<Program> linkedHashSet = new LinkedHashSet<Program>(1024);
        TCHAR tCHAR = new TCHAR(0, 1024);
        int[] nArray = new int[]{tCHAR.length()};
        FILETIME fILETIME = new FILETIME();
        int n2 = 0;
        while (OS.RegEnumKeyEx(Integer.MIN_VALUE, n2, tCHAR, nArray, null, null, null, fILETIME) != 259) {
            String string = tCHAR.toString(0, nArray[0]);
            nArray[0] = tCHAR.length();
            Program program = Program.getProgram(string, null);
            if (program != null) {
                linkedHashSet.add(program);
            }
            ++n2;
        }
        return linkedHashSet.toArray(new Program[linkedHashSet.size()]);
    }

    public static boolean launch(String string) {
        return Program.launch(string, null);
    }

    public static boolean launch(String string, String string2) {
        Object object;
        if (string == null) {
            SWT.error(4);
        }
        int n2 = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(0, string, true);
        int n3 = tCHAR.length() * TCHAR.sizeof;
        int n4 = OS.HeapAlloc(n2, 8, n3);
        OS.MoveMemory(n4, tCHAR, n3);
        int n5 = 0;
        if (string2 != null && OS.PathIsExe(n4)) {
            object = new TCHAR(0, string2, true);
            n3 = ((TCHAR)object).length() * TCHAR.sizeof;
            n5 = OS.HeapAlloc(n2, 8, n3);
            OS.MoveMemory(n5, (TCHAR)object, n3);
        }
        object = new SHELLEXECUTEINFO();
        ((SHELLEXECUTEINFO)object).cbSize = SHELLEXECUTEINFO.sizeof;
        ((SHELLEXECUTEINFO)object).lpFile = n4;
        ((SHELLEXECUTEINFO)object).lpDirectory = n5;
        ((SHELLEXECUTEINFO)object).nShow = 5;
        boolean bl2 = OS.ShellExecuteEx((SHELLEXECUTEINFO)object);
        if (n4 != 0) {
            OS.HeapFree(n2, 0, n4);
        }
        if (n5 != 0) {
            OS.HeapFree(n2, 0, n5);
        }
        return bl2;
    }

    public boolean execute(String string) {
        if (string == null) {
            SWT.error(4);
        }
        boolean bl2 = true;
        String string2 = this.command;
        String string3 = "";
        for (int i2 = 0; i2 < ARGUMENTS.length; ++i2) {
            int n2 = this.command.indexOf(ARGUMENTS[i2]);
            if (n2 == -1) continue;
            bl2 = false;
            string2 = this.command.substring(0, n2);
            string3 = this.command.substring(n2 + ARGUMENTS[i2].length(), this.command.length());
            break;
        }
        if (bl2) {
            string = " \"" + string + "\"";
        }
        String string4 = string2 + string + string3;
        int n3 = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(0, string4, true);
        int n4 = tCHAR.length() * TCHAR.sizeof;
        int n5 = OS.HeapAlloc(n3, 8, n4);
        OS.MoveMemory(n5, tCHAR, n4);
        STARTUPINFO sTARTUPINFO = new STARTUPINFO();
        sTARTUPINFO.cb = STARTUPINFO.sizeof;
        PROCESS_INFORMATION pROCESS_INFORMATION = new PROCESS_INFORMATION();
        boolean bl3 = OS.CreateProcess(0, n5, 0, 0, false, 0, 0, 0, sTARTUPINFO, pROCESS_INFORMATION);
        if (n5 != 0) {
            OS.HeapFree(n3, 0, n5);
        }
        if (pROCESS_INFORMATION.hProcess != 0) {
            OS.CloseHandle(pROCESS_INFORMATION.hProcess);
        }
        if (pROCESS_INFORMATION.hThread != 0) {
            OS.CloseHandle(pROCESS_INFORMATION.hThread);
        }
        return bl3;
    }

    public ImageData getImageData() {
        int n2;
        if (this.extension != null) {
            SHFILEINFO sHFILEINFO = OS.IsUnicode ? new SHFILEINFOW() : new SHFILEINFOA();
            int n3 = 273;
            TCHAR tCHAR = new TCHAR(0, this.extension, true);
            OS.SHGetFileInfo(tCHAR, 128, sHFILEINFO, SHFILEINFO.sizeof, n3);
            if (sHFILEINFO.hIcon != 0) {
                Image image = Image.win32_new(null, 1, sHFILEINFO.hIcon);
                ImageData imageData = image.getImageData();
                image.dispose();
                return imageData;
            }
        }
        int n4 = 0;
        String string = this.iconName;
        int n5 = this.iconName.indexOf(44);
        if (n5 != -1) {
            string = this.iconName.substring(0, n5);
            String string2 = this.iconName.substring(n5 + 1, this.iconName.length()).trim();
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((n2 = string.length()) > 1 && string.charAt(0) == '\"' && string.charAt(n2 - 1) == '\"') {
            string = string.substring(1, n2 - 1);
        }
        TCHAR tCHAR = new TCHAR(0, string, true);
        int[] nArray = new int[1];
        int[] nArray2 = null;
        OS.ExtractIconEx(tCHAR, n4, nArray2, nArray, 1);
        if (nArray[0] == 0) {
            return null;
        }
        Image image = Image.win32_new(null, 1, nArray[0]);
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Program) {
            Program program = (Program)object;
            return this.name.equals(program.name) && this.command.equals(program.command) && this.iconName.equals(program.iconName);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.iconName.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

