/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Slider
extends Control {
    int increment;
    int pageIncrement;
    boolean ignoreFocus;
    static final int ScrollBarProc;
    static final TCHAR ScrollBarClass;

    public Slider(Composite composite, int n2) {
        super(composite, Slider.checkStyle(n2));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        switch (n3) {
            case 513: 
            case 515: {
                this.display.runDeferredEvents();
            }
        }
        return OS.CallWindowProc(ScrollBarProc, n2, n3, n4, n5);
    }

    static int checkStyle(int n2) {
        return Slider.checkBits(n2, 256, 512, 0, 0, 0, 0);
    }

    @Override
    Point computeSizeInPixels(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = this.getBorderWidthInPixels();
        int n5 = n4 * 2;
        int n6 = n4 * 2;
        if ((this.style & 0x100) != 0) {
            n5 += OS.GetSystemMetrics(21) * 10;
            n6 += OS.GetSystemMetrics(3);
        } else {
            n5 += OS.GetSystemMetrics(2);
            n6 += OS.GetSystemMetrics(20) * 10;
        }
        if (n2 != -1) {
            n5 = n2 + n4 * 2;
        }
        if (n3 != -1) {
            n6 = n3 + n4 * 2;
        }
        return new Point(n5, n6);
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.increment = 1;
        this.pageIncrement = 10;
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 23;
        sCROLLINFO.nMax = 100;
        sCROLLINFO.nPage = 11;
        OS.SetScrollInfo(this.handle, 2, sCROLLINFO, true);
    }

    @Override
    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_SCROLLBAR);
    }

    @Override
    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_BTNFACE);
    }

    @Override
    void enableWidget(boolean bl2) {
        super.enableWidget(bl2);
        if (!OS.IsWinCE) {
            int n2 = bl2 ? 0 : 3;
            OS.EnableScrollBar(this.handle, 2, n2);
        }
        this.state = bl2 ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
    }

    @Override
    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 1;
        OS.GetScrollInfo(this.handle, 2, sCROLLINFO);
        return sCROLLINFO.nMax;
    }

    public int getMinimum() {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 1;
        OS.GetScrollInfo(this.handle, 2, sCROLLINFO);
        return sCROLLINFO.nMin;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 4;
        OS.GetScrollInfo(this.handle, 2, sCROLLINFO);
        return sCROLLINFO.nPos;
    }

    public int getThumb() {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 2;
        OS.GetScrollInfo(this.handle, 2, sCROLLINFO);
        if (sCROLLINFO.nPage != 0) {
            --sCROLLINFO.nPage;
        }
        return sCROLLINFO.nPage;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    @Override
    void setBoundsInPixels(int n2, int n3, int n4, int n5, int n6) {
        super.setBoundsInPixels(n2, n3, n4, n5, n6);
        if (OS.GetFocus() == this.handle) {
            this.ignoreFocus = true;
            OS.SendMessage(this.handle, 7, 0, 0);
            this.ignoreFocus = false;
        }
    }

    public void setIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.increment = n2;
    }

    public void setMaximum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 9;
        OS.GetScrollInfo(this.handle, 2, sCROLLINFO);
        if (n2 - sCROLLINFO.nMin - sCROLLINFO.nPage < 1) {
            return;
        }
        sCROLLINFO.nMax = n2;
        this.SetScrollInfo(this.handle, 2, sCROLLINFO, true);
    }

    public void setMinimum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 9;
        OS.GetScrollInfo(this.handle, 2, sCROLLINFO);
        if (sCROLLINFO.nMax - n2 - sCROLLINFO.nPage < 1) {
            return;
        }
        sCROLLINFO.nMin = n2;
        this.SetScrollInfo(this.handle, 2, sCROLLINFO, true);
    }

    public void setPageIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.pageIncrement = n2;
    }

    boolean SetScrollInfo(int n2, int n3, SCROLLINFO sCROLLINFO, boolean bl2) {
        if ((this.state & 8) != 0) {
            bl2 = false;
        }
        boolean bl3 = OS.SetScrollInfo(n2, n3, sCROLLINFO, bl2);
        if ((this.state & 8) != 0) {
            OS.EnableWindow(this.handle, false);
            if (!OS.IsWinCE) {
                OS.EnableScrollBar(this.handle, 2, 3);
            }
        }
        if (OS.GetFocus() == this.handle) {
            this.ignoreFocus = true;
            OS.SendMessage(this.handle, 7, 0, 0);
            this.ignoreFocus = false;
        }
        return bl3;
    }

    public void setSelection(int n2) {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 4;
        sCROLLINFO.nPos = n2;
        this.SetScrollInfo(this.handle, 2, sCROLLINFO, true);
    }

    public void setThumb(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 11;
        OS.GetScrollInfo(this.handle, 2, sCROLLINFO);
        sCROLLINFO.nPage = n2;
        if (sCROLLINFO.nPage != 0) {
            ++sCROLLINFO.nPage;
        }
        this.SetScrollInfo(this.handle, 2, sCROLLINFO, true);
    }

    public void setValues(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.checkWidget();
        if (n3 < 0) {
            return;
        }
        if (n4 < 0) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        if (n7 < 1) {
            return;
        }
        this.increment = n6;
        this.pageIncrement = n7;
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 15;
        sCROLLINFO.nPos = n2;
        sCROLLINFO.nMin = n3;
        sCROLLINFO.nMax = n4;
        sCROLLINFO.nPage = n5;
        if (sCROLLINFO.nPage != 0) {
            ++sCROLLINFO.nPage;
        }
        this.SetScrollInfo(this.handle, 2, sCROLLINFO, true);
    }

    @Override
    int widgetExtStyle() {
        int n2 = super.widgetExtStyle();
        if ((this.style & 0x800) != 0) {
            n2 &= 0xFFFFFDFF;
        }
        return n2;
    }

    @Override
    int widgetStyle() {
        int n2 = super.widgetStyle() | 0x10000;
        if ((this.style & 0x800) != 0) {
            n2 &= 0xFF7FFFFF;
        }
        if ((this.style & 0x100) != 0) {
            return n2 | 0;
        }
        return n2 | 1;
    }

    @Override
    TCHAR windowClass() {
        return ScrollBarClass;
    }

    @Override
    int windowProc() {
        return ScrollBarProc;
    }

    @Override
    LRESULT WM_KEYDOWN(int n2, int n3) {
        LRESULT lRESULT = super.WM_KEYDOWN(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 0x200) != 0) {
            return lRESULT;
        }
        if ((this.style & 0x8000000) != 0) {
            switch (n2) {
                case 37: 
                case 39: {
                    int n4 = n2 == 37 ? 39 : 37;
                    int n5 = this.callWindowProc(this.handle, 256, n4, n3);
                    return new LRESULT(n5);
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_LBUTTONDBLCLK(int n2, int n3) {
        int n4 = OS.GetWindowLong(this.handle, -16);
        int n5 = n4 & 0xFFFEFFFF;
        OS.SetWindowLong(this.handle, -16, n5);
        LRESULT lRESULT = super.WM_LBUTTONDBLCLK(n2, n3);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        OS.SetWindowLong(this.handle, -16, n4);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (!OS.IsWinCE) {
            if (OS.GetCapture() == this.handle) {
                OS.ReleaseCapture();
            }
            if (!this.sendMouseEvent(4, 1, this.handle, 514, n2, n3)) {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        int n4 = OS.GetWindowLong(this.handle, -16);
        int n5 = n4 & 0xFFFEFFFF;
        OS.SetWindowLong(this.handle, -16, n5);
        LRESULT lRESULT = super.WM_LBUTTONDOWN(n2, n3);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        OS.SetWindowLong(this.handle, -16, n4);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (!OS.IsWinCE) {
            if (OS.GetCapture() == this.handle) {
                OS.ReleaseCapture();
            }
            if (!this.sendMouseEvent(4, 1, this.handle, 514, n2, n3)) {
                return LRESULT.ONE;
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SETFOCUS(int n2, int n3) {
        if (this.ignoreFocus) {
            return null;
        }
        return super.WM_SETFOCUS(n2, n3);
    }

    @Override
    LRESULT wmScrollChild(int n2, int n3) {
        int n4 = OS.LOWORD(n2);
        if (n4 == 8) {
            return null;
        }
        Event event = new Event();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 21;
        OS.GetScrollInfo(this.handle, 2, sCROLLINFO);
        sCROLLINFO.fMask = 4;
        switch (n4) {
            case 4: {
                event.detail = 0;
                sCROLLINFO.nPos = sCROLLINFO.nTrackPos;
                break;
            }
            case 5: {
                event.detail = 1;
                sCROLLINFO.nPos = sCROLLINFO.nTrackPos;
                break;
            }
            case 6: {
                event.detail = 0x1000007;
                sCROLLINFO.nPos = sCROLLINFO.nMin;
                break;
            }
            case 7: {
                event.detail = 0x1000008;
                sCROLLINFO.nPos = sCROLLINFO.nMax;
                break;
            }
            case 1: {
                event.detail = 0x1000002;
                sCROLLINFO.nPos += this.increment;
                break;
            }
            case 0: {
                event.detail = 0x1000001;
                sCROLLINFO.nPos = Math.max(sCROLLINFO.nMin, sCROLLINFO.nPos - this.increment);
                break;
            }
            case 3: {
                event.detail = 0x1000006;
                sCROLLINFO.nPos += this.pageIncrement;
                break;
            }
            case 2: {
                event.detail = 0x1000005;
                sCROLLINFO.nPos = Math.max(sCROLLINFO.nMin, sCROLLINFO.nPos - this.pageIncrement);
            }
        }
        OS.SetScrollInfo(this.handle, 2, sCROLLINFO, true);
        this.sendSelectionEvent(13, event, true);
        return null;
    }

    static {
        ScrollBarClass = new TCHAR(0, "SCROLLBAR", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, ScrollBarClass, wNDCLASS);
        ScrollBarProc = wNDCLASS.lpfnWndProc;
    }
}

