/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TCITEM;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    TabFolder parent;
    Control control;
    String toolTipText;

    public TabItem(TabFolder tabFolder, int n2) {
        super(tabFolder, n2);
        this.parent = tabFolder;
        tabFolder.createItem(this, tabFolder.getItemCount());
    }

    public TabItem(TabFolder tabFolder, int n2, int n3) {
        super(tabFolder, n2);
        this.parent = tabFolder;
        tabFolder.createItem(this, n3);
    }

    void _setText(int n2, String string) {
        int n3;
        int n4;
        if (OS.COMCTL32_MAJOR >= 6 && this.image != null && string.indexOf(38) != -1) {
            n4 = string.length();
            char[] cArray = new char[n4];
            string.getChars(0, n4, cArray, 0);
            int n5 = 0;
            n3 = 0;
            for (n5 = 0; n5 < n4; ++n5) {
                if (cArray[n5] == '&') continue;
                cArray[n3++] = cArray[n5];
            }
            if (n3 < n5) {
                string = new String(cArray, 0, n3);
            }
        }
        n4 = this.parent.handle;
        int n6 = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), string, true);
        n3 = tCHAR.length() * TCHAR.sizeof;
        int n7 = OS.HeapAlloc(n6, 8, n3);
        OS.MoveMemory(n7, tCHAR, n3);
        TCITEM tCITEM = new TCITEM();
        tCITEM.mask = 1;
        tCITEM.pszText = n7;
        OS.SendMessage(n4, OS.TCM_SETITEM, n2, tCITEM);
        OS.HeapFree(n6, 0, n7);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rECT = new RECT();
        OS.SendMessage(this.parent.handle, 4874, n2, rECT);
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        int n2 = this.parent.indexOf(this);
        if (n2 == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
    }

    public void setControl(Control control) {
        int n2;
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control control2 = this.control;
        Control control3 = control;
        this.control = control;
        int n3 = this.parent.indexOf(this);
        if (n3 != (n2 = this.parent.getSelectionIndex()) && control3 != null) {
            Control control4;
            if (n2 != -1 && (control4 = this.parent.getItem(n2).getControl()) == control3) {
                return;
            }
            control3.setVisible(false);
            return;
        }
        if (control3 != null) {
            control3.setBounds(this.parent.getClientAreaInPixels());
            control3.setVisible(true);
        }
        if (control2 != null && control3 != null && control2 != control3) {
            control2.setVisible(false);
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        super.setImage(image);
        if (OS.COMCTL32_MAJOR >= 6 && this.text.indexOf(38) != -1) {
            this._setText(n2, this.text);
        }
        int n3 = this.parent.handle;
        TCITEM tCITEM = new TCITEM();
        tCITEM.mask = 2;
        tCITEM.iImage = this.parent.imageIndex(image);
        OS.SendMessage(n3, OS.TCM_SETITEM, n2, tCITEM);
    }

    @Override
    public void setText(String string) {
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        int n3 = this.parent.indexOf(this);
        if (n3 == -1) {
            return;
        }
        super.setText(string);
        int n4 = n2 = (this.state & 0x400000) != 0 ? 0x6000000 : this.style & Integer.MIN_VALUE;
        if (!this.updateTextDirection(n2)) {
            this._setText(n3, string);
        }
    }

    @Override
    boolean updateTextDirection(int n2) {
        int n3;
        if (super.updateTextDirection(n2) && OS.IsUnicode && (n3 = this.parent.indexOf(this)) != -1) {
            if ((n2 & 0x4000000) != 0) {
                this._setText(n3, '\u202b' + this.text);
                return true;
            }
            if ((n2 & 0x2000000) != 0) {
                this._setText(n3, '\u202a' + this.text);
                return true;
            }
        }
        return false;
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }
}

