/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSA;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem$1;

public class TaskItem
extends Item {
    TaskBar parent;
    Shell shell;
    int progress;
    int progressState = -1;
    Image overlayImage;
    String overlayText = "";
    boolean showingText = false;
    Menu menu;
    static final int PROGRESS_MAX = 100;

    TaskItem(TaskBar taskBar, int n2) {
        super(taskBar, n2);
        this.parent = taskBar;
        taskBar.createItem(this, -1);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    @Override
    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Image getOverlayImage() {
        this.checkWidget();
        return this.overlayImage;
    }

    public String getOverlayText() {
        this.checkWidget();
        return this.overlayText;
    }

    public TaskBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getProgress() {
        this.checkWidget();
        return this.progress;
    }

    public int getProgressState() {
        this.checkWidget();
        return this.progressState;
    }

    void recreate() {
        if (this.showingText) {
            if (this.overlayText.length() != 0) {
                this.updateText();
            }
        } else if (this.overlayImage != null) {
            this.updateImage();
        }
        if (this.progress != 0) {
            this.updateProgress();
        }
        if (this.progressState != -1) {
            this.updateProgressState();
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.overlayImage = null;
        this.overlayText = null;
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
        }
        if (this.shell != null) {
            return;
        }
        this.menu = menu;
        this.parent.setMenu(menu);
    }

    public void setOverlayImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (this.shell == null) {
            return;
        }
        this.overlayImage = image;
        if (image != null) {
            this.updateImage();
        } else if (this.overlayText.length() != 0) {
            this.updateText();
        } else {
            int n2 = this.parent.mTaskbarList3;
            int n3 = this.shell.handle;
            OS.VtblCall(18, n2, n3, 0, 0);
        }
    }

    public void setOverlayText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.shell == null) {
            return;
        }
        this.overlayText = string;
        if (string.length() != 0) {
            this.updateText();
        } else if (this.overlayImage != null) {
            this.updateImage();
        } else {
            int n2 = this.parent.mTaskbarList3;
            int n3 = this.shell.handle;
            OS.VtblCall(18, n2, n3, 0, 0);
        }
    }

    public void setProgress(int n2) {
        this.checkWidget();
        if (this.shell == null) {
            return;
        }
        if (this.progress == (n2 = Math.max(0, Math.min(n2, 100)))) {
            return;
        }
        this.progress = n2;
        this.updateProgress();
    }

    public void setProgressState(int n2) {
        this.checkWidget();
        if (this.shell == null) {
            return;
        }
        if (this.progressState == n2) {
            return;
        }
        this.progressState = n2;
        this.updateProgressState();
    }

    void setShell(Shell shell) {
        this.shell = shell;
        shell.addListener(12, new TaskItem$1(this));
    }

    void updateImage() {
        this.showingText = false;
        Image image = null;
        int n2 = 0;
        switch (this.overlayImage.type) {
            case 0: {
                image = Display.createIcon(this.overlayImage);
                n2 = image.handle;
                break;
            }
            case 1: {
                n2 = this.overlayImage.handle;
            }
        }
        int n3 = this.parent.mTaskbarList3;
        int n4 = this.shell.handle;
        OS.VtblCall(18, n3, n4, n2, 0);
        if (image != null) {
            image.dispose();
        }
    }

    void updateProgress() {
        if (this.progressState == 2) {
            return;
        }
        if (this.progressState == -1) {
            return;
        }
        int n2 = this.parent.mTaskbarList3;
        int n3 = this.shell.handle;
        OS.VtblCall(9, n2, n3, (long)this.progress, 100L);
    }

    void updateProgressState() {
        int n2 = 0;
        switch (this.progressState) {
            case 0: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 8;
                break;
            }
            case 2: {
                n2 = 1;
            }
        }
        int n3 = this.parent.mTaskbarList3;
        int n4 = this.shell.handle;
        OS.VtblCall(9, n3, n4, (long)this.progress, 100L);
        OS.VtblCall(10, n3, n4, n2);
    }

    void updateText() {
        this.showingText = true;
        int n2 = 16;
        int n3 = 16;
        int n4 = OS.GetDC(0);
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = n2;
        bITMAPINFOHEADER.biHeight = -n3;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)32;
        bITMAPINFOHEADER.biCompression = 0;
        byte[] byArray = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        int[] nArray = new int[1];
        int n5 = OS.CreateDIBSection(0, byArray, 0, nArray, 0, 0);
        if (n5 == 0) {
            this.error(2);
        }
        int n6 = OS.CreateCompatibleDC(n4);
        int n7 = OS.SelectObject(n6, n5);
        int n8 = OS.CreateBitmap(n2, n3, 1, 1, null);
        if (n8 == 0) {
            this.error(2);
        }
        int n9 = OS.CreateCompatibleDC(n4);
        int n10 = OS.SelectObject(n9, n8);
        OS.PatBlt(n9, 0, 0, n2, n3, 16711778);
        int n11 = OS.SelectObject(n9, OS.GetStockObject(4));
        OS.RoundRect(n9, 0, 0, n2, n3, 8, 8);
        OS.SelectObject(n9, n11);
        int n12 = OS.CreateSolidBrush(OS.GetSysColor(OS.COLOR_HIGHLIGHT));
        n11 = OS.SelectObject(n6, n12);
        OS.RoundRect(n6, 0, 0, n2, n3, 8, 8);
        OS.SelectObject(n6, n11);
        OS.DeleteObject(n12);
        int n13 = 2080;
        RECT rECT = new RECT();
        TCHAR tCHAR = new TCHAR(this.shell.getCodePage(), this.overlayText, false);
        int n14 = tCHAR.length();
        int n15 = 0;
        int n16 = 0;
        NONCLIENTMETRICS nONCLIENTMETRICS = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
        nONCLIENTMETRICS.cbSize = NONCLIENTMETRICS.sizeof;
        if (OS.SystemParametersInfo(41, 0, nONCLIENTMETRICS, 0)) {
            LOGFONT lOGFONT = OS.IsUnicode ? nONCLIENTMETRICS.lfMessageFont : ((NONCLIENTMETRICSA)nONCLIENTMETRICS).lfMessageFont;
            lOGFONT.lfHeight = -10;
            n15 = OS.CreateFontIndirect(lOGFONT);
            n16 = OS.SelectObject(n6, n15);
            OS.DrawText(n6, tCHAR, n14, rECT, n13 | 0x400);
            if (rECT.right > n2 - 2) {
                OS.SelectObject(n6, n16);
                OS.DeleteObject(n15);
                lOGFONT.lfHeight = -8;
                n15 = OS.CreateFontIndirect(lOGFONT);
                OS.SelectObject(n6, n15);
            }
        }
        OS.DrawText(n6, tCHAR, n14, rECT, n13 | 0x400);
        OS.OffsetRect(rECT, (n2 - rECT.right) / 2, (n3 - rECT.bottom) / 2);
        int n17 = OS.SetBkMode(n6, 1);
        OS.SetTextColor(n6, OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT));
        OS.DrawText(n6, tCHAR, n14, rECT, n13);
        if (n15 != 0) {
            OS.SelectObject(n6, n16);
            OS.DeleteObject(n15);
        }
        OS.SetBkMode(n6, n17);
        OS.SelectObject(n6, n7);
        OS.DeleteDC(n6);
        OS.SelectObject(n9, n10);
        OS.DeleteDC(n9);
        OS.ReleaseDC(0, n4);
        ICONINFO iCONINFO = new ICONINFO();
        iCONINFO.fIcon = true;
        iCONINFO.hbmColor = n5;
        iCONINFO.hbmMask = n8;
        int n18 = OS.CreateIconIndirect(iCONINFO);
        if (n18 == 0) {
            this.error(2);
        }
        OS.DeleteObject(n5);
        OS.DeleteObject(n8);
        int n19 = this.parent.mTaskbarList3;
        int n20 = this.shell.handle;
        OS.VtblCall(18, n19, n20, n18, 0);
        OS.DestroyIcon(n18);
    }
}

