/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.ByteBuffer;
import org.lwjgl.glfw.GLFWNativeX11$Functions;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GLFWNativeX11 {
    protected GLFWNativeX11() {
        throw new UnsupportedOperationException();
    }

    public static long glfwGetX11Display() {
        long l2 = GLFWNativeX11$Functions.GetX11Display;
        return JNI.invokeP(l2);
    }

    public static long glfwGetX11Adapter(long l2) {
        long l3 = GLFWNativeX11$Functions.GetX11Adapter;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePN(l2, l3);
    }

    public static long glfwGetX11Monitor(long l2) {
        long l3 = GLFWNativeX11$Functions.GetX11Monitor;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePN(l2, l3);
    }

    public static long glfwGetX11Window(long l2) {
        long l3 = GLFWNativeX11$Functions.GetX11Window;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePN(l2, l3);
    }

    public static void nglfwSetX11SelectionString(long l2) {
        long l3 = GLFWNativeX11$Functions.SetX11SelectionString;
        JNI.invokePV(l2, l3);
    }

    public static void glfwSetX11SelectionString(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        GLFWNativeX11.nglfwSetX11SelectionString(MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glfwSetX11SelectionString(CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            GLFWNativeX11.nglfwSetX11SelectionString(l2);
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nglfwGetX11SelectionString() {
        long l2 = GLFWNativeX11$Functions.GetX11SelectionString;
        return JNI.invokeP(l2);
    }

    public static String glfwGetX11SelectionString() {
        long l2 = GLFWNativeX11.nglfwGetX11SelectionString();
        return MemoryUtil.memUTF8Safe(l2);
    }
}

