/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libc;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;

public class LibCString {
    protected LibCString() {
        throw new UnsupportedOperationException();
    }

    public static native long nmemset(long var0, int var2, long var3);

    public static long memset(ByteBuffer byteBuffer, int n2) {
        return LibCString.nmemset(MemoryUtil.memAddress(byteBuffer), n2, (long)byteBuffer.remaining());
    }

    public static long memset(ShortBuffer shortBuffer, int n2) {
        return LibCString.nmemset(MemoryUtil.memAddress(shortBuffer), n2, Integer.toUnsignedLong(shortBuffer.remaining()) << 1);
    }

    public static long memset(IntBuffer intBuffer, int n2) {
        return LibCString.nmemset(MemoryUtil.memAddress(intBuffer), n2, Integer.toUnsignedLong(intBuffer.remaining()) << 2);
    }

    public static long memset(LongBuffer longBuffer, int n2) {
        return LibCString.nmemset(MemoryUtil.memAddress(longBuffer), n2, Integer.toUnsignedLong(longBuffer.remaining()) << 3);
    }

    public static long memset(FloatBuffer floatBuffer, int n2) {
        return LibCString.nmemset(MemoryUtil.memAddress(floatBuffer), n2, Integer.toUnsignedLong(floatBuffer.remaining()) << 2);
    }

    public static long memset(DoubleBuffer doubleBuffer, int n2) {
        return LibCString.nmemset(MemoryUtil.memAddress(doubleBuffer), n2, Integer.toUnsignedLong(doubleBuffer.remaining()) << 3);
    }

    public static native long nmemcpy(long var0, long var2, long var4);

    public static long memcpy(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)byteBuffer, byteBuffer2.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(byteBuffer2), (long)byteBuffer2.remaining());
    }

    public static long memcpy(ShortBuffer shortBuffer, ShortBuffer shortBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)shortBuffer, shortBuffer2.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(shortBuffer), MemoryUtil.memAddress(shortBuffer2), Integer.toUnsignedLong(shortBuffer2.remaining()) << 1);
    }

    public static long memcpy(IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, intBuffer2.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), Integer.toUnsignedLong(intBuffer2.remaining()) << 2);
    }

    public static long memcpy(LongBuffer longBuffer, LongBuffer longBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)longBuffer, longBuffer2.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(longBuffer), MemoryUtil.memAddress(longBuffer2), Integer.toUnsignedLong(longBuffer2.remaining()) << 3);
    }

    public static long memcpy(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, floatBuffer2.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(floatBuffer), MemoryUtil.memAddress(floatBuffer2), Integer.toUnsignedLong(floatBuffer2.remaining()) << 2);
    }

    public static long memcpy(DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)doubleBuffer, doubleBuffer2.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(doubleBuffer), MemoryUtil.memAddress(doubleBuffer2), Integer.toUnsignedLong(doubleBuffer2.remaining()) << 3);
    }

    public static native long nmemmove(long var0, long var2, long var4);

    public static long memmove(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)byteBuffer, byteBuffer2.remaining());
        }
        return LibCString.nmemmove(MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(byteBuffer2), (long)byteBuffer2.remaining());
    }

    public static long memmove(ShortBuffer shortBuffer, ShortBuffer shortBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)shortBuffer, shortBuffer2.remaining());
        }
        return LibCString.nmemmove(MemoryUtil.memAddress(shortBuffer), MemoryUtil.memAddress(shortBuffer2), Integer.toUnsignedLong(shortBuffer2.remaining()) << 1);
    }

    public static long memmove(IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, intBuffer2.remaining());
        }
        return LibCString.nmemmove(MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(intBuffer2), Integer.toUnsignedLong(intBuffer2.remaining()) << 2);
    }

    public static long memmove(LongBuffer longBuffer, LongBuffer longBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)longBuffer, longBuffer2.remaining());
        }
        return LibCString.nmemmove(MemoryUtil.memAddress(longBuffer), MemoryUtil.memAddress(longBuffer2), Integer.toUnsignedLong(longBuffer2.remaining()) << 3);
    }

    public static long memmove(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)floatBuffer, floatBuffer2.remaining());
        }
        return LibCString.nmemmove(MemoryUtil.memAddress(floatBuffer), MemoryUtil.memAddress(floatBuffer2), Integer.toUnsignedLong(floatBuffer2.remaining()) << 2);
    }

    public static long memmove(DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)doubleBuffer, doubleBuffer2.remaining());
        }
        return LibCString.nmemmove(MemoryUtil.memAddress(doubleBuffer), MemoryUtil.memAddress(doubleBuffer2), Integer.toUnsignedLong(doubleBuffer2.remaining()) << 3);
    }

    public static native long nstrlen(long var0);

    public static long strlen(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return LibCString.nstrlen(MemoryUtil.memAddress(byteBuffer));
    }

    public static native long nstrerror(int var0);

    public static String strerror(int n2) {
        long l2 = LibCString.nstrerror(n2);
        return MemoryUtil.memASCIISafe(l2);
    }

    public static native long nmemset(byte[] var0, int var1, long var2);

    public static long memset(byte[] byArray, int n2) {
        return LibCString.nmemset(byArray, n2, Integer.toUnsignedLong(byArray.length) << 0);
    }

    public static native long nmemset(short[] var0, int var1, long var2);

    public static long memset(short[] sArray, int n2) {
        return LibCString.nmemset(sArray, n2, Integer.toUnsignedLong(sArray.length) << 1);
    }

    public static native long nmemset(int[] var0, int var1, long var2);

    public static long memset(int[] nArray, int n2) {
        return LibCString.nmemset(nArray, n2, Integer.toUnsignedLong(nArray.length) << 2);
    }

    public static native long nmemset(long[] var0, int var1, long var2);

    public static long memset(long[] lArray, int n2) {
        return LibCString.nmemset(lArray, n2, Integer.toUnsignedLong(lArray.length) << 3);
    }

    public static native long nmemset(float[] var0, int var1, long var2);

    public static long memset(float[] fArray, int n2) {
        return LibCString.nmemset(fArray, n2, Integer.toUnsignedLong(fArray.length) << 2);
    }

    public static native long nmemset(double[] var0, int var1, long var2);

    public static long memset(double[] dArray, int n2) {
        return LibCString.nmemset(dArray, n2, Integer.toUnsignedLong(dArray.length) << 3);
    }

    public static native long nmemcpy(byte[] var0, byte[] var1, long var2);

    public static long memcpy(byte[] byArray, byte[] byArray2) {
        if (Checks.CHECKS) {
            Checks.check(byArray, byArray2.length);
        }
        return LibCString.nmemcpy(byArray, byArray2, Integer.toUnsignedLong(byArray2.length) << 0);
    }

    public static native long nmemcpy(short[] var0, short[] var1, long var2);

    public static long memcpy(short[] sArray, short[] sArray2) {
        if (Checks.CHECKS) {
            Checks.check(sArray, sArray2.length);
        }
        return LibCString.nmemcpy(sArray, sArray2, Integer.toUnsignedLong(sArray2.length) << 1);
    }

    public static native long nmemcpy(int[] var0, int[] var1, long var2);

    public static long memcpy(int[] nArray, int[] nArray2) {
        if (Checks.CHECKS) {
            Checks.check(nArray, nArray2.length);
        }
        return LibCString.nmemcpy(nArray, nArray2, Integer.toUnsignedLong(nArray2.length) << 2);
    }

    public static native long nmemcpy(long[] var0, long[] var1, long var2);

    public static long memcpy(long[] lArray, long[] lArray2) {
        if (Checks.CHECKS) {
            Checks.check(lArray, lArray2.length);
        }
        return LibCString.nmemcpy(lArray, lArray2, Integer.toUnsignedLong(lArray2.length) << 3);
    }

    public static native long nmemcpy(float[] var0, float[] var1, long var2);

    public static long memcpy(float[] fArray, float[] fArray2) {
        if (Checks.CHECKS) {
            Checks.check(fArray, fArray2.length);
        }
        return LibCString.nmemcpy(fArray, fArray2, Integer.toUnsignedLong(fArray2.length) << 2);
    }

    public static native long nmemcpy(double[] var0, double[] var1, long var2);

    public static long memcpy(double[] dArray, double[] dArray2) {
        if (Checks.CHECKS) {
            Checks.check(dArray, dArray2.length);
        }
        return LibCString.nmemcpy(dArray, dArray2, Integer.toUnsignedLong(dArray2.length) << 3);
    }

    public static native long nmemmove(byte[] var0, byte[] var1, long var2);

    public static long memmove(byte[] byArray, byte[] byArray2) {
        if (Checks.CHECKS) {
            Checks.check(byArray, byArray2.length);
        }
        return LibCString.nmemmove(byArray, byArray2, Integer.toUnsignedLong(byArray2.length) << 0);
    }

    public static native long nmemmove(short[] var0, short[] var1, long var2);

    public static long memmove(short[] sArray, short[] sArray2) {
        if (Checks.CHECKS) {
            Checks.check(sArray, sArray2.length);
        }
        return LibCString.nmemmove(sArray, sArray2, Integer.toUnsignedLong(sArray2.length) << 1);
    }

    public static native long nmemmove(int[] var0, int[] var1, long var2);

    public static long memmove(int[] nArray, int[] nArray2) {
        if (Checks.CHECKS) {
            Checks.check(nArray, nArray2.length);
        }
        return LibCString.nmemmove(nArray, nArray2, Integer.toUnsignedLong(nArray2.length) << 2);
    }

    public static native long nmemmove(long[] var0, long[] var1, long var2);

    public static long memmove(long[] lArray, long[] lArray2) {
        if (Checks.CHECKS) {
            Checks.check(lArray, lArray2.length);
        }
        return LibCString.nmemmove(lArray, lArray2, Integer.toUnsignedLong(lArray2.length) << 3);
    }

    public static native long nmemmove(float[] var0, float[] var1, long var2);

    public static long memmove(float[] fArray, float[] fArray2) {
        if (Checks.CHECKS) {
            Checks.check(fArray, fArray2.length);
        }
        return LibCString.nmemmove(fArray, fArray2, Integer.toUnsignedLong(fArray2.length) << 2);
    }

    public static native long nmemmove(double[] var0, double[] var1, long var2);

    public static long memmove(double[] dArray, double[] dArray2) {
        if (Checks.CHECKS) {
            Checks.check(dArray, dArray2.length);
        }
        return LibCString.nmemmove(dArray, dArray2, Integer.toUnsignedLong(dArray2.length) << 3);
    }

    public static long memset(CustomBuffer customBuffer, int n2) {
        return LibCString.nmemset(MemoryUtil.memAddress(customBuffer), n2, Integer.toUnsignedLong(customBuffer.remaining()) * (long)customBuffer.sizeof());
    }

    public static long memcpy(CustomBuffer customBuffer, CustomBuffer customBuffer2) {
        if (Checks.CHECKS) {
            Checks.check(customBuffer2, customBuffer.remaining());
        }
        return LibCString.nmemcpy(MemoryUtil.memAddress(customBuffer), MemoryUtil.memAddress(customBuffer2), (long)customBuffer2.remaining() * (long)customBuffer2.sizeof());
    }

    public static long memmove(CustomBuffer customBuffer, CustomBuffer customBuffer2) {
        if (Checks.CHECKS) {
            Checks.check(customBuffer2, customBuffer.remaining());
        }
        return LibCString.nmemmove(MemoryUtil.memAddress(customBuffer), MemoryUtil.memAddress(customBuffer2), (long)customBuffer2.remaining() * (long)customBuffer2.sizeof());
    }

    static {
        Library.initialize();
    }
}

