/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.CLongBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.macosx.CGEventTapCallBackI;
import org.lwjgl.system.macosx.CGEventTapInformation$Buffer;
import org.lwjgl.system.macosx.CGPoint;
import org.lwjgl.system.macosx.CoreGraphics$Functions;

public class CoreGraphics {
    private static final SharedLibrary COREGRAPHICS = Library.loadNative(CoreGraphics.class, "org.lwjgl", "/System/Library/Frameworks/CoreGraphics.framework");
    public static final int kCGErrorSuccess = 0;
    public static final int kCGErrorFailure = 1000;
    public static final int kCGErrorIllegalArgument = 1001;
    public static final int kCGErrorInvalidConnection = 1002;
    public static final int kCGErrorInvalidContext = 1003;
    public static final int kCGErrorCannotComplete = 1004;
    public static final int kCGErrorNotImplemented = 1006;
    public static final int kCGErrorRangeCheck = 1007;
    public static final int kCGErrorTypeCheck = 1008;
    public static final int kCGErrorInvalidOperation = 1010;
    public static final int kCGErrorNoneAvailable = 1011;
    public static final int kCGEventNull = 0;
    public static final int kCGEventLeftMouseDown = 1;
    public static final int kCGEventLeftMouseUp = 2;
    public static final int kCGEventRightMouseDown = 3;
    public static final int kCGEventRightMouseUp = 4;
    public static final int kCGEventMouseMoved = 5;
    public static final int kCGEventLeftMouseDragged = 6;
    public static final int kCGEventRightMouseDragged = 7;
    public static final int kCGEventKeyDown = 10;
    public static final int kCGEventKeyUp = 11;
    public static final int kCGEventFlagsChanged = 12;
    public static final int kCGEventScrollWheel = 22;
    public static final int kCGEventTabletPointer = 23;
    public static final int kCGEventTabletProximity = 24;
    public static final int kCGEventOtherMouseDown = 25;
    public static final int kCGEventOtherMouseUp = 26;
    public static final int kCGEventOtherMouseDragged = 27;
    public static final int kCGEventTapDisabledByTimeout = -2;
    public static final int kCGEventTapDisabledByUserInput = -1;
    public static final int kCGMouseButtonLeft = 0;
    public static final int kCGMouseButtonRight = 1;
    public static final int kCGMouseButtonCenter = 2;
    public static final int kCGHIDEventTap = 0;
    public static final int kCGSessionEventTap = 1;
    public static final int kCGAnnotatedSessionEventTap = 2;
    public static final int kCGScrollEventUnitPixel = 0;
    public static final int kCGScrollEventUnitLine = 1;
    public static final int kCGMouseEventNumber = 0;
    public static final int kCGMouseEventClickState = 1;
    public static final int kCGMouseEventPressure = 2;
    public static final int kCGMouseEventButtonNumber = 3;
    public static final int kCGMouseEventDeltaX = 4;
    public static final int kCGMouseEventDeltaY = 5;
    public static final int kCGMouseEventInstantMouser = 6;
    public static final int kCGMouseEventSubtype = 7;
    public static final int kCGKeyboardEventAutorepeat = 8;
    public static final int kCGKeyboardEventKeycode = 9;
    public static final int kCGKeyboardEventKeyboardType = 10;
    public static final int kCGScrollWheelEventDeltaAxis1 = 11;
    public static final int kCGScrollWheelEventDeltaAxis2 = 12;
    public static final int kCGScrollWheelEventDeltaAxis3 = 13;
    public static final int kCGScrollWheelEventFixedPtDeltaAxis1 = 93;
    public static final int kCGScrollWheelEventFixedPtDeltaAxis2 = 94;
    public static final int kCGScrollWheelEventFixedPtDeltaAxis3 = 95;
    public static final int kCGScrollWheelEventPointDeltaAxis1 = 96;
    public static final int kCGScrollWheelEventPointDeltaAxis2 = 97;
    public static final int kCGScrollWheelEventPointDeltaAxis3 = 98;
    public static final int kCGScrollWheelEventScrollPhase = 99;
    public static final int kCGScrollWheelEventScrollCount = 100;
    public static final int kCGScrollWheelEventMomentumPhase = 123;
    public static final int kCGScrollWheelEventInstantMouser = 14;
    public static final int kCGTabletEventPointX = 15;
    public static final int kCGTabletEventPointY = 16;
    public static final int kCGTabletEventPointZ = 17;
    public static final int kCGTabletEventPointButtons = 18;
    public static final int kCGTabletEventPointPressure = 19;
    public static final int kCGTabletEventTiltX = 20;
    public static final int kCGTabletEventTiltY = 21;
    public static final int kCGTabletEventRotation = 22;
    public static final int kCGTabletEventTangentialPressure = 23;
    public static final int kCGTabletEventDeviceID = 24;
    public static final int kCGTabletEventVendor1 = 25;
    public static final int kCGTabletEventVendor2 = 26;
    public static final int kCGTabletEventVendor3 = 27;
    public static final int kCGTabletProximityEventVendorID = 28;
    public static final int kCGTabletProximityEventTabletID = 29;
    public static final int kCGTabletProximityEventPointerID = 30;
    public static final int kCGTabletProximityEventDeviceID = 31;
    public static final int kCGTabletProximityEventSystemTabletID = 32;
    public static final int kCGTabletProximityEventVendorPointerType = 33;
    public static final int kCGTabletProximityEventVendorPointerSerialNumber = 34;
    public static final int kCGTabletProximityEventVendorUniqueID = 35;
    public static final int kCGTabletProximityEventCapabilityMask = 36;
    public static final int kCGTabletProximityEventPointerType = 37;
    public static final int kCGTabletProximityEventEnterProximity = 38;
    public static final int kCGEventTargetProcessSerialNumber = 39;
    public static final int kCGEventTargetUnixProcessID = 40;
    public static final int kCGEventSourceUnixProcessID = 41;
    public static final int kCGEventSourceUserData = 42;
    public static final int kCGEventSourceUserID = 43;
    public static final int kCGEventSourceGroupID = 44;
    public static final int kCGEventSourceStateID = 45;
    public static final int kCGScrollWheelEventIsContinuous = 88;
    public static final int kCGMouseEventWindowUnderMousePointer = 91;
    public static final int kCGMouseEventWindowUnderMousePointerThatCanHandleThisEvent = 92;
    public static final int kCGEventMouseSubtypeDefault = 0;
    public static final int kCGEventMouseSubtypeTabletPoint = 1;
    public static final int kCGEventMouseSubtypeTabletProximity = 2;

    public static SharedLibrary getLibrary() {
        return COREGRAPHICS;
    }

    protected CoreGraphics() {
        throw new UnsupportedOperationException();
    }

    public static long CGEventGetTypeID() {
        long l2 = CoreGraphics$Functions.EventGetTypeID;
        return JNI.invokeJ(l2);
    }

    public static long CGEventCreate(long l2) {
        long l3 = CoreGraphics$Functions.EventCreate;
        return JNI.invokePP(l2, l3);
    }

    public static long CGEventCreateData(long l2, long l3) {
        long l4 = CoreGraphics$Functions.EventCreateData;
        return JNI.invokePPP(l2, l3, l4);
    }

    public static long CGEventCreateFromData(long l2, long l3) {
        long l4 = CoreGraphics$Functions.EventCreateFromData;
        return JNI.invokePPP(l2, l3, l4);
    }

    public static native long nCGEventCreateMouseEvent(long var0, int var2, long var3, int var5, long var6);

    public static long nCGEventCreateMouseEvent(long l2, int n2, long l3, int n3) {
        long l4 = CoreGraphics$Functions.EventCreateMouseEvent;
        return CoreGraphics.nCGEventCreateMouseEvent(l2, n2, l3, n3, l4);
    }

    public static long CGEventCreateMouseEvent(long l2, int n2, CGPoint cGPoint, int n3) {
        return CoreGraphics.nCGEventCreateMouseEvent(l2, n2, cGPoint.address(), n3);
    }

    public static long CGEventCreateKeyboardEvent(long l2, short s2, boolean bl2) {
        long l3 = CoreGraphics$Functions.EventCreateKeyboardEvent;
        return JNI.invokePCP(l2, s2, bl2, l3);
    }

    public static long CGEventCreateScrollWheelEvent(long l2, int n2, int n3, int n4) {
        long l3 = CoreGraphics$Functions.EventCreateScrollWheelEvent;
        return JNI.invokePP(l2, n2, n3, n4, l3);
    }

    public static long CGEventCreateScrollWheelEvent(long l2, int n2, int n3) {
        long l3 = CoreGraphics$Functions.EventCreateScrollWheelEvent;
        return JNI.invokePP(l2, n2, 1, n3, l3);
    }

    public static long CGEventCreateScrollWheelEvent2(long l2, int n2, int n3, int n4, int n5, int n6) {
        long l3 = CoreGraphics$Functions.EventCreateScrollWheelEvent2;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.invokePP(l2, n2, n3, n4, n5, n6, l3);
    }

    public static long CGEventCreateCopy(long l2) {
        long l3 = CoreGraphics$Functions.EventCreateCopy;
        return JNI.invokePP(l2, l3);
    }

    public static long CGEventCreateSourceFromEvent(long l2) {
        long l3 = CoreGraphics$Functions.EventCreateSourceFromEvent;
        return JNI.invokePP(l2, l3);
    }

    public static void CGEventSetSource(long l2, long l3) {
        long l4 = CoreGraphics$Functions.EventSetSource;
        JNI.invokePPV(l2, l3, l4);
    }

    public static int CGEventGetType(long l2) {
        long l3 = CoreGraphics$Functions.EventGetType;
        return JNI.invokePI(l2, l3);
    }

    public static void CGEventSetType(long l2, int n2) {
        long l3 = CoreGraphics$Functions.EventSetType;
        JNI.invokePV(l2, n2, l3);
    }

    public static long CGEventGetTimestamp(long l2) {
        long l3 = CoreGraphics$Functions.EventGetTimestamp;
        return JNI.invokePJ(l2, l3);
    }

    public static void CGEventSetTimestamp(long l2, long l3) {
        long l4 = CoreGraphics$Functions.EventSetTimestamp;
        JNI.invokePJV(l2, l3, l4);
    }

    public static native void nCGEventGetLocation(long var0, long var2, long var4);

    public static void nCGEventGetLocation(long l2, long l3) {
        long l4 = CoreGraphics$Functions.EventGetLocation;
        CoreGraphics.nCGEventGetLocation(l2, l4, l3);
    }

    public static CGPoint CGEventGetLocation(long l2, CGPoint cGPoint) {
        CoreGraphics.nCGEventGetLocation(l2, cGPoint.address());
        return cGPoint;
    }

    public static native void nCGEventGetUnflippedLocation(long var0, long var2, long var4);

    public static void nCGEventGetUnflippedLocation(long l2, long l3) {
        long l4 = CoreGraphics$Functions.EventGetUnflippedLocation;
        CoreGraphics.nCGEventGetUnflippedLocation(l2, l4, l3);
    }

    public static CGPoint CGEventGetUnflippedLocation(long l2, CGPoint cGPoint) {
        CoreGraphics.nCGEventGetUnflippedLocation(l2, cGPoint.address());
        return cGPoint;
    }

    public static native void nCGEventSetLocation(long var0, long var2, long var4);

    public static void nCGEventSetLocation(long l2, long l3) {
        long l4 = CoreGraphics$Functions.EventSetLocation;
        CoreGraphics.nCGEventSetLocation(l2, l3, l4);
    }

    public static void CGEventSetLocation(long l2, CGPoint cGPoint) {
        CoreGraphics.nCGEventSetLocation(l2, cGPoint.address());
    }

    public static long CGEventGetFlags(long l2) {
        long l3 = CoreGraphics$Functions.EventGetFlags;
        return JNI.invokePJ(l2, l3);
    }

    public static void CGEventSetFlags(long l2, long l3) {
        long l4 = CoreGraphics$Functions.EventSetFlags;
        JNI.invokePJV(l2, l3, l4);
    }

    public static void nCGEventKeyboardGetUnicodeString(long l2, long l3, long l4, long l5) {
        long l6 = CoreGraphics$Functions.EventKeyboardGetUnicodeString;
        JNI.invokePNPPV(l2, l3, l4, l5, l6);
    }

    public static void CGEventKeyboardGetUnicodeString(long l2, CLongBuffer cLongBuffer, ShortBuffer shortBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)cLongBuffer, 1);
        }
        CoreGraphics.nCGEventKeyboardGetUnicodeString(l2, Checks.remainingSafe(shortBuffer), MemoryUtil.memAddressSafe(cLongBuffer), MemoryUtil.memAddressSafe(shortBuffer));
    }

    public static void nCGEventKeyboardSetUnicodeString(long l2, long l3, long l4) {
        long l5 = CoreGraphics$Functions.EventKeyboardSetUnicodeString;
        JNI.invokePNPV(l2, l3, l4, l5);
    }

    public static void CGEventKeyboardSetUnicodeString(long l2, ShortBuffer shortBuffer) {
        CoreGraphics.nCGEventKeyboardSetUnicodeString(l2, shortBuffer.remaining(), MemoryUtil.memAddress(shortBuffer));
    }

    public static long CGEventGetIntegerValueField(long l2, int n2) {
        long l3 = CoreGraphics$Functions.EventGetIntegerValueField;
        return JNI.invokePJ(l2, n2, l3);
    }

    public static void CGEventSetIntegerValueField(long l2, int n2, long l3) {
        long l4 = CoreGraphics$Functions.EventSetIntegerValueField;
        JNI.invokePJV(l2, n2, l3, l4);
    }

    public static double CGEventGetDoubleValueField(long l2, int n2) {
        long l3 = CoreGraphics$Functions.EventGetDoubleValueField;
        return JNI.invokePD(l2, n2, l3);
    }

    public static void CGEventSetDoubleValueField(long l2, int n2, double d2) {
        long l3 = CoreGraphics$Functions.EventSetDoubleValueField;
        JNI.invokePV(l2, n2, d2, l3);
    }

    public static long nCGEventTapCreate(int n2, int n3, int n4, long l2, long l3, long l4) {
        long l5 = CoreGraphics$Functions.EventTapCreate;
        return JNI.invokeJPPP(n2, n3, n4, l2, l3, l4, l5);
    }

    public static long CGEventTapCreate(int n2, int n3, int n4, long l2, CGEventTapCallBackI cGEventTapCallBackI, long l3) {
        return CoreGraphics.nCGEventTapCreate(n2, n3, n4, l2, cGEventTapCallBackI.address(), l3);
    }

    public static long nCGEventTapCreateForPid(long l2, int n2, int n3, long l3, long l4, long l5) {
        long l6 = CoreGraphics$Functions.EventTapCreateForPid;
        if (Checks.CHECKS) {
            Checks.check(l6);
            Checks.check(l2);
        }
        return JNI.invokePJPPP(l2, n2, n3, l3, l4, l5, l6);
    }

    public static long CGEventTapCreateForPid(long l2, int n2, int n3, long l3, CGEventTapCallBackI cGEventTapCallBackI, long l4) {
        return CoreGraphics.nCGEventTapCreateForPid(l2, n2, n3, l3, cGEventTapCallBackI.address(), l4);
    }

    public static void CGEventTapEnable(long l2, boolean bl2) {
        long l3 = CoreGraphics$Functions.EventTapEnable;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, bl2, l3);
    }

    public static boolean CGEventTapIsEnabled(long l2) {
        long l3 = CoreGraphics$Functions.EventTapIsEnabled;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePZ(l2, l3);
    }

    public static void CGEventTapPostEvent(long l2, long l3) {
        long l4 = CoreGraphics$Functions.EventTapPostEvent;
        JNI.invokePPV(l2, l3, l4);
    }

    public static void CGEventPost(int n2, long l2) {
        long l3 = CoreGraphics$Functions.EventPost;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(n2, l2, l3);
    }

    public static void CGEventPostToPid(long l2, long l3) {
        long l4 = CoreGraphics$Functions.EventPostToPid;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l2);
        }
        JNI.invokePPV(l2, l3, l4);
    }

    public static int nCGGetEventTapList(int n2, long l2, long l3) {
        long l4 = CoreGraphics$Functions.GetEventTapList;
        return JNI.invokePPI(n2, l2, l3, l4);
    }

    public static int CGGetEventTapList(CGEventTapInformation$Buffer cGEventTapInformation$Buffer, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, 1);
        }
        return CoreGraphics.nCGGetEventTapList(Checks.remainingSafe(cGEventTapInformation$Buffer), MemoryUtil.memAddressSafe(cGEventTapInformation$Buffer), MemoryUtil.memAddressSafe(intBuffer));
    }

    public static void CGEventKeyboardGetUnicodeString(long l2, CLongBuffer cLongBuffer, short[] sArray) {
        long l3 = CoreGraphics$Functions.EventKeyboardGetUnicodeString;
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)cLongBuffer, 1);
        }
        JNI.invokePNPPV(l2, (long)Checks.lengthSafe(sArray), MemoryUtil.memAddressSafe(cLongBuffer), sArray, l3);
    }

    public static void CGEventKeyboardSetUnicodeString(long l2, short[] sArray) {
        long l3 = CoreGraphics$Functions.EventKeyboardSetUnicodeString;
        JNI.invokePNPV(l2, (long)sArray.length, sArray, l3);
    }

    public static int CGGetEventTapList(CGEventTapInformation$Buffer cGEventTapInformation$Buffer, int[] nArray) {
        long l2 = CoreGraphics$Functions.GetEventTapList;
        if (Checks.CHECKS) {
            Checks.checkSafe(nArray, 1);
        }
        return JNI.invokePPI(Checks.remainingSafe(cGEventTapInformation$Buffer), MemoryUtil.memAddressSafe(cGEventTapInformation$Buffer), nArray, l2);
    }

    static /* synthetic */ SharedLibrary access$000() {
        return COREGRAPHICS;
    }
}

