/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.Vector4f;
import java.util.Vector;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;

public class Group
extends Node {
    Vector children = new Vector();

    @Override
    protected Object3D duplicateObject() {
        Group clone = (Group)super.duplicateObject();
        clone.children = (Vector)this.children.clone();
        for (int i = clone.getChildCount() - 1; i >= 0; --i) {
            Node oldChild = clone.getChild(i);
            Node newChild = (Node)clone.getChild(i).duplicateObject();
            clone.removeReference(oldChild);
            clone.addReference(newChild);
            newChild.parent = clone;
            clone.children.set(i, newChild);
        }
        return clone;
    }

    public void addChild(Node child) {
        if (child == null) {
            throw new NullPointerException();
        }
        if (child == this) {
            throw new IllegalArgumentException("child is this Group");
        }
        if (child instanceof World) {
            throw new IllegalArgumentException("child is a World node");
        }
        if (child.parent != null && child.parent != this) {
            throw new IllegalArgumentException("child already has a parent other than this Group");
        }
        if (child.isParentOf(this)) {
            throw new IllegalArgumentException("child is an ancestor of this Group");
        }
        if (!this.children.contains(child)) {
            this.children.add(child);
            child.parent = this;
            this.addReference(child);
        }
    }

    public void removeChild(Node child) {
        if (child != null) {
            if (child.isSkinnedMeshBone()) {
                throw new IllegalArgumentException();
            }
            if (this.children.contains(child)) {
                this.children.remove(child);
                child.parent = null;
                this.removeReference(child);
            }
        }
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Node getChild(int index) {
        if (index < 0 || index >= this.getChildCount()) {
            throw new IndexOutOfBoundsException();
        }
        return (Node)this.children.get(index);
    }

    @Override
    protected void alignment(Node reference) {
        super.alignment(reference);
        for (int i = 0; i < this.children.size(); ++i) {
            ((Node)this.children.get(i)).alignment(reference);
        }
    }

    public boolean pick(int scope, float x, float y, Camera camera, RayIntersection ri) {
        if (camera == null) {
            throw new NullPointerException();
        }
        if (camera.getRoot() != this.getRoot()) {
            throw new IllegalStateException();
        }
        if (!this.isPickingEnabled()) {
            return false;
        }
        Vector4f rayStart = new Vector4f(2.0f * x - 1.0f, 1.0f - 2.0f * y, -1.0f, 1.0f);
        Vector4f rayEnd = new Vector4f(2.0f * x - 1.0f, 1.0f - 2.0f * y, 1.0f, 1.0f);
        Transform invProj = new Transform();
        camera.getProjection(invProj);
        invProj.getImpl_().invert();
        invProj.getImpl_().transform(rayStart);
        invProj.getImpl_().transform(rayEnd);
        rayStart.mul(1.0f / rayStart.w);
        rayEnd.mul(1.0f / rayEnd.w);
        float[] ray = new float[8];
        ray[6] = rayStart.z;
        ray[7] = rayEnd.z;
        Transform camToGroup = new Transform();
        camera.getTransformTo(this, camToGroup);
        camToGroup.getImpl_().transform(rayStart);
        camToGroup.getImpl_().transform(rayEnd);
        rayStart.mul(1.0f / rayStart.w);
        rayEnd.mul(1.0f / rayEnd.w);
        ray[0] = rayStart.x;
        ray[1] = rayStart.y;
        ray[2] = rayStart.z;
        ray[3] = rayEnd.x;
        ray[4] = rayEnd.y;
        ray[5] = rayEnd.z;
        if (ri == null) {
            ri = new RayIntersection();
        }
        ri.startPick(ray, x, y, camera);
        camToGroup.setIdentity();
        return this.rayIntersect(scope, ray, ri, camToGroup);
    }

    public boolean pick(int scope, float ox, float oy, float oz, float dx, float dy, float dz, RayIntersection ri) {
        if (dx == 0.0f && dy == 0.0f && dz == 0.0f) {
            throw new IllegalArgumentException();
        }
        if (!this.isPickingEnabled()) {
            return false;
        }
        float[] ray = new float[]{ox, oy, oz, ox + dx, oy + dy, oz + dz};
        Transform transform = new Transform();
        if (ri == null) {
            ri = new RayIntersection();
        }
        ri.startPick(ray, 0.0f, 0.0f, null);
        return this.rayIntersect(scope, ray, ri, transform);
    }

    @Override
    protected boolean rayIntersect(int scope, float[] ray, RayIntersection ri, Transform transform) {
        boolean hit = false;
        Transform childTransform = new Transform();
        Transform tmpTrans = new Transform();
        for (int i = 0; i < this.children.size(); ++i) {
            Node child = (Node)this.children.get(i);
            if (!child.isPickingEnabled()) continue;
            childTransform.set(transform);
            child.getCompositeTransform(tmpTrans);
            childTransform.postMultiply(tmpTrans);
            if (!child.rayIntersect(scope, ray, ri, childTransform)) continue;
            hit = true;
        }
        return hit;
    }

    @Override
    protected void updateAlignReferences() {
        super.updateAlignReferences();
        for (int var1 = 0; var1 < this.children.size(); ++var1) {
            ((Node)this.children.get(var1)).updateAlignReferences();
        }
    }

    @Override
    protected void clearAlignReferences() {
        super.clearAlignReferences();
        for (int var1 = 0; var1 < this.children.size(); ++var1) {
            ((Node)this.children.get(var1)).clearAlignReferences();
        }
    }
}

