/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.m3g.BoneTransform;
import emulator.graphics3D.m3g.MeshMorph;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;

public class SkinnedMesh
extends Mesh {
    Group skeleton;
    public Vector<BoneTransform> boneTransList;
    public int[] vtxBones;
    public int[] vtxWeights;

    public SkinnedMesh(VertexBuffer vertices, IndexBuffer submesh, Appearance appearance, Group skeleton) {
        super(vertices, submesh, appearance);
        if (skeleton == null) {
            throw new NullPointerException();
        }
        if (skeleton instanceof World || skeleton.getParent() != null) {
            throw new IllegalArgumentException();
        }
        this.skeleton = skeleton;
        this.skeleton.parent = this;
        this.addReference(this.skeleton);
        this.boneTransList = new Vector();
        this.vtxBones = new int[vertices.getVertexCount() * 4];
        this.vtxWeights = new int[vertices.getVertexCount() * 4];
    }

    public SkinnedMesh(VertexBuffer vertices, IndexBuffer[] submeshes, Appearance[] appearances, Group skeleton) {
        super(vertices, submeshes, appearances);
        if (skeleton == null) {
            throw new NullPointerException();
        }
        if (skeleton instanceof World || skeleton.getParent() != null) {
            throw new IllegalArgumentException();
        }
        this.skeleton = skeleton;
        this.skeleton.parent = this;
        this.addReference(this.skeleton);
        this.boneTransList = new Vector();
        this.vtxBones = new int[vertices.getVertexCount() * 4];
        this.vtxWeights = new int[vertices.getVertexCount() * 4];
    }

    public Group getSkeleton() {
        return this.skeleton;
    }

    @Override
    protected Object3D duplicateObject() {
        SkinnedMesh clone = (SkinnedMesh)super.duplicateObject();
        Group newSkeleton = (Group)clone.getSkeleton().duplicateObject();
        clone.removeReference(clone.skeleton);
        clone.addReference(newSkeleton);
        clone.skeleton = newSkeleton;
        newSkeleton.parent = clone;
        Hashtable oldToNewBone = new Hashtable();
        this.getOldToNewBonesMapping(oldToNewBone, this.skeleton, newSkeleton);
        clone.boneTransList = new Vector();
        for (int i = 0; i < this.boneTransList.size(); ++i) {
            BoneTransform oldBoneTrans = this.boneTransList.elementAt(i);
            BoneTransform newBoneTrans = new BoneTransform((Node)oldToNewBone.get(oldBoneTrans.bone), oldBoneTrans.toBoneTrans);
            clone.boneTransList.add(newBoneTrans);
        }
        clone.vtxBones = (int[])this.vtxBones.clone();
        clone.vtxWeights = (int[])this.vtxWeights.clone();
        return clone;
    }

    private void getOldToNewBonesMapping(Hashtable map, Node oldNode, Node newNode) {
        map.put(oldNode, newNode);
        if (oldNode instanceof Group) {
            Group oldGroup = (Group)oldNode;
            Group newGroup = (Group)newNode;
            for (int i = 0; i < oldGroup.getChildCount(); ++i) {
                Node oldChild = oldGroup.getChild(i);
                Node newChild = newGroup.getChild(i);
                this.getOldToNewBonesMapping(map, oldChild, newChild);
            }
        } else if (oldNode instanceof SkinnedMesh) {
            Group oldSkeleton = ((SkinnedMesh)oldNode).getSkeleton();
            Group newSkeleton = ((SkinnedMesh)newNode).getSkeleton();
            this.getOldToNewBonesMapping(map, oldSkeleton, newSkeleton);
        }
    }

    public void addTransform(Node bone, int weight, int firstVertex, int numVertices) {
        if (bone == null) {
            throw new NullPointerException();
        }
        if (bone != this.skeleton && !bone.isDescendantOf(this.skeleton)) {
            throw new IllegalArgumentException();
        }
        if (weight <= 0 || numVertices <= 0) {
            throw new IllegalArgumentException();
        }
        if (firstVertex < 0 || firstVertex + numVertices > 65535) {
            throw new IndexOutOfBoundsException();
        }
        BoneTransform boneTrans = null;
        int boneTransId = -1;
        for (int i = 0; i < this.boneTransList.size(); ++i) {
            BoneTransform tmpBoneTrans = this.boneTransList.elementAt(i);
            if (tmpBoneTrans.bone != bone) continue;
            boneTrans = tmpBoneTrans;
            boneTransId = i;
            break;
        }
        if (boneTrans == null) {
            Transform toBoneTrans = new Transform();
            if (!this.getTransformTo(bone, toBoneTrans)) {
                throw new ArithmeticException();
            }
            boneTrans = new BoneTransform(bone, toBoneTrans);
            this.boneTransList.add(boneTrans);
            boneTransId = this.boneTransList.size() - 1;
        }
        int transPerVtx = 4;
        for (int i = firstVertex; i < firstVertex + numVertices; ++i) {
            int minWeight = Integer.MAX_VALUE;
            int selSlot = -1;
            for (int slot = 0; slot < transPerVtx; ++slot) {
                int slotWeight = this.vtxWeights[i * transPerVtx + slot];
                if (this.vtxBones[i * transPerVtx + slot] == boneTransId + 1) {
                    selSlot = slot;
                    break;
                }
                if (slotWeight > minWeight) continue;
                minWeight = slotWeight;
                selSlot = slot;
                if (slotWeight == 0) break;
            }
            if (this.vtxBones[i * transPerVtx + selSlot] == boneTransId + 1) {
                int n = i * transPerVtx + selSlot;
                this.vtxWeights[n] = this.vtxWeights[n] + weight;
                continue;
            }
            if (minWeight > weight) {
                selSlot = -1;
            }
            if (selSlot == -1) continue;
            this.vtxBones[i * transPerVtx + selSlot] = boneTransId + 1;
            this.vtxWeights[i * transPerVtx + selSlot] = weight;
        }
        bone.setSkinnedMeshBone();
    }

    @Override
    protected void alignment(Node reference) {
        super.alignment(reference);
        this.skeleton.alignment(reference);
    }

    @Override
    protected boolean rayIntersect(int scope, float[] ray, RayIntersection ri, Transform transform) {
        MeshMorph.getInstance().getMorphedVertexBuffer((Mesh)this);
        MeshMorph.getInstance().clearCache();
        return super.rayIntersect(scope, ray, ri, transform, MeshMorph.getInstance().morphed) || this.skeleton.rayIntersect(scope, ray, ri, transform);
    }

    public Vector getTransforms() {
        return this.boneTransList;
    }

    public int[] getVerticesBones() {
        return this.vtxBones;
    }

    public int[] getVerticesWeights() {
        return this.vtxWeights;
    }

    public void getBoneTransform(Node bone, Transform transform) {
        if (bone == null) {
            throw new NullPointerException("bone");
        }
        if (transform == null) {
            throw new NullPointerException("transform");
        }
        if (bone != this.skeleton && !bone.isDescendantOf(this.skeleton)) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.boneTransList.size(); ++i) {
            BoneTransform boneTrans = this.boneTransList.elementAt(i);
            if (boneTrans.bone != bone) continue;
            transform.set(boneTrans.toBoneTrans);
            return;
        }
    }

    public int getBoneVertices(Node bone, int[] indices, float[] weights) {
        int boneIndex;
        if (bone == null) {
            throw new NullPointerException("bone");
        }
        if (bone != this.skeleton && !bone.isDescendantOf(this.skeleton)) {
            throw new IllegalArgumentException();
        }
        int boneCount = this.boneTransList.size();
        for (boneIndex = 0; boneIndex < boneCount && this.boneTransList.elementAt((int)boneIndex).bone != bone; ++boneIndex) {
        }
        if (boneIndex >= boneCount) {
            return 0;
        }
        int numVertices = this.vertices.getVertexCount();
        int count = 0;
        int transPerVtx = 4;
        for (int i = 0; i < numVertices; ++i) {
            int weight = 0;
            int sum = 0;
            for (int slot = 0; slot < 4; ++slot) {
                int tmpWeight = this.vtxWeights[i * 4 + slot];
                if (this.vtxBones[i * 4 + slot] == boneIndex + 1) {
                    weight = tmpWeight;
                }
                sum += tmpWeight;
            }
            if (weight <= 0) continue;
            if (indices != null && weights != null) {
                if (indices.length <= count || weights.length <= count) {
                    throw new IllegalArgumentException();
                }
                indices[count] = i;
                weights[count] = (float)weight / (float)sum;
            }
            ++count;
        }
        return count;
    }
}

