/*
 * Decompiled with CFR 0.152.
 */
package com.mascotcapsule.micro3d.v3;

import emulator.Emulator;
import emulator.graphics2D.IImage;
import java.io.IOException;
import ru.woesss.micro3d.PlatformHelper;

public class Texture {
    int nPointer;
    boolean isForModel;
    public IImage debugImage;

    public Texture(byte[] b, boolean isForModel) {
        if (b == null) {
            throw new NullPointerException();
        }
        this.nPointer = this.nInit(b, isForModel);
        if (this.nPointer == 0) {
            throw new RuntimeException();
        }
        this.loadDebugBitmap(b);
        this.isForModel = isForModel;
    }

    public Texture(String name, boolean isForModel) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        byte[] b = PlatformHelper.getResourceBytes((String)name);
        if (b == null) {
            throw new IOException("Resource \"" + name + "\" not found");
        }
        this.nPointer = this.nInit(b, isForModel);
        if (this.nPointer == 0) {
            throw new RuntimeException();
        }
        this.loadDebugBitmap(b);
        this.isForModel = isForModel;
    }

    public final void dispose() {
        if (this.nPointer != 0) {
            this.nFinalize();
            this.nPointer = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private void loadDebugBitmap(byte[] data) {
        try {
            boolean reversed;
            int numColors;
            int height;
            int width;
            int dibHeaderSize;
            int pos = 0;
            if ((data[pos++] & 0xFF) != 66 || (data[pos++] & 0xFF) != 77) {
                throw new RuntimeException("Not a BMP!");
            }
            pos += 8;
            int rasterOffset = data[pos++] & 0xFF | (data[pos++] & 0xFF) << 8 | (data[pos++] & 0xFF) << 16 | data[pos++] << 24;
            if ((dibHeaderSize = data[pos++] & 0xFF | (data[pos++] & 0xFF) << 8 | (data[pos++] & 0xFF) << 16 | data[pos++] << 24) == 12) {
                int bpp;
                width = data[pos++] & 0xFF | (data[pos++] & 0xFF) << 8;
                height = data[pos++] & 0xFF | (data[pos++] & 0xFF) << 8;
                pos += 2;
                if ((bpp = data[pos++] & 0xFF | (data[pos++] & 0xFF) << 8) != 8) {
                    throw new RuntimeException("Unsupported BMP format: bpp = " + bpp);
                }
                numColors = 256;
                reversed = true;
            } else if (dibHeaderSize == 40) {
                int compression;
                int h;
                width = data[pos++] & 0xFF | (data[pos++] & 0xFF) << 8 | (data[pos++] & 0xFF) << 16 | data[pos++] << 24;
                if ((h = data[pos++] & 0xFF | (data[pos++] & 0xFF) << 8 | (data[pos++] & 0xFF) << 16 | data[pos++] << 24) < 0) {
                    height = -h;
                    reversed = false;
                } else {
                    height = h;
                    reversed = true;
                }
                pos += 2;
                int bpp = data[pos++] & 0xFF | (data[pos++] & 0xFF) << 8;
                if (bpp != 8) {
                    throw new RuntimeException("Unsupported BMP format: bpp = " + bpp);
                }
                if ((compression = data[pos++] & 0xFF | (data[pos++] & 0xFF) << 8 | (data[pos++] & 0xFF) << 16 | data[pos++] << 24) != 0) {
                    throw new RuntimeException("Unsupported BMP format: compression = " + compression);
                }
                pos += 12;
                if ((numColors = data[pos++] & 0xFF | (data[pos++] & 0xFF) << 8 | (data[pos++] & 0xFF) << 16 | data[pos++] << 24) == 0) {
                    numColors = 256;
                }
                pos += 4;
            } else {
                throw new RuntimeException("Unsupported BMP version = " + dibHeaderSize);
            }
            int paletteOffset = 14 + dibHeaderSize;
            if (rasterOffset < paletteOffset + numColors * 4) {
                rasterOffset = paletteOffset + numColors * 4;
            }
            IImage image = Emulator.getEmulator().newImage(width, height, true);
            int[] rgb = image.getData();
            int remainder = width % 4;
            int stride = remainder == 0 ? width : width + 4 - remainder;
            int n = 0;
            if (reversed) {
                for (int i = height - 1; i >= 0; --i) {
                    int j;
                    int s = j + width;
                    for (j = rasterOffset + i * stride; j < s; ++j) {
                        byte idx = data[j];
                        int p = (idx & 0xFF) * 4 + paletteOffset;
                        byte b = data[p++];
                        byte g = data[p++];
                        byte r = data[p];
                        rgb[n++] = ((r & 0xFF) << 16) + ((g & 0xFF) << 8) + (b & 0xFF) + -16777216;
                    }
                }
            } else {
                for (int i = 0; i < height; ++i) {
                    int j;
                    int s = j + width;
                    for (j = rasterOffset + i * stride; j < s; ++j) {
                        byte idx = data[j];
                        int p = (idx & 0xFF) * 4 + paletteOffset;
                        byte b = data[p++];
                        byte g = data[p++];
                        byte r = data[p];
                        rgb[n++] = ((r & 0xFF) << 16) + ((g & 0xFF) << 8) + (b & 0xFF) + -16777216;
                    }
                }
            }
            this.debugImage = image;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private native int nInit(byte[] var1, boolean var2);

    private native void nFinalize();

    private static native void nInitClass();

    static {
        System.loadLibrary("java_micro3d_v3_32");
        Texture.nInitClass();
    }
}

