/*
 * Decompiled with CFR 0.152.
 */
package com.mascotcapsule.micro3d.v3;

import com.mascotcapsule.micro3d.v3.Effect3D;
import com.mascotcapsule.micro3d.v3.Figure;
import com.mascotcapsule.micro3d.v3.FigureLayout;
import com.mascotcapsule.micro3d.v3.RenderProxy;
import com.mascotcapsule.micro3d.v3.Texture;
import javax.microedition.lcdui.Graphics;
import ru.woesss.j2me.micro3d.Render;

public class Graphics3D {
    public static final int COMMAND_AFFINE_INDEX = -2030043136;
    public static final int COMMAND_AMBIENT_LIGHT = -1610612736;
    public static final int COMMAND_ATTRIBUTE = -2097152000;
    public static final int COMMAND_CENTER = -2063597568;
    public static final int COMMAND_CLIP = -2080374784;
    public static final int COMMAND_DIRECTION_LIGHT = -1593835520;
    public static final int COMMAND_END = Integer.MIN_VALUE;
    public static final int COMMAND_FLUSH = -2113929216;
    public static final int COMMAND_LIST_VERSION_1_0 = -33554431;
    public static final int COMMAND_NOP = -2130706432;
    public static final int COMMAND_PARALLEL_SCALE = -1879048192;
    public static final int COMMAND_PARALLEL_SIZE = -1862270976;
    public static final int COMMAND_PERSPECTIVE_FOV = -1845493760;
    public static final int COMMAND_PERSPECTIVE_WH = -1828716544;
    public static final int COMMAND_TEXTURE_INDEX = -2046820352;
    public static final int COMMAND_THRESHOLD = -1358954496;
    public static final int ENV_ATTR_LIGHTING = 1;
    public static final int ENV_ATTR_SEMI_TRANSPARENT = 8;
    public static final int ENV_ATTR_SPHERE_MAP = 2;
    public static final int ENV_ATTR_TOON_SHADING = 4;
    public static final int PATTR_BLEND_ADD = 64;
    public static final int PATTR_BLEND_HALF = 32;
    public static final int PATTR_BLEND_NORMAL = 0;
    public static final int PATTR_BLEND_SUB = 96;
    public static final int PATTR_COLORKEY = 16;
    public static final int PATTR_LIGHTING = 1;
    public static final int PATTR_SPHERE_MAP = 2;
    public static final int PDATA_COLOR_NONE = 0;
    public static final int PDATA_COLOR_PER_COMMAND = 1024;
    public static final int PDATA_COLOR_PER_FACE = 2048;
    public static final int PDATA_NORMAL_NONE = 0;
    public static final int PDATA_NORMAL_PER_FACE = 512;
    public static final int PDATA_NORMAL_PER_VERTEX = 768;
    public static final int PDATA_POINT_SPRITE_PARAMS_PER_CMD = 4096;
    public static final int PDATA_POINT_SPRITE_PARAMS_PER_FACE = 8192;
    public static final int PDATA_POINT_SPRITE_PARAMS_PER_VERTEX = 12288;
    public static final int PDATA_TEXURE_COORD = 12288;
    public static final int PDATA_TEXURE_COORD_NONE = 0;
    public static final int POINT_SPRITE_LOCAL_SIZE = 0;
    public static final int POINT_SPRITE_NO_PERS = 2;
    public static final int POINT_SPRITE_PERSPECTIVE = 0;
    public static final int POINT_SPRITE_PIXEL_SIZE = 1;
    public static final int PRIMITVE_LINES = 0x2000000;
    public static final int PRIMITVE_POINTS = 0x1000000;
    public static final int PRIMITVE_POINT_SPRITES = 0x5000000;
    public static final int PRIMITVE_QUADS = 0x4000000;
    public static final int PRIMITVE_TRIANGLES = 0x3000000;
    private Graphics graphics;
    private Render render;

    public final synchronized void bind(Graphics graphics) {
        if (graphics == null) {
            throw new NullPointerException("Argument 'Graphics' is NULL");
        }
        if (this.render != null) {
            throw new IllegalStateException("Target already bound");
        }
        this.render = Render.getRender();
        this.render.bind(graphics, true);
        this.graphics = graphics;
    }

    public final synchronized void bind(Graphics graphics, boolean bl2) {
        if (graphics == null) {
            throw new NullPointerException("Argument 'Graphics' is NULL");
        }
        this.render = Render.getRender();
        this.render.bind(graphics, bl2);
        this.graphics = graphics;
    }

    public final void dispose() {
    }

    public final void drawCommandList(Texture[] textureArray, int n2, int n3, FigureLayout figureLayout, Effect3D effect3D, int[] nArray) {
        this.checkTargetIsValid();
        if (figureLayout == null || effect3D == null || nArray == null) {
            throw new NullPointerException();
        }
        RenderProxy.getViewTrans(figureLayout.affine, this.render.getViewMatrix(), 0);
        RenderProxy.setTextureArray(this.render, textureArray);
        RenderProxy.setAffineArray(this.render, figureLayout.affineArray);
        this.render.setCenter(figureLayout.centerX + n2, figureLayout.centerY + n3);
        RenderProxy.setProjection(this.render, figureLayout);
        RenderProxy.setEffects(this.render, effect3D);
        this.render.drawCommandList(nArray);
    }

    public final void drawCommandList(Texture texture, int n2, int n3, FigureLayout figureLayout, Effect3D effect3D, int[] nArray) {
        this.checkTargetIsValid();
        if (figureLayout == null || effect3D == null || nArray == null) {
            throw new NullPointerException();
        }
        RenderProxy.getViewTrans(figureLayout.affine, this.render.getViewMatrix(), 0);
        RenderProxy.setAffineArray(this.render, figureLayout.affineArray);
        this.render.setCenter(figureLayout.centerX + n2, figureLayout.centerY + n3);
        RenderProxy.setProjection(this.render, figureLayout);
        RenderProxy.setEffects(this.render, effect3D);
        if (texture != null) {
            this.render.setTexture(texture.impl);
        }
        this.render.drawCommandList(nArray);
    }

    public final void drawFigure(Figure figure, int n2, int n3, FigureLayout figureLayout, Effect3D effect3D) {
        this.checkTargetIsValid();
        if (figure == null || figureLayout == null || effect3D == null) {
            throw new NullPointerException();
        }
        RenderProxy.getViewTrans(figureLayout.affine, this.render.getViewMatrix(), 0);
        this.render.setCenter(figureLayout.centerX + n2, figureLayout.centerY + n3);
        RenderProxy.setProjection(this.render, figureLayout);
        RenderProxy.setEffects(this.render, effect3D);
        Texture texture = figure.getTexture();
        if (texture != null) {
            this.render.setTexture(texture.impl);
        }
        this.render.drawFigure(figure.impl);
    }

    public final void flush() {
        this.checkTargetIsValid();
        this.render.flush();
    }

    public final synchronized void release(Graphics graphics) {
        if (graphics == null) {
            throw new NullPointerException("Argument 'Graphics' is NULL");
        }
        if (graphics != this.graphics) {
            if (this.render != null) {
                this.render.reset();
            }
            this.render = null;
            return;
        }
        if (this.render != null) {
            this.render.release();
        }
        this.render = null;
    }

    public final void renderFigure(Figure figure, int n2, int n3, FigureLayout figureLayout, Effect3D effect3D) {
        this.checkTargetIsValid();
        if (figure == null || figureLayout == null || effect3D == null) {
            throw new NullPointerException();
        }
        RenderProxy.getViewTrans(figureLayout.affine, this.render.getViewMatrix(), 0);
        RenderProxy.setTextureArray(this.render, figure.textures);
        this.render.setCenter(figureLayout.centerX + n2, figureLayout.centerY + n3);
        RenderProxy.setProjection(this.render, figureLayout);
        RenderProxy.setEffects(this.render, effect3D);
        this.render.postFigure(figure.impl);
    }

    public final void renderPrimitives(Texture texture, int n2, int n3, FigureLayout figureLayout, Effect3D effect3D, int n4, int n5, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        this.checkTargetIsValid();
        if (figureLayout == null || effect3D == null || nArray == null || nArray2 == null || nArray3 == null || nArray4 == null) {
            throw new NullPointerException();
        }
        if (n4 < 0 || n5 <= 0 || n5 >= 256) {
            throw new IllegalArgumentException();
        }
        RenderProxy.getViewTrans(figureLayout.affine, this.render.getViewMatrix(), 0);
        this.render.setCenter(figureLayout.centerX + n2, figureLayout.centerY + n3);
        RenderProxy.setProjection(this.render, figureLayout);
        RenderProxy.setEffects(this.render, effect3D);
        if (texture != null) {
            this.render.setTexture(texture.impl);
        }
        this.render.postPrimitives(n4 | n5 << 16, nArray, 0, nArray2, 0, nArray3, 0, nArray4, 0);
    }

    private void checkTargetIsValid() throws IllegalStateException {
        if (this.render == null) {
            throw new IllegalStateException("No target is bound");
        }
    }
}

